/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp;

import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleStreetAddress;
import com.mapinfo.mapmarker.autosuggest.utils.GeomUtil;
import com.mapinfo.mapmarker.autosuggest.utils.NumberRange;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class AddressUtil {
    public static final String RANGE_DELIMS = " -_/\\";
    private static final int MAX_RANGE_OFFSET_ALLOWED = 50;

    public static List<SimpleStreetAddress> combineAddresses(List<SimpleStreetAddress> addrs) {
        int s;
        int n = s = addrs == null ? 0 : addrs.size();
        if (s < 2) {
            return addrs;
        }
        Collections.sort(addrs);
        ArrayList<SimpleStreetAddress> newList = new ArrayList<SimpleStreetAddress>(addrs.size());
        SimpleStreetAddress lastAddr = addrs.get(0);
        newList.add(lastAddr);
        for (int i = 1; i < s; ++i) {
            SimpleStreetAddress curAddr = addrs.get(i);
            if (lastAddr.hasSameAddressFields(curAddr)) {
                lastAddr.addRange(curAddr.getRanges());
                AddressUtil.combineBounds(lastAddr, curAddr);
                continue;
            }
            newList.add(curAddr);
            lastAddr = curAddr;
        }
        return newList;
    }

    private static void combineBounds(SimpleStreetAddress addr1, SimpleStreetAddress addr2) {
        addr1.setBounds(GeomUtil.getExpandedRectangle(addr1.getBounds(), addr2.getBounds()));
    }

    public static int getNumericAddressNumber(String num) {
        return AddressUtil.getNumericPrefix(num);
    }

    public static int getNumericPrefix(String str) {
        int len = str == null ? 0 : str.length();
        int num = -1;
        if (len > 0) {
            int digit;
            int i = 0;
            if ((digit = Character.digit(str.charAt(i++), 10)) > -1) {
                num = digit;
                while (i < len && (digit = Character.digit(str.charAt(i++), 10)) > -1) {
                    num *= 10;
                    num += digit;
                }
            }
        }
        return num;
    }

    public static NumberRange convertToNumericRange(SimpleRange range) {
        int to;
        String fromStr = range.getFrom();
        String toStr = range.getTo();
        int from = MMUtils.isEmpty((String)fromStr) ? -1 : AddressUtil.getNumericAddressNumber(fromStr);
        int n = to = MMUtils.isEmpty((String)toStr) ? -1 : AddressUtil.getNumericAddressNumber(toStr);
        if (from > -1 && to > -1) {
            return AddressUtil.getNumberRange(from, to);
        }
        if (from > -1) {
            return AddressUtil.getNumberRange(from, from);
        }
        return null;
    }

    private static NumberRange getNumberRange(int from, int to) {
        if (from > to) {
            int t = from;
            from = to;
            to = t;
        }
        return new NumberRange(from, to);
    }

    public static String buildExtendedHouseNumber(String input, String house) {
        if (house == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(input, RANGE_DELIMS, true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!StringUtilities.equalStrings((String)token, (String)house) || !st.hasMoreTokens()) continue;
            String sep = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            String second = st.nextToken();
            if (!StringUtilities.isNumeric((String)house) || !StringUtilities.isNumeric((String)second)) continue;
            StringBuilder sb = new StringBuilder(house);
            sb.append(sep);
            sb.append(second);
            return sb.toString();
        }
        return null;
    }

    public static int getHNROffset(SimpleRange range, int hnr) {
        int offset = -1;
        String fromStr = range.getFrom();
        String toStr = range.getTo();
        if (fromStr != null && toStr != null) {
            int from = AddressUtil.getNumericAddressNumber(fromStr);
            int to = AddressUtil.getNumericAddressNumber(toStr);
            offset = hnr >= from && hnr <= to || hnr <= from && hnr >= to ? 0 : Math.min(Math.abs(from - hnr), Math.abs(to - hnr));
        } else if (fromStr != null) {
            offset = Math.abs(AddressUtil.getNumericAddressNumber(fromStr) - hnr);
        }
        return offset;
    }

    public static int getSecondNumberFromExtendedHnr(String extendedHNR) {
        if (extendedHNR != null) {
            StringTokenizer st = new StringTokenizer(extendedHNR, RANGE_DELIMS, false);
            if (st.hasMoreTokens()) {
                st.nextToken();
            }
            if (st.hasMoreTokens()) {
                String second = st.nextToken();
                return AddressUtil.getNumericAddressNumber(second);
            }
        }
        return -1;
    }

    public static boolean isExtendedHnr(String hnr) {
        return AddressUtil.getSecondNumberFromExtendedHnr(hnr) > -1;
    }

    public static boolean possibleExtendedHNRMatch(SimpleRange range, String inputHnr) {
        int second = AddressUtil.getSecondNumberFromExtendedHnr(inputHnr);
        if (second > -1) {
            int offset = AddressUtil.getHNROffset(range, second);
            return offset > -1 && offset <= 50;
        }
        return false;
    }

    public static boolean possibleExtendedHNRExactMatch(SimpleRange range, String extendedHNR) {
        StringTokenizer st;
        boolean extendedMatch = false;
        String fromStr = range.getFrom();
        String toStr = range.getTo();
        String fromHNR = null;
        String toHNR = null;
        if (extendedHNR != null && (st = new StringTokenizer(extendedHNR, RANGE_DELIMS, false)).hasMoreTokens()) {
            fromHNR = st.nextToken();
            if (st.hasMoreTokens()) {
                toHNR = st.nextToken();
            }
        }
        if (!StringUtilities.isEmpty((String)fromStr) && !StringUtilities.isEmpty((String)toStr) && (fromStr.equalsIgnoreCase(fromHNR) && toStr.equalsIgnoreCase(toHNR) || fromStr.equalsIgnoreCase(toHNR) && toStr.equalsIgnoreCase(fromHNR))) {
            return true;
        }
        return extendedMatch;
    }
}

