/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp;

import com.mapinfo.mapmarker.autosuggest.dp.AddressGeomItem;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.DiskQuadTreeItem;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.cgge.utils.io.DummyDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInputStream;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.IDataItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AreaGeomItem
implements DiskQuadTreeItem {
    private int m_areaID;
    private Rectangle m_bounds;
    private long m_addrItemsOffset = -1L;
    private List<AddressGeomItem> m_addrGeomItems;

    public AreaGeomItem(int areaID, Rectangle bounds) {
        this.m_areaID = areaID;
        this.m_bounds = bounds;
    }

    public void copyFrom(AreaGeomItem copy) {
        this.m_areaID = copy.m_areaID;
        this.m_bounds = copy.m_bounds;
        this.m_addrItemsOffset = copy.m_addrItemsOffset;
        this.m_addrGeomItems = copy.m_addrGeomItems;
    }

    public <T extends IDataItem> T getNewInstance() {
        return (T)new AreaGeomItem(-1, null);
    }

    public void write(ICGGEDataOutput out) throws IOException {
        this.m_bounds.write(out);
        out.writeVUnsignedLong((long)this.m_areaID);
        DummyDataOutput dummyOut = new DummyDataOutput();
        this.writeAddressItems((ICGGEDataOutput)dummyOut);
        out.writeVUnsignedInt(dummyOut.getOffset());
        this.writeAddressItems(out);
    }

    public void read(ICGGEDataInput in) throws IOException {
        this.m_bounds = new Rectangle();
        this.m_bounds.read(in);
        this.m_areaID = in.readVUnsignedInt();
        int skipBytes = in.readVUnsignedInt();
        this.m_addrItemsOffset = in.offset();
        in.skipBytes(skipBytes);
    }

    private void writeAddressItems(ICGGEDataOutput out) throws IllegalArgumentException, IOException {
        List<AddressGeomItem> addrItems = this.getAddressItems();
        int c = addrItems == null ? 0 : addrItems.size();
        out.writeVUnsignedInt(c);
        for (int i = 0; i < c; ++i) {
            addrItems.get(i).write(out);
        }
    }

    private List<AddressGeomItem> readAddressItems(ICGGEDataInput in) throws IOException {
        int c = in.readVUnsignedInt();
        ArrayList<AddressGeomItem> items = null;
        if (c > 0) {
            items = new ArrayList<AddressGeomItem>(c);
            for (int i = 0; i < c; ++i) {
                AddressGeomItem item = new AddressGeomItem(0, null);
                item.read(in);
                items.add(item);
            }
        }
        return items;
    }

    @Override
    public Rectangle getBounds() {
        return this.m_bounds;
    }

    public int getAreaID() {
        return this.m_areaID;
    }

    public void clearAddressItems() {
        this.m_addrGeomItems = null;
    }

    public List<AddressGeomItem> getAddressItems() {
        return this.m_addrGeomItems;
    }

    public List<AddressGeomItem> readAddressItemsAtOffset(ICGGEDataInputStream in) throws IOException {
        if (this.m_addrGeomItems == null && this.m_addrItemsOffset > -1L) {
            in.seek(this.m_addrItemsOffset);
            return this.readAddressItems((ICGGEDataInput)in);
        }
        return this.m_addrGeomItems;
    }

    public void setBounds(Rectangle bounds) {
        this.m_bounds = bounds;
    }

    public void addAddressItem(AddressGeomItem item) {
        this.m_addrGeomItems = ListUtils.addToList(this.m_addrGeomItems, (Object)item);
    }

    public int hashCode() {
        return this.m_areaID;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AreaGeomItem) {
            return this.getAreaID() == ((AreaGeomItem)obj).getAreaID();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Area ID : ");
        sb.append(this.m_areaID);
        sb.append(this.m_bounds.toString());
        return sb.toString();
    }
}

