/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp;

import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.IDataItem;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CategoryIDDataItem
implements IDataItem {
    private Map<Integer, Set<Integer>> m_fieldIDMap = new HashMap<Integer, Set<Integer>>();

    public void combine(CategoryIDDataItem other) {
        Iterator<Map.Entry<Integer, Set<Integer>>> otherMapIt = other.getFieldIDCategoryIDIterator();
        if (otherMapIt != null) {
            while (otherMapIt.hasNext()) {
                Map.Entry<Integer, Set<Integer>> fieldIDMiCodePair = otherMapIt.next();
                this.addCategoryIDs(fieldIDMiCodePair.getKey(), fieldIDMiCodePair.getValue());
            }
        }
    }

    public void addCategoryID(int fieldID, int categoryID) {
        Set<Integer> catIDs = this.m_fieldIDMap.get(fieldID);
        if (catIDs == null) {
            catIDs = new HashSet<Integer>();
            this.m_fieldIDMap.put(fieldID, catIDs);
        }
        catIDs.add(categoryID);
    }

    public void addCategoryIDs(int fieldID, Set<Integer> categoryIDs) {
        Set<Integer> savedCatIds = this.m_fieldIDMap.get(fieldID);
        if (savedCatIds == null) {
            savedCatIds = new HashSet<Integer>();
            this.m_fieldIDMap.put(fieldID, savedCatIds);
        }
        savedCatIds.addAll(categoryIDs);
    }

    public Set<Integer> getCategoryIDs(int fieldID) {
        return this.m_fieldIDMap.get(fieldID);
    }

    public Set<Integer> getCategoryFields() {
        return this.m_fieldIDMap.keySet();
    }

    public void read(ICGGEDataInput in) throws IOException {
        int fieldCount = in.readShort();
        this.m_fieldIDMap = new HashMap<Integer, Set<Integer>>();
        for (int i = 0; i < fieldCount; ++i) {
            Integer fieldID = in.readShort();
            int catIDCount = in.readShort();
            HashSet<Integer> catIDs = new HashSet<Integer>(catIDCount);
            for (int j = 0; j < catIDCount; ++j) {
                catIDs.add((int)in.readVUnsignedLong());
            }
            this.m_fieldIDMap.put(fieldID, catIDs);
        }
    }

    public void write(ICGGEDataOutput out) throws IOException {
        int fieldCount = this.m_fieldIDMap.size();
        out.writeShort(fieldCount);
        for (Map.Entry<Integer, Set<Integer>> en : this.m_fieldIDMap.entrySet()) {
            out.writeShort(en.getKey().intValue());
            Set<Integer> catIDs = en.getValue();
            int catIDCount = catIDs.size();
            out.writeShort(catIDCount);
            for (int catID : catIDs) {
                out.writeVUnsignedLong((long)catID);
            }
        }
    }

    public <T extends IDataItem> T getNewInstance() {
        return (T)new CategoryIDDataItem();
    }

    public Iterator<Map.Entry<Integer, Set<Integer>>> getFieldIDCategoryIDIterator() {
        return this.getFieldIDCategoryIDIterator(null);
    }

    public Iterator<Map.Entry<Integer, Set<Integer>>> getFieldIDCategoryIDIterator(List<Integer> allowedFields) {
        Map<Object, Object> fieldIDMap = Collections.emptyMap();
        if (allowedFields != null && !allowedFields.isEmpty()) {
            fieldIDMap = new HashMap();
            for (Integer field : allowedFields) {
                Set<Integer> list = this.m_fieldIDMap.get(field);
                if (list == null) continue;
                fieldIDMap.put(field, list);
            }
        } else {
            fieldIDMap = this.m_fieldIDMap;
        }
        return fieldIDMap.entrySet().iterator();
    }
}

