/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp;

import com.mapinfo.mapmarker.autosuggest.utils.NumberRange;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import java.util.List;

public class NumberRangeHasher {
    private static NumberRange[] m_rangePerByte = new NumberRange[]{new NumberRange(1, 99), new NumberRange(100, 999), new NumberRange(1000, 4999), new NumberRange(5000, 9999), new NumberRange(10000, 49999), new NumberRange(50000, 99999), new NumberRange(100000, 999999), new NumberRange(1000000, Integer.MAX_VALUE), new NumberRange(0, 0)};

    public byte hash(NumberRange range) {
        return (byte)this.hash0(range);
    }

    public byte hash(List<NumberRange> ranges) {
        int hash = 0;
        if (!ListUtils.isEmpty(ranges)) {
            for (NumberRange range : ranges) {
                hash |= this.hash0(range);
            }
        }
        return (byte)hash;
    }

    public boolean intersects(byte hash1, byte hash2) {
        return (hash1 & hash2) == hash2;
    }

    public boolean checkProbability(byte hash, int number) {
        return (hash & this.hash0(number, number)) > 0;
    }

    private int hash0(NumberRange range) {
        return this.hash0(range.getStart(), range.getEnd());
    }

    private int hash0(int start, int end) {
        int i;
        int hash = 0;
        for (i = 0; i < 8; ++i) {
            if (!m_rangePerByte[i].intersects(start, end)) continue;
            hash |= 1 << i;
        }
        for (i = 8; i < m_rangePerByte.length; ++i) {
            if (!m_rangePerByte[i].intersects(start, end)) continue;
            hash |= 0x80;
        }
        return hash;
    }
}

