/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp;

import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IRadixTreeMetaData;
import com.mapinfo.mapmarker.cgge.utils.compress.CompHeader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RadixTreeMetaData
implements IRadixTreeMetaData {
    static final int CURRENT_VERSION = 2;
    private String dataSetName = "";
    private Map<Integer, String> fieldNameMap = new HashMap<Integer, String>(10);
    private int dataType = 0;
    private CompHeader compHeader;
    private boolean isCustomData;
    private int version = 2;
    private byte[] additionalBytes;

    public RadixTreeMetaData() {
    }

    public RadixTreeMetaData(String dataSetName, int dataType, CompHeader compHeader, boolean isCustomData) {
        this();
        this.dataSetName = dataSetName;
        this.dataType = dataType;
        this.compHeader = compHeader;
        this.isCustomData = isCustomData;
    }

    int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public void read(DataInput in) throws IOException {
        this.version = in.readInt();
        this.dataSetName = in.readUTF();
        this.dataType = in.readInt();
        this.isCustomData = in.readBoolean();
        int n = in.readInt();
        this.fieldNameMap.clear();
        for (int i = 0; i < n; ++i) {
            int id = in.readInt();
            String fieldname = in.readUTF();
            this.fieldNameMap.put(id, fieldname);
        }
        this.compHeader = this.readCompressionHeader(in);
        if (this.version > 1) {
            this.additionalBytes = this.readAdditionalBytes(in);
        }
    }

    private void writeCompressionHeader(CompHeader compHeader, DataOutput out) throws IOException {
        if (compHeader != null) {
            out.writeBoolean(true);
            compHeader.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    private CompHeader readCompressionHeader(DataInput in) throws IOException {
        CompHeader compHeader = null;
        boolean hasCompression = in.readBoolean();
        if (hasCompression) {
            compHeader = new CompHeader();
            compHeader.read(in);
        }
        return compHeader;
    }

    private void writeAdditionalBytes(DataOutput out, byte[] additionalBytes) throws IOException {
        int n = additionalBytes == null ? 0 : additionalBytes.length;
        out.writeInt(n);
        if (n > 0) {
            out.write(additionalBytes);
        }
    }

    private byte[] readAdditionalBytes(DataInput in) throws IOException {
        int size = in.readInt();
        byte[] bytes = null;
        if (size > 0) {
            bytes = new byte[size];
            in.readFully(bytes);
        }
        return bytes;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.version);
        out.writeUTF(this.dataSetName);
        out.writeInt(this.dataType);
        out.writeBoolean(this.isCustomData);
        out.writeInt(this.fieldNameMap.size());
        if (!this.fieldNameMap.isEmpty()) {
            for (Map.Entry<Integer, String> en : this.fieldNameMap.entrySet()) {
                out.writeInt(en.getKey());
                out.writeUTF(en.getValue());
            }
        }
        this.writeCompressionHeader(this.compHeader, out);
        this.writeAdditionalBytes(out, this.additionalBytes);
    }

    public void addFieldName(int id, String name) {
        this.fieldNameMap.put(id, name);
    }

    public String getFieldName(int id) {
        return this.fieldNameMap.get(id);
    }

    public void setDataSetName(String name) {
        this.dataSetName = name;
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    public Set<Integer> getFieldIDs() {
        return this.fieldNameMap.keySet();
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int type) {
        this.dataType = type;
    }

    public void setAdditionalBytes(byte[] bytes) {
        this.additionalBytes = bytes;
    }

    @Override
    public byte[] getAdditionalBytes() {
        return this.additionalBytes;
    }

    public CompHeader getCompHeader() {
        return this.compHeader;
    }

    public void setCompHeader(CompHeader compHeader) {
        this.compHeader = compHeader;
    }

    public boolean isCustomData() {
        return this.isCustomData;
    }

    public void setCustomData(boolean b) {
        this.isCustomData = b;
    }

    public int hashCode() {
        int result = 31 * this.version;
        result = 31 * result + this.dataType;
        if (this.fieldNameMap != null) {
            result = 31 * result + this.fieldNameMap.size();
        }
        return result;
    }
}

