/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp.builder;

import com.mapinfo.mapmarker.autosuggest.dp.StringDataItem;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTree;
import com.mapinfo.mapmarker.autosuggest.utils.substitution.SubstitutionSetManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlternateKeyGenerator {
    private static final Logger LOG = LoggerFactory.getLogger((String)AlternateKeyGenerator.class.getName());
    private SubstitutionSetManager m_substitutionSetManager = null;
    private RadixTree<StringDataItem> m_altTokenTree = null;
    private Set<String> m_wordsWithMultipleStds = new HashSet<String>();
    private Set<String> m_standardValues = new HashSet<String>();

    public AlternateKeyGenerator() {
        this.m_altTokenTree = new RadixTree();
    }

    void setSubstitutionSetManager(SubstitutionSetManager substitutionSetManager) {
        this.m_substitutionSetManager = substitutionSetManager;
    }

    public String standardise(String str, int fieldID) {
        int type = this.getSubstitutionSetMaskForFieldType(fieldID);
        StringBuilder sb = new StringBuilder(str.length());
        if (type > 0) {
            String[] tokens;
            for (String token : tokens = str.split(" ")) {
                sb.append(this.standardiseToken(token, type));
                sb.append(' ');
            }
            return sb.toString().trim();
        }
        return str;
    }

    public String getShortestVersion(String str, int typesToRemove) {
        return this.m_substitutionSetManager.getShortestVersion(str, typesToRemove);
    }

    protected String removeSingleCharacters(String str) {
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str);
            if (st.countTokens() == 1) {
                return str;
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (tok.length() <= 1 && !Character.isDigit(tok.charAt(0))) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(tok);
            }
            return stringBuilder.toString();
        }
        return str;
    }

    public RadixTree<StringDataItem> getAltTokenRadixTree() {
        return this.m_altTokenTree;
    }

    protected String standardiseToken(String token, int type) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("standardiseToken('" + token + "', " + type + ")");
        }
        String stdToken = this.getStandardised(token);
        Set<String> alts = this.m_substitutionSetManager.getSubstitutionsForToken(token, type);
        if (alts != null) {
            if (stdToken == null) {
                stdToken = this.getStandardisedTokenFromAlts(alts);
            }
            this.addToAltRadixTree(alts, stdToken);
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("standardiseToken('" + token + "', " + type + "): ");
            sb.append(stdToken == null ? token : stdToken);
            LOG.debug(sb.toString());
        }
        return stdToken == null ? token : stdToken;
    }

    String getStandardised(String token) {
        StringDataItem treeItem = this.m_altTokenTree.find(token);
        if (treeItem != null) {
            return treeItem.getValue();
        }
        return null;
    }

    private String getStandardisedTokenFromAlts(Set<String> alts) {
        int size;
        int n = size = alts == null ? 0 : alts.size();
        if (size > 0) {
            for (String alt : alts) {
                String stdToken = this.getStandardised(alt);
                if (stdToken == null) continue;
                return stdToken;
            }
            if (alts.size() > 1) {
                TreeSet<String> sortedAlts = new TreeSet<String>(new StringLengthComparator());
                sortedAlts.addAll(alts);
                return sortedAlts.first();
            }
            return alts.iterator().next();
        }
        return null;
    }

    private void addToAltRadixTree(Set<String> altTokenSet, String standardToken) {
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("addToAltRadixTree(");
            sb.append(Arrays.toString(altTokenSet.toArray()));
            sb.append(", '");
            sb.append(standardToken);
            sb.append("')");
            LOG.debug(sb.toString());
        }
        StringDataItem standardValue = new StringDataItem(standardToken);
        for (String altToken : altTokenSet) {
            if (altToken.equals(standardToken)) continue;
            StringDataItem currentValue = this.m_altTokenTree.find(altToken);
            if (currentValue == null) {
                boolean doAddition = true;
                if (this.m_standardValues.contains(altToken)) {
                    standardValue = new StringDataItem(altToken);
                    altToken = standardToken;
                    StringDataItem key = this.m_altTokenTree.find(altToken);
                    if (key != null) {
                        doAddition = false;
                    }
                }
                if (!doAddition) continue;
                LOG.info("Substitution added : '" + altToken + "=" + standardValue + "'");
                this.m_altTokenTree.add(altToken, standardValue);
                this.m_standardValues.add(standardToken);
                continue;
            }
            if (currentValue.equals(standardValue) || this.m_wordsWithMultipleStds.contains(altToken)) continue;
            LOG.warn("Two different standardised values (" + currentValue + ", " + standardToken + ") for " + altToken + " found");
            this.m_wordsWithMultipleStds.add(altToken);
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("addToAltRadixTree(");
            sb.append(Arrays.toString(altTokenSet.toArray()));
            sb.append(", '");
            sb.append(standardToken);
            sb.append("'): stdValues: ");
            sb.append(Arrays.toString(this.m_standardValues.toArray()));
            sb.append(", multipleStd: ");
            sb.append(Arrays.toString(this.m_wordsWithMultipleStds.toArray()));
            LOG.debug(sb.toString());
        }
    }

    protected int getSubstitutionSetMaskForFieldType(int fieldID) {
        if (this.isAreaField(fieldID)) {
            return 72;
        }
        return 2143;
    }

    protected boolean isAreaField(int fieldID) {
        return fieldID == 16 || fieldID == 17 || fieldID == 18 || fieldID == 19;
    }

    protected boolean isStreetNameField(int fieldID) {
        return fieldID == 8;
    }

    protected boolean isPOINameField(int fieldID) {
        return fieldID == 7;
    }

    public void loadSubstitutionSetManager(Properties dataProps) throws IOException {
        SubstitutionSetManager manager = new SubstitutionSetManager();
        manager.loadSubstitutionSet(dataProps);
        this.setSubstitutionSetManager(manager);
        this.m_altTokenTree = new RadixTree();
    }

    public void writeSubstitutionSet(String fullName) throws IOException {
        if (this.m_substitutionSetManager == null) {
            return;
        }
        this.m_substitutionSetManager.write(fullName);
    }

    private static class StringLengthComparator
    implements Comparator<String> {
        private StringLengthComparator() {
        }

        @Override
        public int compare(String str1, String str2) {
            int len2;
            int len1 = str1.length();
            int delta = len1 - (len2 = str2.length());
            if (delta == 0) {
                return str1.compareTo(str2);
            }
            return delta;
        }
    }
}

