/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp.builder;

import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.ISourceDataReader;
import com.mapinfo.mapmarker.autosuggest.dp.InternalSimpleAddress;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleStreetAddress;
import com.mapinfo.mapmarker.autosuggest.dp.builder.DataBuilder;
import com.mapinfo.mapmarker.autosuggest.exception.CGGELevelException;
import com.mapinfo.mapmarker.autosuggest.utils.GeomUtil;
import com.mapinfo.mapmarker.autosuggest.utils.SubLevelIterator;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.DataReadException;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.dp.DataSetReader;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidPropertyException;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CGGEBinaryDataReader
implements ISourceDataReader {
    private DataSetReader m_dataSetReader = null;
    private Map<String, FieldType> additionalFields = null;

    @Override
    public void load(Properties dataProp) throws InvalidPropertyException, CGGELevelException {
        this.m_dataSetReader = new DataSetReader();
        String dataPath = DataBuilder.getRequiredPropertyValue(dataProp, "inputPath");
        String dataName = DataBuilder.getRequiredPropertyValue(dataProp, "dataName");
        try {
            this.m_dataSetReader.loadData(dataPath, dataName);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CGGELevelException(e);
        }
    }

    @Override
    public Map<Integer, String> getFields() {
        return this.m_dataSetReader.getFieldMap();
    }

    @Override
    public Iterator<SimpleStreetAddress> getAddressIterator(final int sac) throws CGGELevelException {
        Iterator cggeAddrItTemp = null;
        try {
            cggeAddrItTemp = this.m_dataSetReader.getAddressIterator(sac);
        }
        catch (CGGEInternalException cggeInternalException) {
            throw new CGGELevelException(cggeInternalException);
        }
        final Iterator cggeAddrIt = cggeAddrItTemp;
        Iterator<SimpleStreetAddress> simpleStreetAddressIterator = new Iterator<SimpleStreetAddress>(){
            int addrNdx = 0;

            @Override
            public boolean hasNext() {
                return cggeAddrIt.hasNext();
            }

            @Override
            public SimpleStreetAddress next() {
                return CGGEBinaryDataReader.this.convertAddress((InternalStreetAddress)cggeAddrIt.next(), sac, this.addrNdx++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return simpleStreetAddressIterator;
    }

    @Override
    public Collection<Integer> getAreaIDs() {
        return this.m_dataSetReader.getSacs();
    }

    public Iterator<SimpleStreetAddress> getAddressIterator() {
        return new SubLevelIterator<Integer, InternalStreetAddress, SimpleStreetAddress>(){
            private int m_currSac = -1;
            private int m_currAddrNdx = -1;

            @Override
            public Iterator<InternalStreetAddress> getSubIterator(Integer sac) {
                try {
                    this.m_currSac = sac;
                    this.m_currAddrNdx = 0;
                    return CGGEBinaryDataReader.this.m_dataSetReader.getAddressIterator(sac.intValue());
                }
                catch (CGGEInternalException e) {
                    throw new DataReadException((Exception)((Object)e));
                }
            }

            @Override
            public SimpleStreetAddress getItem(InternalStreetAddress subItem) {
                return CGGEBinaryDataReader.this.convertAddress(subItem, this.m_currSac, this.m_currAddrNdx++);
            }

            @Override
            public Iterator<Integer> getMainIterator() {
                return CGGEBinaryDataReader.this.m_dataSetReader.getSacs().iterator();
            }
        };
    }

    protected SimpleStreetAddress convertAddress(InternalStreetAddress srcAddr, int sac, int addrNdx) {
        SimpleStreetAddress addr = new SimpleStreetAddress();
        AddressPtr addrPtr = new AddressPtr(sac);
        addrPtr.addAddressID(addrNdx);
        addr.setAddressPtr(addrPtr);
        this.copyFields((InternalAddress)srcAddr, addr);
        Rectangle bounds = this.copyRanges(srcAddr, addr);
        addr.setBounds(bounds);
        return null;
    }

    private Rectangle copyRanges(InternalStreetAddress srcAddr, SimpleStreetAddress addr) {
        Rectangle bounds = null;
        if (srcAddr.getRangeCount() > 0) {
            for (InternalRangeAddress range : srcAddr.getRangeList()) {
                Rectangle rangeBounds;
                if (this.isValidRange(range)) {
                    addr.addRange(this.makeRange(range));
                }
                if ((rangeBounds = this.getBounds(range)) == null) continue;
                if (bounds == null) {
                    bounds = rangeBounds;
                    continue;
                }
                bounds.expandToInclude(rangeBounds);
            }
        }
        return bounds;
    }

    private Rectangle getBounds(InternalRangeAddress srcRange) {
        double[] geom = this.getGeometry(srcRange);
        if (geom != null) {
            return GeomUtil.getBounds(geom);
        }
        return null;
    }

    private boolean isValidRange(InternalRangeAddress range) {
        if (range.getOddEvenType() != 0 && (range.getFrom() != null || range.getTo() != null)) {
            return true;
        }
        return range.getFields() != null && !range.getFields().isEmpty();
    }

    private SimpleRange makeRange(InternalRangeAddress range) {
        String from = range.getFrom().toString();
        String to = range.getTo().toString();
        SimpleRange r = new SimpleRange(from, to);
        this.setOddEvenType(r, range.getOddEvenType());
        this.copyFields((InternalAddress)range, r);
        return r;
    }

    public double[] getGeometry(InternalRangeAddress srcAddr) {
        List geom;
        try {
            geom = this.m_dataSetReader.getGeometry((InternalAddress)srcAddr);
        }
        catch (CGGEInternalException e) {
            throw new DataReadException((Exception)((Object)e));
        }
        if (geom != null) {
            int c = geom.size();
            double[] geometry = new double[c * 2];
            for (int i = 0; i < c; ++i) {
                DirectPosition dp = (DirectPosition)geom.get(i);
                geometry[i * 2] = dp.getX();
                geometry[i * 2 + 1] = dp.getY();
            }
            return geometry;
        }
        return null;
    }

    void setOddEvenType(SimpleRange r, int type) {
        int internalType = 0;
        switch (type) {
            case 2: {
                internalType = 2;
                break;
            }
            case 3: {
                internalType = 2;
                break;
            }
            default: {
                internalType = 0;
            }
        }
        r.setOddEvenType(internalType);
    }

    private void copyFields(InternalAddress srcAddr, InternalSimpleAddress addr) {
        Map inFields = srcAddr.getFields();
        if (inFields != null) {
            ICGGEParser parser = this.m_dataSetReader.getParser();
            for (Map.Entry en : inFields.entrySet()) {
                String fv = parser.reconstructFieldValue((AddressWord[])((InternalFieldValue)en.getValue()).getFieldValue());
                addr.addField(((FieldType)en.getKey()).getKey(), fv);
            }
        }
    }

    @Override
    public int getDataType() {
        int dictType = this.m_dataSetReader.getMetaData().getDictionaryType();
        switch (dictType) {
            case 1: {
                return 0;
            }
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public boolean isCustomData() {
        return this.m_dataSetReader.getMetaData().isUserDictionary();
    }

    @Override
    public String getSupportedCountries() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getLanguage() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Map<String, FieldType> getAdditionalFields() {
        return this.additionalFields;
    }
}

