/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp.builder;

import com.mapinfo.mapmarker.autosuggest.dp.ISourceDataReader;
import com.mapinfo.mapmarker.autosuggest.dp.builder.AbstractDataBuilder;
import com.mapinfo.mapmarker.autosuggest.dp.builder.SourceDataReader;
import com.mapinfo.mapmarker.autosuggest.exception.CGGELevelException;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidPropertyException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBuilder
extends AbstractDataBuilder {
    static final Logger logger = LoggerFactory.getLogger(DataBuilder.class);

    @Override
    protected ISourceDataReader getReader(Properties dataProp) throws InvalidPropertyException, CGGELevelException, IOException, InstantiationException, IllegalAccessException {
        SourceDataReader dataReader = new SourceDataReader();
        dataReader.load(dataProp);
        return dataReader;
    }

    protected Properties loadProperties(String path) throws IOException {
        Properties prop = new Properties();
        prop.load(new FileInputStream(path));
        return prop;
    }

    protected Properties initProperties(String[] args) throws IOException {
        Properties prop = this.loadProperties(args[0]);
        if (args.length >= 2 && !args[1].startsWith("$")) {
            prop.put("dataVintage", args[1]);
        }
        if (args.length >= 3 && !args[2].startsWith("$")) {
            prop.put("dataProductCode", args[2]);
        }
        return prop;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            logger.debug("XXX_DataBuilder.properties file was not specified as arg[0]");
            System.exit(1);
        }
        DataBuilder builder = new DataBuilder();
        try {
            Properties prop = builder.initProperties(args);
            String dataName = AbstractDataBuilder.getRequiredPropertyValue(prop, "dataName");
            String outPath = AbstractDataBuilder.getRequiredPropertyValue(prop, "outputPath");
            builder.createDictionary(dataName, outPath, prop);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

