/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp.builder;

import org.slf4j.Logger;

class ProgressLogger {
    private int m_total;
    private int m_interval;
    private int m_lastProgress;
    private String m_msgTemplate;
    private Logger m_logger;

    ProgressLogger(Logger logger, int total, int interval, String prefixMsg, String suffixMsg) {
        this(logger, interval, prefixMsg, suffixMsg);
        this.m_total = total;
    }

    ProgressLogger(Logger logger, int interval, String prefixMsg, String suffixMsg) {
        this.m_logger = logger;
        this.m_interval = interval;
        StringBuilder sb = new StringBuilder(20);
        if (prefixMsg != null) {
            sb.append(prefixMsg);
            sb.append(' ');
        }
        sb.append("%%%");
        if (suffixMsg != null) {
            sb.append(' ');
            sb.append(suffixMsg);
        }
        this.m_msgTemplate = sb.toString();
    }

    void logPercentageCompleted(int processed) {
        int progress = (int)(100.0 / (double)this.m_total * (double)processed);
        if (progress % this.m_interval == 0 && progress > this.m_lastProgress) {
            this.m_lastProgress = progress;
            this.m_logger.info(this.m_msgTemplate.replaceFirst("%%%", progress + "%"));
        }
    }

    void logProgress(int progress) {
        if (progress % this.m_interval == 0) {
            this.m_logger.info(this.m_msgTemplate.replaceFirst("%%%", "" + progress));
        }
    }
}

