/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.filters;

import com.mapinfo.mapmarker.autosuggest.AddressSearchPreferences;
import com.mapinfo.mapmarker.autosuggest.SearchRequest;
import com.mapinfo.mapmarker.autosuggest.filters.KeyFilter;
import com.mapinfo.mapmarker.autosuggest.filters.KeyFilters;
import com.mapinfo.mapmarker.autosuggest.utils.NumberRange;
import com.mapinfo.mapmarker.autosuggest.utils.matcher.IMatcher;
import com.mapinfo.mapmarker.autosuggest.utils.matcher.Matchers;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeKeyFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeValueFilter;
import java.util.ArrayList;
import java.util.List;

public class GeocompleteFilters {
    private GeocompleteFilters() {
    }

    public static INodeKeyFilter getKeyFilter(SearchRequest searchReq, boolean matchWholeWords, AddressSearchPreferences searchPrefs) {
        String searchKey = searchReq.getSearchkey();
        String[] searchKeyExtensions = searchReq.getSearchKeyExtensions();
        return GeocompleteFilters.getKeyFilter(searchKey, searchKeyExtensions, matchWholeWords, false, searchPrefs, null);
    }

    public static INodeKeyFilter getKeyFilter(String searchKey, String[] searchKeyExtensions, boolean matchWholeWords, boolean matchFully, AddressSearchPreferences searchPrefs) {
        return GeocompleteFilters.getKeyFilter(searchKey, searchKeyExtensions, matchWholeWords, matchFully, searchPrefs, null);
    }

    public static INodeKeyFilter getExactKeyFilter(List<String> searchKeys, boolean matchAllKeys, boolean matchWholeWords) {
        int filterCount = searchKeys.size();
        INodeKeyFilter[] filters = new INodeKeyFilter[filterCount];
        for (int filterNdx = 0; filterNdx < filterCount; ++filterNdx) {
            filters[filterNdx] = GeocompleteFilters.getExactMatchFilter(searchKeys.get(filterNdx), matchWholeWords);
        }
        return new KeyFilters(filters, matchAllKeys);
    }

    public static INodeKeyFilter getIDKeyFilter(List<String> IDs) {
        int filterCount = IDs.size();
        INodeKeyFilter[] filters = new INodeKeyFilter[filterCount];
        for (int filterNdx = 0; filterNdx < filterCount; ++filterNdx) {
            filters[filterNdx] = GeocompleteFilters.getIDMatchFilter(IDs.get(filterNdx));
        }
        return new KeyFilters(filters, false);
    }

    public static INodeKeyFilter getKeyFilter(String searchKey, String[] searchKeyExtensions, boolean matchWholeWords, boolean matchFully, AddressSearchPreferences searchPrefs, List<NumberRange> stdWordPositions) {
        int filterSize = searchKeyExtensions == null ? 1 : searchKeyExtensions.length;
        INodeKeyFilter[] filters = new INodeKeyFilter[filterSize];
        if (filterSize > 1) {
            filters[0] = GeocompleteFilters.getMatchFilter(searchKey + searchKeyExtensions[0], matchWholeWords, matchFully, searchPrefs, stdWordPositions);
            for (int i = 1; i < filterSize; ++i) {
                String altLastWord = searchKeyExtensions[i];
                filters[i] = GeocompleteFilters.getMatchFilter(searchKey + altLastWord, true, true, searchPrefs, GeocompleteFilters.addExactMatchRegionForLastWord(searchKey, altLastWord, stdWordPositions));
            }
        } else {
            filters[0] = GeocompleteFilters.getMatchFilter(searchKey, matchWholeWords, matchFully, searchPrefs, stdWordPositions);
        }
        if (filterSize > 1) {
            return new KeyFilters(filters);
        }
        return filters[0];
    }

    private static List<NumberRange> addExactMatchRegionForLastWord(String str, String lastWord, List<NumberRange> exactMatchRegions) {
        ArrayList<NumberRange> exactMatchRegionsNew = new ArrayList<NumberRange>();
        if (exactMatchRegions != null) {
            exactMatchRegionsNew.addAll(exactMatchRegions);
        }
        int regionStart = str.length();
        exactMatchRegionsNew.add(new NumberRange(regionStart, regionStart + lastWord.length()));
        return exactMatchRegionsNew;
    }

    public static <T> INodeValueFilter<T> getValueFilter(String searchKey, String[] searchKeyExtensions, boolean matchWholeWords, AddressSearchPreferences searchPrefs) {
        return null;
    }

    public static INodeKeyFilter getIDMatchFilter(String id) {
        return new KeyFilter(Matchers.getIDMatcher(id), true);
    }

    public static INodeKeyFilter getExactMatchFilter(String searchStr, boolean matchWholeWord) {
        IMatcher matcher = Matchers.getExactMatcher(searchStr, matchWholeWord);
        return new KeyFilter(matcher, true);
    }

    public static INodeKeyFilter getExactMatchFilter(String searchStr, boolean matchWholeWord, boolean matchFully) {
        IMatcher matcher = Matchers.getExactMatcher(searchStr, matchWholeWord, matchFully);
        return new KeyFilter(matcher, true);
    }

    private static boolean fuzzySearch(AddressSearchPreferences searchPrefs) {
        return searchPrefs.getFuzzySearch();
    }

    private static INodeKeyFilter getFuzzyFilter(String searchStr, boolean matchWholeWord, AddressSearchPreferences searchPrefs, List<NumberRange> stdWordPositions) {
        return GeocompleteFilters.getEditDistanceFilter(searchStr, matchWholeWord, searchPrefs.isMatchFirstCharacter(), searchPrefs.maxEditDistance(), searchPrefs.getMinMatchCharacters(), stdWordPositions);
    }

    private static INodeKeyFilter getEditDistanceFilter(String searchStr, boolean matchWholeWord, boolean matchFirstChar, int maxEdits, int minCharMatch, List<NumberRange> stdWordPositions) {
        IMatcher matcher = Matchers.getEditDistanceMatcher(searchStr, maxEdits, minCharMatch, matchFirstChar, stdWordPositions);
        return new KeyFilter(matcher);
    }

    private static INodeKeyFilter getMatchFilter(String searchKey, boolean matchWholeWords, boolean matchFully, AddressSearchPreferences searchPrefs, List<NumberRange> stdWordPositions) {
        if (GeocompleteFilters.fuzzySearch(searchPrefs)) {
            return GeocompleteFilters.getFuzzyFilter(searchKey, matchWholeWords, searchPrefs, stdWordPositions);
        }
        return GeocompleteFilters.getExactMatchFilter(searchKey, matchWholeWords, matchFully);
    }
}

