/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.filters;

import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeKeyFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.MatchStats;
import java.util.Arrays;

public class KeyFilters
implements INodeKeyFilter {
    final INodeKeyFilter[] m_subFilters;
    private boolean m_matchAllFilters = false;

    KeyFilters(INodeKeyFilter[] subFilters) {
        this(subFilters, false);
    }

    KeyFilters(INodeKeyFilter[] subFilters, boolean matchAllFilters) {
        this.m_subFilters = subFilters;
        this.m_matchAllFilters = matchAllFilters;
    }

    @Override
    public boolean acceptKey(String key) {
        boolean match = false;
        for (INodeKeyFilter filter : this.m_subFilters) {
            if (this.m_matchAllFilters) {
                if (!filter.acceptKey(key)) {
                    return false;
                }
                match = true;
                continue;
            }
            if (!filter.acceptKey(key)) continue;
            return true;
        }
        return match;
    }

    @Override
    public boolean acceptIntermediateKey(String key) {
        boolean match = false;
        for (INodeKeyFilter filter : this.m_subFilters) {
            if (this.m_matchAllFilters) {
                if (!filter.acceptIntermediateKey(key)) {
                    return false;
                }
                match = true;
                continue;
            }
            if (!filter.acceptIntermediateKey(key)) continue;
            return true;
        }
        return match;
    }

    @Override
    public int targetMatchLength(String key) {
        int bestMatchedLen = 0;
        for (INodeKeyFilter filter : this.m_subFilters) {
            int matchedLen;
            int n = matchedLen = key != null ? filter.targetMatchLength(key) : filter.targetMatchLength();
            if (this.m_matchAllFilters && matchedLen == 0) {
                return 0;
            }
            if (matchedLen <= bestMatchedLen) continue;
            bestMatchedLen = matchedLen;
        }
        return bestMatchedLen;
    }

    @Override
    public int targetMatchLength() {
        return this.targetMatchLength(null);
    }

    @Override
    public boolean prefixMatch(String key) {
        boolean match = false;
        for (INodeKeyFilter filter : this.m_subFilters) {
            if (this.m_matchAllFilters) {
                if (!filter.prefixMatch(key)) {
                    return false;
                }
                match = true;
                continue;
            }
            if (!filter.prefixMatch(key)) continue;
            return true;
        }
        return match;
    }

    @Override
    public boolean onlyAllowExactMatches() {
        for (INodeKeyFilter filter : this.m_subFilters) {
            if (filter.onlyAllowExactMatches()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getWeight(String str) {
        int bestWeight = 0;
        for (INodeKeyFilter filter : this.m_subFilters) {
            int w = str == null ? filter.getWeight() : filter.getWeight(str);
            if ((bestWeight = Math.max(bestWeight, w)) == 100) break;
        }
        return bestWeight;
    }

    @Override
    public int getWeight() {
        return this.getWeight(null);
    }

    @Override
    public String getTargetString() {
        if (this.m_subFilters == null || this.m_subFilters.length == 0) {
            return null;
        }
        return this.m_subFilters[0].getTargetString();
    }

    INodeKeyFilter[] getSubFilters() {
        return this.m_subFilters;
    }

    @Override
    public MatchStats getMatchStats(String key) {
        MatchStats bestMatchStats = null;
        for (INodeKeyFilter filter : this.m_subFilters) {
            MatchStats matchStats = filter.getMatchStats(key);
            if (bestMatchStats != null && matchStats.compareTo(bestMatchStats) <= 0) continue;
            bestMatchStats = matchStats;
        }
        return bestMatchStats;
    }

    public String toString() {
        String s = "keyFilters";
        s = this.m_subFilters != null ? s + Arrays.toString(this.m_subFilters) : s + "[]";
        return s;
    }
}

