/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils;

import com.mapinfo.mapmarker.autosuggest.utils.ReadOnlyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ArrayIterator<E>
extends ReadOnlyIterator<E> {
    private final E[] m_array;
    private final int m_count;
    private int m_current;

    public ArrayIterator(E ... array) {
        this.m_array = array;
        this.m_count = array == null ? 0 : array.length;
        this.m_current = 0;
    }

    @Override
    public final boolean hasNext() {
        return this.m_current < this.m_count;
    }

    @Override
    public final E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_array[this.m_current++];
    }

    public static <E> Iterator<E> iterator(E ... array) {
        return new ArrayIterator<E>(array);
    }

    public static <E> Iterator<E> iterator(E item) {
        return new ArrayIterator<Object>(item);
    }
}

