/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils;

public class HashTaggedToken {
    private String m_token;
    private int m_tag;

    public HashTaggedToken(String token, int tag) {
        this.m_token = token;
        this.m_tag = tag;
    }

    public HashTaggedToken(String token) {
        this(token, 0);
    }

    public HashTaggedToken(HashTaggedToken token) {
        this.m_token = token.m_token;
        this.m_tag = token.m_tag;
    }

    public String getValue() {
        return this.m_token;
    }

    public void clearTag() {
        this.m_tag = 0;
    }

    public int getTag() {
        return this.m_tag;
    }

    public void setTag(int tag) {
        this.m_tag |= tag;
    }

    public boolean isTagged() {
        return this.m_tag != 0;
    }

    public boolean isTagged(int tag) {
        if (tag == 0) {
            return this.m_tag == 0;
        }
        return (this.m_tag & tag) == tag;
    }

    public boolean isTaggedAny(int tag) {
        if (tag == 0) {
            return true;
        }
        return (this.m_tag & tag) != 0;
    }

    public String toString() {
        return this.m_token + " => {" + this.m_tag + "}";
    }
}

