/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils;

import com.mapinfo.mapmarker.autosuggest.utils.HashTaggedToken;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class HashTaggedTokenList {
    private List<HashTaggedToken> m_list = new ArrayList<HashTaggedToken>();

    public HashTaggedTokenList() {
    }

    public HashTaggedTokenList(StringTokenizer tokens) {
        if (tokens == null) {
            return;
        }
        while (tokens.hasMoreTokens()) {
            this.m_list.add(new HashTaggedToken(tokens.nextToken()));
        }
    }

    public HashTaggedTokenList(String[] tokens) {
        if (tokens == null) {
            return;
        }
        for (int i = 0; i < tokens.length; ++i) {
            this.m_list.add(new HashTaggedToken(tokens[i]));
        }
    }

    private HashTaggedTokenList(List<HashTaggedToken> tokens) {
        this.m_list = tokens;
    }

    public HashTaggedToken get(int i) {
        return this.m_list.get(i);
    }

    public int size() {
        return this.m_list.size();
    }

    public String getValue(int i) {
        return this.m_list.get(i).getValue();
    }

    public int getTag(int i) {
        return this.m_list.get(i).getTag();
    }

    public void setTag(int i, int tag) {
        this.m_list.get(i).setTag(tag);
    }

    public boolean isTagged(int i) {
        return this.m_list.get(i).isTagged();
    }

    public boolean isTagged(int i, int tag) {
        return this.m_list.get(i).isTagged(tag);
    }

    public String getTaggedTokenString(int tag) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.m_list.size(); ++i) {
            HashTaggedToken token = this.m_list.get(i);
            if (!token.isTagged(tag)) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(token.getValue());
        }
        return sb.toString();
    }

    public String getAnyTaggedTokenString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.m_list.size(); ++i) {
            HashTaggedToken token = this.m_list.get(i);
            if (!token.isTagged()) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(token.getValue());
        }
        return sb.toString();
    }

    public List<String> getTaggedTokens(int tag) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.m_list.size(); ++i) {
            HashTaggedToken token = this.m_list.get(i);
            if (!token.isTagged(tag)) continue;
            list.add(token.getValue());
        }
        return list;
    }

    public List<String> getAnyTaggedTokens() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.m_list.size(); ++i) {
            HashTaggedToken token = this.m_list.get(i);
            if (!token.isTagged()) continue;
            list.add(token.getValue());
        }
        return list;
    }

    public int indexOfFirstUntaggedToken() {
        return this.indexOfTag(0, 0);
    }

    public int indexOfTag(int tag) {
        return this.indexOfTag(tag, 0);
    }

    public int indexOfTag(int searchTag, int startPosition) {
        for (int i = startPosition; i < this.m_list.size(); ++i) {
            int tag = this.m_list.get(i).getTag();
            if (!(tag == 0 ? searchTag == 0 : searchTag != 0 && (tag & searchTag) == searchTag)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<HashTaggedToken> it = this.m_list.iterator();
        while (it.hasNext()) {
            sb.append(((Object)it.next()).toString());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String valuesAsString() {
        StringBuilder sb = new StringBuilder();
        int lastIdx = this.m_list.size() - 1;
        for (int i = 0; i < this.m_list.size(); ++i) {
            HashTaggedToken token = this.m_list.get(i);
            sb.append(token.getValue());
            if (i == lastIdx) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public HashTaggedTokenList subList(int fromIdx, int toIdx) {
        List<HashTaggedToken> sublist = this.m_list.subList(fromIdx, toIdx);
        ArrayList<HashTaggedToken> newList = new ArrayList<HashTaggedToken>(sublist.size());
        for (HashTaggedToken token : sublist) {
            newList.add(new HashTaggedToken(token));
        }
        return new HashTaggedTokenList(newList);
    }
}

