/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils;

import com.mapinfo.mapmarker.autosuggest.utils.AbstractPeekableIterator;
import com.mapinfo.mapmarker.autosuggest.utils.IPeekableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class IteratorUtils {
    private static final IPeekableIterator<?> EMPTY_ITERATOR = new EmptyIterator();

    public static <V> List<V> toList(Iterator<V> it) {
        ArrayList<V> list = new ArrayList<V>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public static <E> IPeekableIterator<E> getEmptyPeekableIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> Iterable<T> iterable(final Iterator<T> it) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return it;
            }
        };
    }

    private static final class EmptyIterator<E>
    extends AbstractPeekableIterator<E> {
        private EmptyIterator() {
        }

        @Override
        protected E getNextItem() {
            return null;
        }
    }
}

