/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils;

import com.mapinfo.mapmarker.autosuggest.utils.AccentHelper;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.regex.Pattern;

public class StringNormalizer {
    private static final Pattern[] accentPatterns;
    private static String[] accentRegexes;
    private static String[] accentReplacements;
    private static final String NON_SPACING_CHARS = "`\u00b4'`";

    public static String normalise(String input) {
        if (input != null) {
            StringBuilder sb = new StringBuilder(AccentHelper.convert(input));
            int len = sb.length();
            int deleteCt = 0;
            for (int i = len - 1; i >= 0; --i) {
                if (Character.isLetterOrDigit(sb.charAt(i))) continue;
                if (NON_SPACING_CHARS.indexOf(sb.charAt(i)) >= 0 && (i + deleteCt >= len - 2 || i + deleteCt < len - 2 && Character.isWhitespace(sb.charAt(i + 2)))) {
                    sb.deleteCharAt(i);
                    ++deleteCt;
                    continue;
                }
                sb.setCharAt(i, ' ');
            }
            boolean lastWasSpace = true;
            len = sb.length();
            for (int i = len - 1; i >= 0; --i) {
                if (sb.charAt(i) == ' ') {
                    if (lastWasSpace) {
                        sb.deleteCharAt(i);
                        continue;
                    }
                    lastWasSpace = true;
                    continue;
                }
                lastWasSpace = false;
            }
            input = sb.toString().trim();
            if (input.length() > 0) {
                input = input.toUpperCase();
                return StringNormalizer.replace(input, accentPatterns, accentReplacements);
            }
        }
        return input;
    }

    public static String getWordAtIndex(String str, int wordNdx) {
        int startNdx = 0;
        int endNdx = -1;
        int strLen = str.length();
        for (int i = 0; i <= wordNdx; ++i) {
            startNdx = endNdx + 1;
            if ((endNdx = str.indexOf(32, startNdx)) != -1 || i >= wordNdx) continue;
            return null;
        }
        return str.substring(startNdx, endNdx == -1 ? strLen : endNdx);
    }

    public static int getWordIndex(String str, int charNdx) {
        if (charNdx < 0 || charNdx >= str.length()) {
            throw new IndexOutOfBoundsException();
        }
        int wordNdx = -1;
        int endNdx = -1;
        while (endNdx < charNdx) {
            endNdx = str.indexOf(32, endNdx + 1);
            ++wordNdx;
            if (endNdx != -1) continue;
            break;
        }
        return wordNdx;
    }

    public static String getLastWord(String str) {
        int ndx = str.lastIndexOf(32);
        if (ndx > -1) {
            return str.substring(ndx + 1, str.length());
        }
        return str;
    }

    public static String removeLastWord(String str, boolean includeTrailingSpace) {
        int ndx = str.lastIndexOf(32);
        if (ndx > -1) {
            return str.substring(0, includeTrailingSpace ? ndx + 1 : ndx);
        }
        return str;
    }

    private static Pattern[] preCompile(String[] regexes) {
        Pattern[] patterns = new Pattern[regexes.length];
        for (int i = 0; i < regexes.length; ++i) {
            patterns[i] = Pattern.compile(regexes[i]);
        }
        return patterns;
    }

    private static String replace(String input, Pattern[] patterns, String[] replacements) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        for (int i = 0; i < patterns.length; ++i) {
            input = patterns[i].matcher(input).replaceAll(replacements[i]);
        }
        return input;
    }

    public static void addDelim(StringBuilder sb, String nextValue) {
        if (sb.length() == 0) {
            return;
        }
        if (Character.isDigit(sb.charAt(sb.length() - 1)) || !StringUtilities.isEmpty((String)nextValue) && Character.isDigit(nextValue.charAt(0))) {
            sb.append(' ');
        } else {
            int lastSpace = sb.lastIndexOf(" ");
            if (lastSpace < 0) {
                lastSpace = 0;
            }
            for (int i = lastSpace; i < sb.length(); ++i) {
                if (!Character.isDigit(sb.charAt(i))) continue;
                sb.append(' ');
                return;
            }
            sb.append(", ");
        }
    }

    static {
        int i = 0;
        int count = AccentHelper.keySet().size();
        accentRegexes = new String[count];
        accentReplacements = new String[count];
        for (char key : AccentHelper.keySet()) {
            StringNormalizer.accentReplacements[i] = String.valueOf(key);
            StringNormalizer.accentRegexes[i] = AccentHelper.buildRegexRuleString(key);
            ++i;
        }
        accentPatterns = StringNormalizer.preCompile(accentRegexes);
    }
}

