/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils;

import com.mapinfo.mapmarker.autosuggest.utils.AbstractPeekableIterator;
import java.util.Iterator;
import java.util.Map;

public abstract class SubLevelIterator<T, T1, T2>
extends AbstractPeekableIterator<T2> {
    private Iterator<T> m_mainIt;
    private Iterator<T1> m_subIt;
    private final int m_limit;

    public SubLevelIterator() {
        this(-1);
    }

    public SubLevelIterator(int limit) {
        this.m_limit = limit;
    }

    @Override
    protected void init() {
        this.m_mainIt = this.getMainIterator();
        this.m_subIt = this.nextSubIt();
    }

    protected boolean nextItemRequired() {
        return this.m_limit == -1 || this.getFetchedCount() < this.m_limit;
    }

    @Override
    protected T2 getNextItem() {
        if (this.nextItemRequired()) {
            while (this.m_subIt != null) {
                if (this.m_subIt.hasNext()) {
                    return this.getItem(this.m_subIt.next());
                }
                this.m_subIt = this.nextSubIt();
            }
        }
        return null;
    }

    protected T nextMainItem() {
        if (this.m_mainIt != null && this.nextItemRequired() && this.m_mainIt.hasNext()) {
            return this.m_mainIt.next();
        }
        return null;
    }

    protected Iterator<T1> nextSubIt() {
        T mainItem = this.nextMainItem();
        Iterator<T1> subIt = null;
        while (mainItem != null) {
            subIt = this.getSubIterator(mainItem);
            if (subIt == null) {
                mainItem = this.nextMainItem();
                continue;
            }
            mainItem = null;
        }
        return subIt;
    }

    public abstract Iterator<T1> getSubIterator(T var1);

    public abstract T2 getItem(T1 var1);

    public abstract Iterator<T> getMainIterator();

    public static <V, E extends Iterable<V>, M extends Iterable<V>, T extends Iterable<E>> Iterator<V> getFromIterableSubList(final T iter) {
        return new SubLevelIterator<E, V, V>(-1){

            @Override
            public Iterator<V> getSubIterator(E mainItem) {
                return mainItem.iterator();
            }

            @Override
            public V getItem(V subItem) {
                return subItem;
            }

            @Override
            public Iterator<E> getMainIterator() {
                return iter.iterator();
            }
        };
    }

    public static <V, E extends Iterator<V>, T extends Iterable<E>> Iterator<V> getFromIteratorSubList(final T iter) {
        return new SubLevelIterator<E, V, V>(-1){

            @Override
            public Iterator<V> getSubIterator(E mainItem) {
                return mainItem;
            }

            @Override
            public V getItem(V subItem) {
                return subItem;
            }

            @Override
            public Iterator<E> getMainIterator() {
                return iter.iterator();
            }
        };
    }

    public static <K, V, I extends Iterable<V>> Iterator<Pair<K, V>> getMapIterator(final Map<K, I> map) {
        return new SubLevelIterator<Map.Entry<K, I>, V, Pair<K, V>>(-1){
            private K m_currK;

            @Override
            public Iterator<V> getSubIterator(Map.Entry<K, I> mainItem) {
                this.m_currK = mainItem.getKey();
                Iterable iterable = (Iterable)mainItem.getValue();
                if (iterable != null) {
                    return iterable.iterator();
                }
                return null;
            }

            @Override
            public Pair<K, V> getItem(V subItem) {
                return new Pair(this.m_currK, subItem);
            }

            @Override
            public Iterator<Map.Entry<K, I>> getMainIterator() {
                return map.entrySet().iterator();
            }
        };
    }

    public static class Pair<K, V> {
        private K m_k;
        private V m_v;

        public Pair(K k, V v) {
            this.m_k = k;
            this.m_v = v;
        }

        public K getKey() {
            return this.m_k;
        }

        public V getValue() {
            return this.m_v;
        }
    }
}

