/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils;

import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.wrapper.AdditionalFieldInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SuggestedCandidateRangeUnitUtils {
    private static final String FEATURE_ID = "featureID";
    public static final String FORMATTED_STRING = "FORMATTED_STRING";
    public static final String COMMA = ", ";

    public static Map<String, String> populateAdditionalFields(Map<Integer, List<String>> fieldsMap, AdditionalFieldInfo additionalFieldInfo) {
        HashMap<String, String> rangeFieldMap = new HashMap<String, String>();
        if (fieldsMap != null && additionalFieldInfo != null) {
            for (Integer integer : fieldsMap.keySet()) {
                String fieldName = additionalFieldInfo.getKey(integer);
                List<String> valuesList = fieldsMap.get(integer);
                StringBuilder builder = new StringBuilder();
                for (String string : valuesList) {
                    builder.append(string);
                    builder.append(" ");
                }
                rangeFieldMap.put(fieldName, builder.toString().trim());
            }
        }
        return rangeFieldMap;
    }

    public static Set<Integer> getInternalKeysForFields(Set<String> fieldsKeySet, AdditionalFieldInfo additionalFieldInfo) {
        HashSet<Integer> internalKeyList = new HashSet<Integer>();
        if (fieldsKeySet != null && additionalFieldInfo != null) {
            for (String fieldKey : fieldsKeySet) {
                internalKeyList.add(additionalFieldInfo.getIDForKey(fieldKey));
            }
        }
        return internalKeyList;
    }

    public static boolean isDummyRange(SimpleRange range, AdditionalFieldInfo additionalFieldInfo) {
        boolean isDummyRange = false;
        if (range.getFrom() == null && range.getTo() == null && range.getUnitCount() == 0) {
            Map<Integer, List<String>> fieldsMap = range.getFields();
            if (fieldsMap == null || fieldsMap.size() == 0) {
                isDummyRange = true;
            } else if (fieldsMap.size() == 1) {
                for (Integer integer : fieldsMap.keySet()) {
                    String fieldName = additionalFieldInfo.getKey(integer);
                    if (!fieldName.equals(FEATURE_ID)) continue;
                    isDummyRange = true;
                }
            }
        }
        return isDummyRange;
    }
}

