/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.matcher;

import com.mapinfo.mapmarker.autosuggest.utils.matcher.IMatcher;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.MatchStats;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EditDistance
implements IMatcher {
    private static final Logger logger = LoggerFactory.getLogger(EditDistance.class);
    private char[] m_targetStrChars;
    private int[] m_dists;
    private int m_numRowsCalculated = 0;
    private int m_maxEdits = 2;
    private char[] m_evaluatedStrChars;
    private int m_minMatch = 2;
    private boolean m_matchFirstChar = false;
    private final boolean m_matchWholeWord;

    public EditDistance(String target, int max, int minCharacterMatch, boolean matchFirstChar) {
        this(target, max, minCharacterMatch, matchFirstChar, false);
    }

    public EditDistance(String target, int max, int minCharacterMatch, boolean matchFirstChar, boolean matchWholeWord) {
        this.setTargetString(target);
        this.m_evaluatedStrChars = null;
        this.m_maxEdits = max;
        this.m_minMatch = minCharacterMatch;
        this.m_matchFirstChar = matchFirstChar;
        this.m_matchWholeWord = matchWholeWord;
    }

    EditDistance(String target) {
        this(target, 1, 2, true);
    }

    @Override
    public void setEvaluatedString(String str) {
        this.setString(str.toCharArray());
    }

    void setString(char[] chars) {
        char[] previousEvalChars = this.m_evaluatedStrChars;
        this.m_evaluatedStrChars = chars;
        if (this.continueMatching()) {
            int nextStartNdx = this.isEmpty(previousEvalChars) || this.m_dists == null ? 0 : this.prefixLen(previousEvalChars, this.m_evaluatedStrChars);
            this.resetCostMatrix(nextStartNdx);
        } else {
            this.resetCostMatrix(0);
        }
    }

    private int prefixLen(char[] chars1, char[] chars2) {
        int matchedChars;
        int shortestLen = Math.min(chars1.length, chars2.length);
        for (matchedChars = 0; matchedChars < shortestLen && chars1[matchedChars] == chars2[matchedChars]; ++matchedChars) {
        }
        return matchedChars;
    }

    @Override
    public void appendChars(char[] chars) {
        this.setString(this.append(this.m_evaluatedStrChars, chars));
    }

    private char[] append(char[] chars1, char[] chars2) {
        if (chars1 == null) {
            return chars2;
        }
        int len1 = chars1.length;
        int len2 = chars2.length;
        char[] combined = Arrays.copyOf(chars1, len1 + len2);
        System.arraycopy(chars2, 0, combined, len1, len2);
        return combined;
    }

    @Override
    public boolean prefixMatches(boolean partial) {
        if (this.continueMatching()) {
            if (partial && this.m_evaluatedStrChars.length <= this.m_maxEdits) {
                return true;
            }
            if (this.internalPrefixMatches(partial)) {
                logger.debug("prefixMatches(): true (prefix matches)");
                return true;
            }
        }
        logger.debug("prefixMatches(): false (prefix does not match)");
        return false;
    }

    private boolean internalPrefixMatches(boolean partial) {
        int edits = this.getBestPrefixEditDistance(false);
        int eLen = this.m_evaluatedStrChars.length;
        int tLen = this.m_targetStrChars.length;
        tLen -= this.countSpaces(this.m_targetStrChars, tLen);
        if (partial && tLen > eLen ? edits >= eLen || !this.acceptEdits(tLen, edits) : !this.acceptEdits(Math.min(eLen, tLen), edits)) {
            return false;
        }
        if (!partial) {
            return this.matchEndsAtWordBoundary(edits, partial);
        }
        return true;
    }

    private boolean matchEndsAtWordBoundary(int bestPrefixEditDist, boolean partial) {
        int eLen = this.m_evaluatedStrChars.length;
        boolean evalEndInSpace = this.m_evaluatedStrChars[eLen - 1] == ' ';
        int bestTargetChar = -1;
        bestTargetChar = partial || evalEndInSpace ? this.bestMatchedTargetCharNdx() : this.bestMatchedTargetCharNdxAtWordBoundary(bestPrefixEditDist, this.m_maxEdits);
        if (bestTargetChar > -1) {
            if (!evalEndInSpace) {
                ++bestTargetChar;
            }
            return this.isCharNdxAtWordBoundary(bestTargetChar);
        }
        return false;
    }

    private boolean isCharNdxAtWordBoundary(int charNdx) {
        if (charNdx >= this.m_targetStrChars.length) {
            return true;
        }
        return this.m_targetStrChars[charNdx] == ' ';
    }

    @Override
    public int targetMatchLength(boolean partial) {
        if (this.continueMatching()) {
            if (this.internalMatches() || this.internalTargetPrefixMatches()) {
                return this.m_targetStrChars.length;
            }
            int bestPrefixEditDist = this.getBestPrefixEditDistance(false);
            if (this.acceptEdits(this.m_evaluatedStrChars.length, bestPrefixEditDist)) {
                return partial ? this.bestMatchedTargetCharNdx() + 1 : this.bestMatchedTargetCharNdxAtWordBoundary(bestPrefixEditDist, this.m_maxEdits) + 1;
            }
        }
        return 0;
    }

    int bestMatchedTargetCharNdx() {
        int dist;
        int n;
        this.checkCostCalculation(false);
        int best = n = this.m_targetStrChars.length + 1;
        int bestNdx = -1;
        int rowStart = this.rowStartIndex(this.m_numRowsCalculated);
        for (int i = 1; i < n && (dist = this.m_dists[rowStart + i]) <= best; ++i) {
            best = dist;
            bestNdx = i - 1;
            if (best == 0) break;
        }
        return bestNdx;
    }

    private int bestMatchedTargetCharNdxAtWordBoundary(int minDist, int maxDist) {
        int[] costArray = this.getLastRow();
        return this.bestMatchedCharNdxAtWordBoundary(this.m_targetStrChars, costArray, minDist, maxDist, this.endsWithSpace(this.m_evaluatedStrChars));
    }

    private int bestMatchedEvalCharNdxAtWordBoundary(int minDist, int maxDist) {
        int[] costArray = this.getLastCol();
        return this.bestMatchedCharNdxAtWordBoundary(this.m_evaluatedStrChars, costArray, minDist, maxDist, this.endsWithSpace(this.m_targetStrChars));
    }

    private int bestMatchedCharNdxAtWordBoundary(char[] chars, int[] costArray, int minDist, int maxDist, boolean otherStringEndsInSpace) {
        int n = costArray.length;
        int best = -1;
        int bestNdx = n - 1;
        boolean previousWasBoundary = false;
        for (int i = 1; i < n; ++i) {
            int dist = costArray[i];
            if (dist >= minDist && dist <= maxDist) {
                if (best == -1 || best >= dist) {
                    if (this.isCharAtWordBoundary(chars, i) && (dist < best || !previousWasBoundary)) {
                        best = dist;
                        bestNdx = otherStringEndsInSpace ? i : i - 1;
                        previousWasBoundary = true;
                    } else if (this.isCharAtWordBoundary(chars, i - 1) && (dist < best || !previousWasBoundary)) {
                        best = dist;
                        bestNdx = i - 1;
                        previousWasBoundary = true;
                    } else {
                        previousWasBoundary = false;
                    }
                }
                if (best != 0) continue;
                break;
            }
            if (best > -1 && dist > best) break;
        }
        return best > -1 ? bestNdx : -1;
    }

    private int[] getLastRow() {
        int n = this.m_targetStrChars.length + 1;
        int rowStart = this.rowStartIndex(this.m_numRowsCalculated);
        int[] row = new int[n];
        for (int i = 0; i < n; ++i) {
            row[i] = this.m_dists[rowStart + i];
        }
        return row;
    }

    private int[] getLastCol() {
        int n = this.m_numRowsCalculated + 1;
        int[] col = new int[n];
        int colCount = this.m_targetStrChars.length;
        int i = 0;
        int colNdx = colCount;
        while (i < n) {
            col[i] = this.m_dists[colNdx];
            ++i;
            colNdx += colCount + 1;
        }
        return col;
    }

    private boolean isCharAtWordBoundary(char[] chars, int ndx) {
        return ndx >= chars.length || chars[ndx] == ' ';
    }

    private boolean endsWithSpace(char[] chars) {
        int len = chars.length;
        return len > 0 && chars[len - 1] == ' ';
    }

    @Override
    public boolean targetPrefixMatches() {
        return this.continueMatching() && this.internalTargetPrefixMatches();
    }

    private boolean internalTargetPrefixMatches() {
        int dist = this.getBestTargetEditDistance(false);
        if (this.acceptEdits(this.m_targetStrChars.length, dist)) {
            return !this.m_matchWholeWord || this.bestMatchedEvalCharNdxAtWordBoundary(dist, this.m_maxEdits) > -1;
        }
        return false;
    }

    @Override
    public boolean matches() {
        return this.continueMatching() && this.internalMatches();
    }

    private boolean internalMatches() {
        return this.acceptEdits(Math.min(this.m_targetStrChars.length, this.m_evaluatedStrChars.length), this.getEditDistance(false));
    }

    private boolean continueMatching() {
        if (!this.isEmpty(this.m_targetStrChars) && !this.isEmpty(this.m_evaluatedStrChars)) {
            return !this.m_matchFirstChar || this.m_targetStrChars[0] == this.m_evaluatedStrChars[0];
        }
        return false;
    }

    private boolean acceptEdits(int charLen, int edits) {
        int minMatch = Math.max((int)((double)edits * 1.5), this.m_minMatch);
        boolean results = edits == 0 || edits <= this.m_maxEdits && charLen >= edits + minMatch;
        logger.debug(String.format("matches(target: '%s', eval: '%s', len: %d, edits: %d): %s", new String(this.m_targetStrChars), this.m_evaluatedStrChars.toString(), charLen, edits, results));
        return results;
    }

    private boolean isEmpty(char[] chars) {
        return chars == null || chars.length == 0;
    }

    private int getEditDistance(boolean calculateFullCost) {
        this.checkCostCalculation(calculateFullCost);
        return this.m_dists[this.rowStartIndex(this.m_numRowsCalculated) + this.m_targetStrChars.length];
    }

    int getEditDistance() {
        return this.getEditDistance(true);
    }

    int getBestTargetEditDistance() {
        return this.getBestTargetEditDistance(true);
    }

    int getBestTargetEditDistance(boolean calculateFullCost) {
        int n = this.m_targetStrChars.length + 1;
        int m = this.m_evaluatedStrChars.length + 1;
        if (n <= m) {
            this.checkCostCalculation(calculateFullCost);
            int best = this.getBestCostAtLastCol();
            return best;
        }
        return this.getEditDistance(calculateFullCost);
    }

    int getBestPrefixEditDistance(boolean calculateFullCost) {
        int m;
        this.checkCostCalculation(calculateFullCost);
        int n = this.m_targetStrChars.length + 1;
        int best = m = this.m_evaluatedStrChars.length + 1;
        if (m > n) {
            best = this.getBestCostAtLastCol();
        }
        best = Math.min(best, this.getBestCostAtLastMatchedRow());
        return best;
    }

    int getBestPrefixEditDistance() {
        return this.getBestPrefixEditDistance(true);
    }

    private void checkCostCalculation(boolean calculateFullCost) {
        int eLen = this.m_evaluatedStrChars.length;
        if (this.m_numRowsCalculated < eLen && (calculateFullCost || this.m_numRowsCalculated < 1 || this.getBestCostAtRow(this.m_numRowsCalculated) <= this.m_maxEdits)) {
            this.calculateLDDistance(this.m_targetStrChars, this.m_evaluatedStrChars, this.m_numRowsCalculated, calculateFullCost);
        }
    }

    private int getBestCostAtLastMatchedRow() {
        return this.getBestCostAtRow(this.m_numRowsCalculated);
    }

    private int getBestCostAtRow(int rowNdx) {
        int best = Integer.MAX_VALUE;
        int rowStart = this.rowStartIndex(rowNdx);
        for (int i = this.m_targetStrChars.length; i > 0; --i) {
            int dist = this.m_dists[rowStart + i];
            if (dist < best) {
                best = dist;
                continue;
            }
            if (dist > best) break;
        }
        return best;
    }

    int getBestTragetCharCost(int ndx) {
        int cols = this.m_targetStrChars.length + 1;
        int rows = this.m_numRowsCalculated;
        int best = Integer.MAX_VALUE;
        int i = 0;
        int colNdx = ndx + 1;
        while (i <= rows) {
            int dist = this.m_dists[colNdx];
            if (dist < best) {
                best = dist;
            } else if (dist > best) break;
            ++i;
            colNdx += cols;
        }
        return best;
    }

    private int getBestCostAtLastCol() {
        return this.getBestTragetCharCost(this.m_targetStrChars.length - 1);
    }

    private int rowStartIndex(int rowNdx) {
        return (this.m_targetStrChars.length + 1) * rowNdx;
    }

    private void calculateLDDistance(char[] chs1, char[] chs2, int startFrom, boolean calculateFullCost) {
        int i;
        int j;
        int[] dists;
        int len2 = chs2.length;
        int len1 = chs1.length;
        if (len1 == 0 || len2 == 0) {
            return;
        }
        int n = len1 + 1;
        int m = len2 + 1;
        int[] nArray = dists = startFrom > 0 ? Arrays.copyOf(this.m_dists, n * m) : new int[n * m];
        if (startFrom > 0) {
            for (j = startFrom + 1; j <= len2; ++j) {
                dists[j * n] = j;
            }
        } else {
            for (i = 0; i <= len1; ++i) {
                dists[i] = i;
            }
            for (j = 0; j <= len2; ++j) {
                dists[j * n] = j;
            }
        }
        int n2 = j = startFrom > 0 ? startFrom + 1 : 1;
        while (j < m) {
            char ch2 = chs2[j - 1];
            int bestDist = Integer.MAX_VALUE;
            for (i = 1; i < n; ++i) {
                char ch1 = chs1[i - 1];
                int cost = ch1 == ch2 ? 0 : 1;
                int costNdx = j * n + i;
                int dist = Math.min(Math.min(dists[(j - 1) * n + i] + 1, dists[costNdx - 1] + 1), dists[(j - 1) * n + (i - 1)] + cost);
                if (i > 1 && j > 1 && chs1[i - 2] == ch2 && ch1 == chs2[j - 2]) {
                    dist = Math.min(dist, dists[(j - 2) * n + (i - 2)] + cost);
                }
                dists[costNdx] = dist;
                if (dist >= bestDist) continue;
                bestDist = dist;
            }
            this.m_numRowsCalculated = j;
            if (!calculateFullCost && bestDist > this.m_maxEdits) break;
            ++j;
        }
        this.m_dists = dists;
    }

    @Override
    public int getMatchWeight() {
        int matchWeight = 0;
        int tLen = this.m_targetStrChars.length;
        int eLen = this.m_evaluatedStrChars.length;
        if (tLen > 0 && eLen > 0) {
            int editDistance = eLen <= tLen ? this.getBestPrefixEditDistance() : this.getBestTargetEditDistance();
            int matchLen = tLen;
            if (eLen < tLen && eLen < (matchLen = this.bestMatchedTargetCharNdxAtWordBoundary(editDistance, this.m_maxEdits) + 1)) {
                editDistance = Math.max(editDistance, matchLen - eLen);
            }
            if (matchLen == 0) {
                matchWeight = 0;
            } else if (editDistance == 0) {
                matchWeight = 100;
            } else {
                matchWeight = this.m_targetStrChars[0] == this.m_evaluatedStrChars[0] ? 5 : 0;
                matchWeight += this.isCharNdxAtWordBoundary(matchLen) ? 5 : 0;
                matchWeight += 90 - (int)((double)editDistance / (double)matchLen * 100.0);
            }
        }
        return matchWeight;
    }

    @Override
    public void setTargetString(String target) {
        this.m_targetStrChars = null;
        if (target != null) {
            this.m_targetStrChars = target.toCharArray();
            this.m_dists = null;
            this.resetCostMatrix(0);
        }
    }

    private void resetCostMatrix(int fromNdx) {
        int tLen = this.m_targetStrChars.length;
        if (fromNdx == 0) {
            if (this.m_dists == null) {
                this.m_dists = new int[tLen + 1];
            }
            this.m_numRowsCalculated = 0;
        } else {
            this.m_numRowsCalculated = Math.min(this.m_numRowsCalculated, fromNdx);
        }
    }

    private int countSpaces(char[] chars, int charLen) {
        int spaces = 0;
        for (int i = 0; i < charLen; ++i) {
            if (chars[i] != ' ') continue;
            ++spaces;
        }
        return spaces;
    }

    @Override
    public String getTargetString() {
        return new String(this.m_targetStrChars);
    }

    @Override
    public String getEvaluatedString() {
        return this.m_evaluatedStrChars.toString();
    }

    @Override
    public MatchStats getMatchStats() {
        int targetMatchLen = this.targetMatchLength(false);
        return new MatchStats(targetMatchLen == this.m_targetStrChars.length, this.getMatchWeight(), targetMatchLen);
    }

    public String toString() {
        int i;
        this.checkCostCalculation(true);
        int n = this.m_targetStrChars.length + 1;
        int m = this.m_evaluatedStrChars.length + 1;
        StringBuilder sb = new StringBuilder();
        sb.append("\u2502 \u2502 \u2502");
        for (i = 1; i < n; ++i) {
            sb.append(this.m_targetStrChars[i - 1]);
            sb.append("\u2502");
        }
        sb.append("\r\n");
        sb.append("\u2502 \u2502");
        for (i = 1; i <= n; ++i) {
            sb.append(this.m_dists[i - 1]);
            sb.append("\u2502");
        }
        sb.append("\r\n");
        for (i = 1; i < m; ++i) {
            int s = i * n;
            sb.append("\u2502");
            sb.append(this.m_evaluatedStrChars[i - 1]);
            sb.append("\u2502");
            for (int j = 0; j < n; ++j) {
                sb.append(this.m_dists[s + j]);
                sb.append("\u2502");
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        EditDistance editDistance = new EditDistance("pitney", 2, 2, true);
        editDistance.appendChars("pitney bowes".toCharArray());
        editDistance.getBestPrefixEditDistance();
        logger.debug(editDistance.toString());
    }
}

