/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.matcher;

import com.mapinfo.mapmarker.autosuggest.utils.matcher.IMatcher;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.MatchStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExactExceptSpacesMatcher
implements IMatcher {
    private static final Logger LOG = LoggerFactory.getLogger((String)ExactExceptSpacesMatcher.class.getName());
    private String m_rawTarget;
    private String m_cookedTarget;
    private String m_rawEval;
    private String m_cookedEval;
    private boolean m_matchWholeWord;

    public ExactExceptSpacesMatcher(String target, boolean matchWholeWord) {
        this.setTargetString(target);
        this.m_matchWholeWord = matchWholeWord;
    }

    @Override
    public void setTargetString(String target) {
        this.m_rawTarget = target;
        this.m_cookedTarget = target.replaceAll(" ", "");
    }

    @Override
    public String getTargetString() {
        return this.m_rawTarget;
    }

    @Override
    public void setEvaluatedString(String eval) {
        this.m_rawEval = eval;
        this.m_cookedEval = eval.replaceAll(" ", "");
    }

    @Override
    public String getEvaluatedString() {
        return this.m_rawEval;
    }

    @Override
    public void appendChars(char[] chars) {
        if (this.m_rawEval == null) {
            this.setEvaluatedString("");
        } else {
            this.m_rawEval = this.m_rawEval + new String(chars);
            this.m_cookedEval = this.m_rawEval.replaceAll(" ", "");
        }
    }

    @Override
    public boolean prefixMatches(boolean partial) {
        int rtLen;
        Boolean results = null;
        int eLen = this.m_cookedEval.length();
        int tLen = this.m_cookedTarget.length();
        int reLen = this.m_rawEval.length();
        if (reLen == (rtLen = this.m_rawTarget.length()) && this.m_rawEval.equals(this.m_rawTarget)) {
            results = true;
        } else if (tLen <= eLen) {
            results = this.m_cookedEval.startsWith(this.m_cookedTarget);
        } else if (!(partial || rtLen > reLen && this.m_rawTarget.charAt(reLen) == ' ')) {
            results = false;
        }
        if (results == null) {
            results = this.m_cookedTarget.startsWith(this.m_cookedEval);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("prefix matches(): |%s| |%s| -> %s", this.m_rawTarget, this.m_rawEval, results));
        }
        return results;
    }

    @Override
    public boolean matches() {
        Boolean results = null;
        int eLen = this.m_cookedEval.length();
        int tLen = this.m_cookedTarget.length();
        int reLen = this.m_rawEval.trim().length();
        int rtLen = this.m_rawTarget.trim().length();
        if (eLen == tLen) {
            results = this.m_cookedEval.equals(this.m_cookedTarget);
        } else if (this.m_matchWholeWord) {
            if (eLen < tLen) {
                results = false;
            } else if (rtLen < reLen && this.m_rawEval.charAt(rtLen) != ' ') {
                results = false;
            }
        }
        if (results == null) {
            if (eLen >= tLen) {
                results = this.m_cookedEval.startsWith(this.m_cookedTarget);
            } else if (reLen < rtLen && this.m_rawTarget.charAt(reLen) == ' ') {
                results = this.m_cookedTarget.startsWith(this.m_cookedEval);
            }
        }
        if (results == null) {
            results = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("matches(): |%s| |%s| -> %s", this.m_rawTarget, this.m_rawEval, results));
        }
        return results;
    }

    @Override
    public int getMatchWeight() {
        return 100;
    }

    public boolean matchWholeWord() {
        return this.m_matchWholeWord;
    }

    @Override
    public boolean targetPrefixMatches() {
        Boolean results = null;
        if (this.m_matchWholeWord) {
            int rtLen;
            int eLen = this.m_cookedEval.length();
            int tLen = this.m_cookedTarget.length();
            int reLen = this.m_rawEval.length();
            if (reLen == (rtLen = this.m_rawTarget.length()) && this.m_rawEval.equals(this.m_rawTarget)) {
                results = true;
            } else if (eLen < tLen || reLen <= rtLen || eLen > tLen && this.m_rawEval.charAt(rtLen) != ' ') {
                results = false;
            }
        }
        if (results == null) {
            results = this.m_cookedEval.startsWith(this.m_cookedTarget);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("target prefix matches(): |%s| |%s| -> %s", this.m_rawTarget, this.m_rawEval, results));
        }
        return results;
    }

    @Override
    public int targetMatchLength(boolean partial) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public MatchStats getMatchStats() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public String toString() {
        return "exactExceptSpaces(" + this.m_rawTarget + ")";
    }
}

