/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.matcher;

import com.mapinfo.mapmarker.autosuggest.utils.matcher.IMatcher;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.MatchStats;
import com.mapinfo.mapmarker.cgge.soundex.CGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;

class SoundexMatcher
implements IMatcher {
    private static CGGESoundex m_soundexer = new CGGESoundex();
    private String m_targetString = null;
    private String m_evalString = null;
    private int[] m_targetSndxs = null;
    private int[] m_evalSndxs = null;

    public SoundexMatcher(String target) {
        this.setTargetString(target);
    }

    @Override
    public void appendChars(char[] chars) {
        if (chars != null && chars.length > 0) {
            this.m_evalString = this.m_evalString == null ? new String(chars) : this.m_evalString + chars;
            this.setEvaluatedString(this.m_evalString);
        }
    }

    @Override
    public void setEvaluatedString(String str) {
        this.m_evalString = str;
        this.m_evalSndxs = null;
        if (this.m_evalString != null && this.matchedFirstChar() && this.isSameType()) {
            this.m_evalSndxs = this.getSoundex(this.m_evalString);
        }
    }

    @Override
    public boolean prefixMatches(boolean partial) {
        return this.checkSoundexMatches(this.m_targetSndxs, this.m_evalSndxs, partial);
    }

    private boolean checkSoundexMatches(int[] sndx1, int[] sndx2, boolean partial) {
        if (sndx1 == null || sndx2 == null) {
            return false;
        }
        int len = sndx2.length;
        if (sndx1.length < len) {
            return false;
        }
        if (partial) {
            if (!m_soundexer.startsWithSoundex(sndx1[len - 1], sndx2[len - 1])) {
                return false;
            }
            --len;
        }
        for (int w = 0; w < len; ++w) {
            if (sndx1[w] == sndx2[w]) continue;
            return false;
        }
        return true;
    }

    private boolean matchedFirstChar() {
        int eLen;
        int tLen = this.m_targetString == null ? 0 : this.m_targetString.length();
        int n = eLen = this.m_evalString == null ? 0 : this.m_evalString.length();
        if (tLen > 0 && eLen > 0) {
            return this.m_targetString.charAt(0) == this.m_evalString.charAt(0);
        }
        return false;
    }

    private boolean isSameType() {
        int eLen;
        int tLen = this.m_targetString == null ? 0 : this.m_targetString.length();
        int n = eLen = this.m_evalString == null ? 0 : this.m_evalString.length();
        if (tLen > 0 && eLen > 0) {
            return MMUtils.containsDigits((String)this.m_targetString) == MMUtils.containsDigits((String)this.m_evalString);
        }
        return false;
    }

    @Override
    public boolean matches() {
        if (this.m_targetSndxs == null || this.m_evalSndxs == null) {
            return false;
        }
        int len = this.m_targetSndxs.length;
        if (len == this.m_evalSndxs.length) {
            for (int w = 0; w < len; ++w) {
                if (this.m_targetSndxs[w] == this.m_evalSndxs[w]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getMatchWeight() {
        int eLen;
        int tLen = this.m_targetString == null ? 0 : this.m_targetString.length();
        int n = eLen = this.m_evalString == null ? 0 : this.m_evalString.length();
        if (tLen != 0 && eLen != 0) {
            int m;
            int n2 = Math.max(tLen, eLen);
            if (n2 == (m = Math.min(tLen, eLen))) {
                if (this.m_targetString.equals(this.m_evalString)) {
                    return 100;
                }
                return 90;
            }
            return (int)((double)m / (double)n2 * 100.0);
        }
        return 0;
    }

    private int[] getSoundex(String str) {
        String[] words = str.trim().split(" ");
        int wordCount = words.length;
        int[] wordSoundexes = new int[wordCount];
        for (int i = 0; i < wordCount; ++i) {
            wordSoundexes[i] = m_soundexer.getSoundex(words[i]);
        }
        return wordSoundexes;
    }

    @Override
    public void setTargetString(String target) {
        this.m_targetString = target;
        this.m_targetSndxs = this.getSoundex(target);
    }

    @Override
    public String getTargetString() {
        return this.m_targetString;
    }

    @Override
    public String getEvaluatedString() {
        return this.m_evalString;
    }

    @Override
    public boolean targetPrefixMatches() {
        return this.checkSoundexMatches(this.m_evalSndxs, this.m_targetSndxs, true);
    }

    @Override
    public int targetMatchLength(boolean partial) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public MatchStats getMatchStats() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public String toString() {
        return "soundex(" + this.m_targetString + ")";
    }

    static {
        m_soundexer.init("english", null);
    }
}

