/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.quadtree;

import com.mapinfo.mapmarker.autosuggest.utils.quadtree.IQuadTreeItem;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.InternalQuadTreeException;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadTree;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.IReadable;
import com.mapinfo.mapmarker.cgge.utils.io.IWritable;
import java.io.IOException;
import java.util.List;

public abstract class AbstractQuad
implements IQuadTreeItem,
IWritable,
IReadable {
    private Rectangle m_bounds;
    private List<IQuadTreeItem> m_children;
    private final QuadTree<? extends IQuadTreeItem> m_tree;
    private int m_quadID;

    public AbstractQuad(Rectangle bounds, QuadTree<? extends IQuadTreeItem> tree, int quadID) {
        this.m_tree = tree;
        this.m_bounds = bounds;
        this.m_quadID = quadID;
    }

    public List<IQuadTreeItem> getChildren() {
        return this.m_children;
    }

    protected QuadTree<? extends IQuadTreeItem> getTree() {
        return this.m_tree;
    }

    protected void setChildren(List<IQuadTreeItem> children) {
        this.m_children = children;
    }

    public void setBounds(Rectangle rect) {
        this.m_bounds = rect;
    }

    @Override
    public Rectangle getBounds() {
        return this.m_bounds;
    }

    public int getChildCount() {
        return this.m_children == null ? 0 : this.m_children.size();
    }

    public abstract AbstractQuad add(IQuadTreeItem var1);

    protected void addChild(IQuadTreeItem item) {
        if (!this.intersects(item)) {
            throw new InternalQuadTreeException("Item does not intesect quad");
        }
        this.m_children = ListUtils.addToList(this.m_children, (Object)item);
    }

    public boolean intersects(IQuadTreeItem obj) {
        return this.m_bounds.intersects(obj.getBounds());
    }

    public boolean pointInQuad(double x, double y) {
        return this.m_bounds.pointInRect(x, y);
    }

    public int getQuadID() {
        return this.m_quadID;
    }

    void setQuadID(int quadID) {
        this.m_quadID = quadID;
    }

    public void read(ICGGEDataInput in) throws IOException {
        this.m_bounds = new Rectangle();
        this.m_bounds.read(in);
        this.readChildren(in);
    }

    public void write(ICGGEDataOutput out) throws IOException {
        this.m_bounds.write(out);
        this.writeChildren(out);
    }

    public abstract void writeChildren(ICGGEDataOutput var1) throws IOException;

    public abstract boolean isLeaf();

    public abstract void readChildren(ICGGEDataInput var1) throws IOException;
}

