/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.quadtree;

import com.mapinfo.mapmarker.autosuggest.utils.GeomUtil;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.AbstractQuad;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.DiskQuadLeaf;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.DiskQuadTree;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.DiskQuadTreeItem;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.GeoHashTree;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.IQuadTreeItem;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadTree;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import java.util.List;

public class GeoHashLeaf<V extends DiskQuadTreeItem>
extends DiskQuadLeaf<V> {
    private int m_level;

    public GeoHashLeaf(Rectangle bounds, QuadTree<V> tree, int quadID) {
        super(bounds, (DiskQuadTree)tree, quadID);
    }

    protected int getLevel() {
        return this.m_level;
    }

    protected void setLevel(int level) {
        this.m_level = level;
    }

    @Override
    protected AbstractQuad splitQuad() {
        AbstractQuad quad = super.splitQuad();
        quad.setQuadID(this.getQuadID());
        return quad;
    }

    @Override
    protected boolean needQuadSplit(IQuadTreeItem item) {
        if (this.m_level < GeoHashTree.MAX_DEPTH) {
            return super.needQuadSplit(item);
        }
        return false;
    }

    @Override
    protected List<IQuadTreeItem> splitIntoQuads(QuadTree<? extends IQuadTreeItem> tree) {
        List<IQuadTreeItem> quads = super.splitIntoQuads(tree);
        int childLevel = this.getLevel() + 1;
        int i = 0;
        for (GeomUtil.Direction dir : GeomUtil.Direction.values()) {
            GeoHashLeaf leaf = (GeoHashLeaf)quads.get(i++);
            leaf.setLevel(childLevel);
            leaf.setQuadID(GeoHashTree.getGeoHash(childLevel, this.getQuadID(), dir));
        }
        return quads;
    }
}

