/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.quadtree;

import com.mapinfo.mapmarker.autosuggest.utils.GeomUtil;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.AbstractQuad;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.IQuadTreeItem;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadNode;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadTree;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class QuadLeaf
extends AbstractQuad {
    private static double MIN_DISTANCE = 0.009000009000009001;

    public QuadLeaf(Rectangle bounds, QuadTree<? extends IQuadTreeItem> tree, int quadID) {
        super(bounds, tree, quadID);
    }

    protected AbstractQuad splitQuad() {
        Rectangle bounds = this.getBounds();
        QuadNode quadNode = this.getTree().getNewQuadNode(bounds);
        QuadTree<? extends IQuadTreeItem> tree = this.getTree();
        List<IQuadTreeItem> quads = this.splitIntoQuads(tree);
        this.disperseChildren(quads, this.getChildren());
        quadNode.setChildren(quads);
        return quadNode;
    }

    protected List<IQuadTreeItem> splitIntoQuads(QuadTree<? extends IQuadTreeItem> tree) {
        Rectangle[] rects;
        ArrayList<IQuadTreeItem> quads = new ArrayList<IQuadTreeItem>(4);
        for (Rectangle rect : rects = GeomUtil.quadSplit(this.getBounds())) {
            quads.add(tree.getNewQuadLeaf(rect));
        }
        return quads;
    }

    protected void disperseChildren(List<IQuadTreeItem> quads, List<IQuadTreeItem> items) {
        int quadCount = quads.size();
        for (IQuadTreeItem item : items) {
            for (int i = 0; i < quadCount; ++i) {
                AbstractQuad newParent;
                AbstractQuad quad = (AbstractQuad)quads.get(i);
                if (!quad.intersects(item) || (newParent = quad.add(item)) == null) continue;
                quads.set(i, newParent);
            }
        }
    }

    @Override
    public AbstractQuad add(IQuadTreeItem item) {
        if (this.needQuadSplit(item)) {
            AbstractQuad newNode = this.splitQuad();
            newNode.add(item);
            return newNode;
        }
        this.addChild(item);
        return null;
    }

    protected boolean needQuadSplit(IQuadTreeItem item) {
        return this.getChildCount() >= this.getTree().getMaxQuadItems() && this.getBounds().fullyContains(item.getBounds()) && this.getLongestSideLength() > MIN_DISTANCE;
    }

    private double getLongestSideLength() {
        Rectangle bounds = this.getBounds();
        return Math.max(bounds.getWidth(), bounds.getHeight());
    }

    @Override
    public void readChildren(ICGGEDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeChildren(ICGGEDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }
}

