/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.quadtree;

import com.mapinfo.mapmarker.autosuggest.utils.LongLatBox;

public class Rectangle
extends LongLatBox {
    public Rectangle() {
    }

    public Rectangle(double west, double south, double east, double north) {
        super(west, south, east, north);
    }

    public Rectangle(double[] bottomLeft, double[] topRight) {
        super(bottomLeft[0], bottomLeft[1], topRight[0], topRight[1]);
    }

    public Rectangle(Rectangle rectangle) {
        super(rectangle);
    }

    public double[] getTopRight() {
        return new double[]{this.getEast(), this.getNorth()};
    }

    public double[] getBottomLeft() {
        return new double[]{this.getWest(), this.getSouth()};
    }

    public void setTopRight(double x, double y) {
        this.setEast(x);
        this.setNorth(y);
    }

    public void setBottomLeft(double x, double y) {
        this.setWest(x);
        this.setSouth(y);
    }

    public boolean fullyWithin(LongLatBox rect) {
        return this.fullyContains(rect);
    }

    public double getBottom() {
        return this.getSouth();
    }

    public double getTop() {
        return this.getNorth();
    }

    public double getLeft() {
        return this.getWest();
    }

    public double getRight() {
        return this.getEast();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[Rectangle:");
        sb.append(" W: ").append(this.getWest());
        sb.append(", S: ").append(this.getSouth());
        sb.append(", E: ").append(this.getEast());
        sb.append(", N: ").append(this.getNorth());
        sb.append("]");
        return sb.toString();
    }
}

