/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.radixtree;

import com.mapinfo.mapmarker.autosuggest.utils.SubLevelIterator;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IMatchResult;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.NodeFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.NodeMatchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class RadixTreeMatchResult<V>
implements Iterable<IMatchResult<V>> {
    private final NodeFilter<V> m_filter;
    private final List<NodeMatchResult<V>> m_matchingEdgeNodes;

    public RadixTreeMatchResult(List<NodeMatchResult<V>> matchingEdgeNodes, NodeFilter<V> nodeFilter) {
        this.m_matchingEdgeNodes = matchingEdgeNodes;
        this.m_filter = nodeFilter;
    }

    public RadixTreeMatchResult(NodeMatchResult<V> matchingEdgeNode, NodeFilter<V> nodeFilter) {
        this.m_matchingEdgeNodes = new ArrayList<NodeMatchResult<V>>(1);
        this.m_matchingEdgeNodes.add(matchingEdgeNode);
        this.m_filter = nodeFilter;
    }

    public RadixTreeMatchResult<V> copyOf(NodeFilter<V> nodeFilter) {
        return new RadixTreeMatchResult<V>(this.m_matchingEdgeNodes, nodeFilter);
    }

    @Override
    public Iterator<IMatchResult<V>> iterator() {
        return new SubLevelIterator<NodeMatchResult<V>, NodeMatchResult<V>, IMatchResult<V>>(){

            @Override
            public Iterator<NodeMatchResult<V>> getSubIterator(NodeMatchResult<V> mainItem) {
                Iterator it = mainItem.getChildResultIterator(RadixTreeMatchResult.this.m_filter);
                if (it != null && it.hasNext()) {
                    return it;
                }
                List r = Collections.emptyList();
                return r.iterator();
            }

            @Override
            public IMatchResult<V> getItem(NodeMatchResult<V> subItem) {
                return subItem;
            }

            @Override
            public Iterator<NodeMatchResult<V>> getMainIterator() {
                return RadixTreeMatchResult.this.m_matchingEdgeNodes.iterator();
            }
        };
    }

    public NodeFilter<V> getNodeFilter() {
        return this.m_filter;
    }

    public List<NodeMatchResult<V>> getMatchingEdgeNodes() {
        return this.m_matchingEdgeNodes;
    }
}

