/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.radixtree;

import com.mapinfo.mapmarker.autosuggest.utils.radixtree.ITreeNode;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class RadixTreeUtils {
    public static <V> void compress(RadixTree<V> radixTree) {
        if (!radixTree.isEmpty() && radixTree.updatesAllowed()) {
            SortedSet<char[]> sortedKeys = RadixTreeUtils.getUniqueNodeKeys(radixTree);
            ArrayList<char[]> keys = new ArrayList<char[]>(sortedKeys);
            Comparator<char[]> comp = RadixTreeUtils.getCharacterArrayComparator();
            RadixTreeUtils.replaceNodeKeys(radixTree.getRootNode(), keys, comp);
            radixTree.updatesAllowed(false);
        }
    }

    public static int getMatchedPrefixLength(char[] chars1, char[] chars2, int startAt) {
        int matchedPrefixLength = 0;
        int charsToCheck = Math.min(chars1.length - startAt, chars2.length);
        for (int i = 0; i < charsToCheck && chars1[startAt + i] == chars2[i]; ++i) {
            ++matchedPrefixLength;
        }
        return matchedPrefixLength;
    }

    public static int compareChars(char[] chars1, char[] chars2, int chars1StartNdx) {
        int l1 = chars1.length;
        int l2 = chars2.length;
        int min = Math.min(l1 - chars1StartNdx, l2);
        for (int i = 0; i < min; ++i) {
            int c = chars1[chars1StartNdx + i] - chars2[i];
            if (c == 0) continue;
            return c;
        }
        return l1 - l2;
    }

    public static int compareChars(char[] chars1, char[] chars2) {
        return RadixTreeUtils.compareChars(chars1, chars2, 0);
    }

    private static <V> SortedSet<char[]> getUniqueNodeKeys(RadixTree<V> radixTree) {
        ITreeNode<V> root = radixTree.getRootNode();
        if (root != null) {
            TreeSet<char[]> keys = new TreeSet<char[]>(RadixTreeUtils.getCharacterArrayComparator());
            RadixTreeUtils.addNodeKeys(root, keys);
            return keys;
        }
        return null;
    }

    private static <V> void replaceNodeKeys(ITreeNode<V> node, List<char[]> keys, Comparator<char[]> comp) {
        if (node.getKeyLength() > 0) {
            char[] oldkey = node.getKey();
            int i = Collections.binarySearch(keys, oldkey, comp);
            char[] newkey = keys.get(i);
            node.setKey(newkey);
        }
        if (node.hasChildren()) {
            for (ITreeNode<V> child : node.getChildNodes()) {
                RadixTreeUtils.replaceNodeKeys(child, keys, comp);
            }
        }
    }

    private static <V> void addNodeKeys(ITreeNode<V> node, Collection<char[]> keys) {
        keys.add(node.getKey());
        if (node.hasChildren()) {
            for (ITreeNode<V> child : node.getChildNodes()) {
                RadixTreeUtils.addNodeKeys(child, keys);
            }
        }
    }

    private static Comparator<char[]> getCharacterArrayComparator() {
        return new Comparator<char[]>(){

            @Override
            public int compare(char[] key1, char[] key2) {
                return RadixTreeUtils.compareChars(key1, key2);
            }
        };
    }
}

