/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.radixtree;

import com.mapinfo.mapmarker.autosuggest.utils.LinkedTailItem;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeValueFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.ITreeNode;

class TreeTransition<V>
extends LinkedTailItem {
    static final int CHILD_NDX_UNKNOWN = -1;
    private ITreeNode<V> m_node;
    private final int m_nodeNdx;
    private final String m_key;

    TreeTransition(TreeTransition<V> from, ITreeNode<V> node, int nodeNdx) {
        this(from, node, nodeNdx, TreeTransition.buildFullKey(from, node.getKey()));
    }

    private TreeTransition(TreeTransition<V> from, ITreeNode<V> node, int nodeNdx, String key) {
        super(from);
        this.m_node = node;
        this.m_nodeNdx = nodeNdx;
        this.m_key = key;
    }

    ITreeNode<V> getNode() {
        return this.m_node;
    }

    int getNodeNdx() {
        return this.m_nodeNdx;
    }

    boolean refetchNode(INodeValueFilter<V> nodeValueFilter) {
        TreeTransition parentTrans;
        if (this.m_nodeNdx != -1 && (parentTrans = (TreeTransition)this.previous()) != null) {
            ITreeNode<V> parentNode = parentTrans.getNode();
            ITreeNode<V> refetchedNode = parentNode.getChildNode(this.m_nodeNdx, nodeValueFilter);
            this.m_node = refetchedNode;
            return true;
        }
        return false;
    }

    static <V> String buildFullKey(TreeTransition<V> trans, char[] childKey) {
        StringBuilder sb = new StringBuilder();
        if (trans != null) {
            sb.append(trans.getKey());
        }
        sb.append(childKey);
        return sb.toString();
    }

    String getKey() {
        return this.m_key;
    }

    int getKeyLen() {
        return this.m_key.length();
    }

    int getParentKeyLen() {
        return this.getKeyLen() - this.getNode().getKey().length;
    }

    char[] getNodeKey() {
        return this.m_node.getKey();
    }

    int getNodeKeyLen() {
        return this.getNode().getKey().length;
    }

    boolean hasNodeValue() {
        return this.getNode().hasValue();
    }

    public String toString() {
        return this.m_key;
    }
}

