/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.radixtree;

import com.mapinfo.mapmarker.autosuggest.utils.IteratorUtils;
import com.mapinfo.mapmarker.autosuggest.utils.ReadOnlyIterator;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeKeyFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeValueFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.ITreeNode;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.ITreeWalkingFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.NodeFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTreeUtils;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.TreeTransition;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.TreeWalkingFilter;
import java.util.NoSuchElementException;

class TreeWalker<V> {
    private final NextNodePointer<V> m_nextNodePointer;

    private TreeWalker(NextNodePointer<V> nextNodePointer) {
        this.m_nextNodePointer = nextNodePointer;
    }

    static <V> TreeWalker<V> getTreeWalkerInstance(char[] targetChars, TreeTransition<V> from, NodeFilter<V> filter) {
        INodeValueFilter<V> nodeValueFilter = null;
        INodeKeyFilter nodeKeyFilter = null;
        if (filter != null) {
            nodeValueFilter = filter.getValueFilter();
            nodeKeyFilter = filter.getKeyFilter();
        }
        return new TreeWalker(new NextNodePointer(targetChars, TreeWalkingFilter.getTreeWalkingFilter(targetChars, nodeKeyFilter), from, nodeValueFilter));
    }

    static <V> TreeWalker<V> getPrefixTreeWalkerInstance(char[] targetChars, TreeTransition<V> from, NodeFilter<V> filter) {
        INodeValueFilter<V> nodeValueFilter = null;
        INodeKeyFilter nodeKeyFilter = null;
        if (filter != null) {
            nodeValueFilter = filter.getValueFilter();
            nodeKeyFilter = filter.getKeyFilter();
        }
        if (nodeKeyFilter == null) {
            return TreeWalker.getExactTreeWalkerInstance(targetChars, from, filter);
        }
        return new TreeWalker(new NextNodePointer(targetChars, TreeWalkingFilter.getPrefixTreeWalkingFilter(targetChars, nodeKeyFilter), from, nodeValueFilter));
    }

    static <V> TreeWalker<V> getExactTreeWalkerInstance(char[] targetChars, TreeTransition<V> from, NodeFilter<V> filter) {
        INodeValueFilter<V> nodeValueFilter = null;
        INodeKeyFilter nodeKeyFilter = null;
        if (filter != null) {
            nodeValueFilter = filter.getValueFilter();
            nodeKeyFilter = filter.getKeyFilter();
        }
        return new TreeWalker(new ExactNextNodePointer(targetChars, TreeWalkingFilter.getPrefixTreeWalkingFilter(targetChars, nodeKeyFilter), from, nodeValueFilter));
    }

    Iterable<TreeTransition<V>> traverse() {
        return this.traverse(false);
    }

    Iterable<TreeTransition<V>> traverse(boolean includeFrom) {
        return IteratorUtils.iterable(new It(includeFrom));
    }

    private static class ExactNextNodePointer<V>
    extends NextNodePointer<V> {
        ExactNextNodePointer(char[] targetChars, ITreeWalkingFilter<V> filter, TreeTransition<V> from, INodeValueFilter<V> nodeValueFilter) {
            super(targetChars, filter, from, nodeValueFilter);
        }

        @Override
        TreeTransition<V> getSiblingTransition(TreeTransition<V> trans) {
            return null;
        }

        @Override
        TreeTransition<V> getChildTransition(TreeTransition<V> trans, int childNdx) {
            ITreeNode<V> node;
            ChildKeyAndIndex bestChildKeyAndNdx;
            char[] targetChars = this.getTargetChars();
            if (trans.getKeyLen() < targetChars.length && (bestChildKeyAndNdx = this.getBestChildKey(node = trans.getNode(), targetChars, trans.getKeyLen())) != null && this.getFilter().acceptChildKey(trans, bestChildKeyAndNdx.m_key)) {
                return new TreeTransition<V>(trans, this.getChildNode(node, bestChildKeyAndNdx.m_ndx), bestChildKeyAndNdx.m_ndx);
            }
            return null;
        }

        private final ChildKeyAndIndex getBestChildKey(ITreeNode<V> node, char[] searchKey, int searchKeyStartNdx) {
            int size = node.getChildCount();
            char[] bestChildKey = null;
            int bestChildNdx = -1;
            char firstChar = searchKey[searchKeyStartNdx];
            if (size > 0) {
                int low = 0;
                int high = size - 1;
                while (low <= high) {
                    int mid = low + high >> 1;
                    char[] childKey = node.getChildKey(mid);
                    int c = firstChar - childKey[0];
                    if (c == 0) {
                        bestChildNdx = mid;
                        bestChildKey = childKey;
                        c = RadixTreeUtils.compareChars(searchKey, childKey, searchKeyStartNdx);
                    }
                    if (c > 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (c >= 0) break;
                    high = mid - 1;
                }
            }
            if (bestChildKey != null) {
                return new ChildKeyAndIndex(bestChildNdx, bestChildKey);
            }
            return null;
        }

        private static class ChildKeyAndIndex {
            private final int m_ndx;
            private final char[] m_key;

            ChildKeyAndIndex(int ndx, char[] key) {
                this.m_ndx = ndx;
                this.m_key = key;
            }
        }
    }

    private static class NextNodePointer<V> {
        private final ITreeWalkingFilter<V> m_filter;
        private final TreeTransition<V> m_from;
        private final char[] m_targetChars;
        private final INodeValueFilter<V> m_nodeValueFilter;

        NextNodePointer(char[] targetChars, ITreeWalkingFilter<V> filter, TreeTransition<V> from, INodeValueFilter<V> nodeValueFilter) {
            if (filter == null) {
                throw new NullPointerException("filter is null");
            }
            this.m_nodeValueFilter = nodeValueFilter;
            this.m_filter = filter;
            this.m_from = from;
            this.m_targetChars = targetChars;
        }

        TreeTransition<V> moveNext(TreeTransition<V> trans) {
            TreeTransition<V> next = null;
            if (this.m_filter.continueFrom(trans) && (next = this.getChildTransition(trans, 0)) != null) {
                return next;
            }
            while (trans != null) {
                if (trans != this.m_from) {
                    next = this.getSiblingTransition(trans);
                    if (next != null) {
                        return next;
                    }
                    trans = (TreeTransition)trans.previous();
                    continue;
                }
                trans = null;
            }
            return null;
        }

        TreeTransition<V> getSiblingTransition(TreeTransition<V> trans) {
            TreeTransition parentTrans = (TreeTransition)trans.previous();
            if (parentTrans != null) {
                return this.getChildTransition(parentTrans, trans.getNodeNdx() + 1);
            }
            return null;
        }

        TreeTransition<V> getChildTransition(TreeTransition<V> trans, int childNdx) {
            ITreeNode<V> node = trans.getNode();
            int childCount = node.getChildCount();
            while (childNdx < childCount) {
                char[] childKey = node.getChildKey(childNdx);
                if (this.m_filter.acceptChildKey(trans, childKey)) {
                    return new TreeTransition<V>(trans, this.getChildNode(node, childNdx), childNdx);
                }
                ++childNdx;
            }
            return null;
        }

        TreeTransition<V> getFrom() {
            return this.m_from;
        }

        ITreeWalkingFilter<V> getFilter() {
            return this.m_filter;
        }

        char[] getTargetChars() {
            return this.m_targetChars;
        }

        ITreeNode<V> getChildNode(ITreeNode<V> parent, int childNdx) {
            return parent.getChildNode(childNdx, this.m_nodeValueFilter);
        }
    }

    private class It
    extends ReadOnlyIterator<TreeTransition<V>> {
        TreeTransition<V> m_next;

        It(boolean includeFrom) {
            this.m_next = includeFrom ? TreeWalker.this.m_nextNodePointer.getFrom() : TreeWalker.this.m_nextNodePointer.moveNext(TreeWalker.this.m_nextNodePointer.getFrom());
        }

        @Override
        public boolean hasNext() {
            return this.m_next != null;
        }

        @Override
        public TreeTransition<V> next() {
            if (this.m_next == null) {
                throw new NoSuchElementException();
            }
            TreeTransition curr = this.m_next;
            this.m_next = TreeWalker.this.m_nextNodePointer.moveNext(curr);
            return curr;
        }
    }
}

