/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.radixtree;

import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeKeyFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.ITreeWalkingFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTreeUtils;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.TreeTransition;

class TreeWalkingFilter<V>
implements ITreeWalkingFilter<V> {
    private final INodeKeyFilter m_keyFilter;
    private final char[] m_targetChars;

    private TreeWalkingFilter(char[] targetChars, INodeKeyFilter nodeKeyFilter) {
        this.m_keyFilter = nodeKeyFilter;
        this.m_targetChars = targetChars;
    }

    static <V> ITreeWalkingFilter<V> getTreeWalkingFilter(char[] targetChars, INodeKeyFilter nodeKeyFilter) {
        return new TreeWalkingFilter<V>(targetChars, nodeKeyFilter);
    }

    static <V> ITreeWalkingFilter<V> getPrefixTreeWalkingFilter(char[] targetChars, INodeKeyFilter nodeKeyFilter) {
        return new PrefixTreeWalkingFilter(targetChars, nodeKeyFilter);
    }

    @Override
    public boolean acceptChildKey(TreeTransition<V> parent, char[] childKey) {
        if (this.m_keyFilter != null) {
            return this.passKeyFilter(parent, childKey);
        }
        return true;
    }

    @Override
    public boolean continueFrom(TreeTransition<V> trans) {
        return true;
    }

    private boolean passKeyFilter(TreeTransition<V> trans, char[] childKey) {
        String fullKey = TreeTransition.buildFullKey(trans, childKey);
        if (fullKey.length() <= this.getTargetCharLen()) {
            return this.m_keyFilter.prefixMatch(fullKey);
        }
        return this.m_keyFilter.acceptKey(fullKey);
    }

    private int getTargetCharLen() {
        return this.m_targetChars == null ? 0 : this.m_targetChars.length;
    }

    private char[] getTargetChars() {
        return this.m_targetChars;
    }

    private static class PrefixTreeWalkingFilter<V>
    extends TreeWalkingFilter<V> {
        PrefixTreeWalkingFilter(char[] targetChars, INodeKeyFilter nodeKeyFilter) {
            super(targetChars, nodeKeyFilter);
        }

        @Override
        public boolean continueFrom(TreeTransition<V> trans) {
            INodeKeyFilter keyFilter = ((TreeWalkingFilter)this).m_keyFilter;
            if (keyFilter != null) {
                int keyLen = trans.getKeyLen();
                if (keyLen > 0 && keyLen >= ((TreeWalkingFilter)this).getTargetCharLen()) {
                    return !keyFilter.acceptKey(trans.getKey());
                }
            } else {
                return this.keyFullyMatched(trans);
            }
            return true;
        }

        @Override
        public boolean acceptChildKey(TreeTransition<V> parent, char[] childKey) {
            if (((TreeWalkingFilter)this).m_keyFilter == null) {
                return parent.getKeyLen() < ((TreeWalkingFilter)this).getTargetCharLen();
            }
            return super.acceptChildKey(parent, childKey);
        }

        private boolean keyFullyMatched(TreeTransition<V> trans) {
            int matchedChars;
            char[] nodeKeyChars = trans.getNodeKey();
            return nodeKeyChars.length == (matchedChars = RadixTreeUtils.getMatchedPrefixLength(((TreeWalkingFilter)this).getTargetChars(), nodeKeyChars, trans.getParentKeyLen()));
        }
    }
}

