/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.substitution;

import com.mapinfo.mapmarker.autosuggest.utils.StringNormalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SubstitutionMap {
    HashMap<String, HashSet<String>> map = new HashMap();

    public boolean containsKey(String str) {
        return this.map.containsKey(str);
    }

    public boolean contains(String str) {
        if (this.map.containsKey(str)) {
            return true;
        }
        for (HashSet<String> value : this.map.values()) {
            if (!value.contains(str)) continue;
            return true;
        }
        return false;
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public void add(String key, String value) {
        if (key == null) {
            return;
        }
        HashSet<String> values = this.map.get(key = this.normalizeString(key));
        if (values == null) {
            values = new HashSet();
            this.map.put(key, values);
        }
        values.add(this.normalizeString(value));
    }

    public void addAll(String key, Collection<String> valueSet) {
        if (key == null || valueSet == null) {
            return;
        }
        HashSet<String> values = this.map.get(key = this.normalizeString(key));
        if (values == null) {
            values = new HashSet();
            this.map.put(key, values);
        }
        for (String newVal : valueSet) {
            values.add(this.normalizeString(newVal));
        }
    }

    protected String normalizeString(String str) {
        if (str == null) {
            return null;
        }
        String changed = StringNormalizer.normalise(str);
        if (changed != null) {
            return changed;
        }
        return "";
    }

    public Set<String> getValues(String key) {
        return this.getValues(key, true);
    }

    public Set<String> getValues(String key, boolean includeKey) {
        HashSet<String> returnValues = new HashSet<String>();
        HashSet<String> values = this.map.get(key);
        if (values == null) {
            boolean bFoundKeyAsValue = false;
            for (HashSet<String> valueSet : this.map.values()) {
                if (!valueSet.contains(key)) continue;
                bFoundKeyAsValue = true;
                returnValues.addAll(valueSet);
                for (String keyForValue : this.map.keySet()) {
                    HashSet<String> valuesForKey = this.map.get(keyForValue);
                    if (valuesForKey == null || valueSet.size() != valuesForKey.size() || !valuesForKey.contains(key)) continue;
                    returnValues.add(keyForValue);
                }
            }
            if (!bFoundKeyAsValue) {
                return Collections.emptySet();
            }
        } else if (values.size() != 1 || !values.contains("")) {
            returnValues.addAll(values);
        }
        if (includeKey) {
            returnValues.add(key);
        }
        return returnValues;
    }

    public void write(DataOutput dataStream) throws IOException {
        if (this.map == null || this.map.isEmpty()) {
            dataStream.writeInt(0);
            return;
        }
        Set<String> keys = this.map.keySet();
        if (keys == null) {
            dataStream.writeInt(0);
            return;
        }
        dataStream.writeInt(keys.size());
        for (String key : keys) {
            dataStream.writeUTF(key);
            Set<String> values = this.getValues(key, false);
            if (values == null) {
                dataStream.writeInt(0);
                continue;
            }
            dataStream.writeInt(values.size());
            for (String value : values) {
                dataStream.writeUTF(value);
            }
        }
    }

    public void read(DataInput dataStream) throws IOException {
        this.map.clear();
        int numKeys = dataStream.readInt();
        if (numKeys == 0) {
            return;
        }
        for (int i = 0; i < numKeys; ++i) {
            String keyName = dataStream.readUTF();
            int numValues = dataStream.readInt();
            HashSet<String> newValues = new HashSet<String>();
            for (int j = 0; j < numValues; ++j) {
                String valueName = dataStream.readUTF();
                newValues.add(valueName);
            }
            this.map.put(keyName, newValues);
        }
    }
}

