/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.substitution;

import com.mapinfo.mapmarker.autosuggest.utils.HashTaggedToken;
import com.mapinfo.mapmarker.autosuggest.utils.HashTaggedTokenList;
import com.mapinfo.mapmarker.autosuggest.utils.StringNormalizer;
import com.mapinfo.mapmarker.autosuggest.utils.substitution.StringPermutation;
import com.mapinfo.mapmarker.autosuggest.utils.substitution.SubstitutionMap;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class SubstitutionSet {
    SubstitutionMap preTypeMap = new SubstitutionMap();
    SubstitutionMap postTypeMap = new SubstitutionMap();
    SubstitutionMap attachedTypeMap = new SubstitutionMap();
    SubstitutionMap directionalMap = new SubstitutionMap();
    SubstitutionMap numberMap = new SubstitutionMap();
    SubstitutionMap ordinalMap = new SubstitutionMap();
    SubstitutionMap abbrevMap = new SubstitutionMap();
    SubstitutionMap prefixMap = new SubstitutionMap();
    SubstitutionMap suffixMap = new SubstitutionMap();
    SubstitutionMap geoMap = new SubstitutionMap();
    SubstitutionHashSet commonWords = new SubstitutionHashSet();
    SubstitutionHashSet secondaryCommonWords = new SubstitutionHashSet();
    private LengthOnlySorter m_lengthSorter = new LengthOnlySorter();
    HashMap<Integer, SubstitutionMap> maps = new HashMap(8);

    public SubstitutionSet() {
        this.maps.put(1, this.preTypeMap);
        this.maps.put(2, this.postTypeMap);
        this.maps.put(4, this.attachedTypeMap);
        this.maps.put(8, this.directionalMap);
        this.maps.put(16, this.numberMap);
        this.maps.put(2048, this.ordinalMap);
        this.maps.put(64, this.abbrevMap);
        this.maps.put(256, this.prefixMap);
        this.maps.put(1024, this.geoMap);
        this.maps.put(4096, this.suffixMap);
    }

    public boolean isEmpty() {
        return this.commonWords.isEmpty() && this.secondaryCommonWords.isEmpty() && this.prefixMap.map.isEmpty() && this.suffixMap.map.isEmpty() && this.geoMap.map.isEmpty() && this.abbrevMap.map.isEmpty() && this.ordinalMap.map.isEmpty() && this.numberMap.map.isEmpty() && this.directionalMap.map.isEmpty() && this.attachedTypeMap.map.isEmpty() && this.preTypeMap.map.isEmpty() && this.postTypeMap.map.isEmpty();
    }

    public Set<String> getPossibleSubstitutions(String input, int tagsToUse) {
        return this.getPossibleSubstitutions(input, tagsToUse, 0);
    }

    public Set<String> getPossibleSubstitutions(String input, int tagsToUse, int tagsToRemove) {
        if (StringUtilities.isEmpty((String)input)) {
            return Collections.emptySet();
        }
        HashTaggedTokenList taggedTokenList = this.tagString(input, tagsToUse);
        ArrayList<Set<String>> substitutions = new ArrayList<Set<String>>(taggedTokenList.size());
        for (int i = 0; i < taggedTokenList.size(); ++i) {
            HashTaggedToken token = taggedTokenList.get(i);
            HashSet<String> subsForToken = new HashSet<String>();
            subsForToken.add(token.getValue());
            int tokenTag = token.getTag();
            if (tokenTag == 0) {
                substitutions.add(subsForToken);
                continue;
            }
            if ((tokenTag & 0x20) != 0 && (tagsToUse & 0x20) != 0 || (tokenTag & 0x200) != 0 && (tagsToUse & 0x200) != 0) {
                subsForToken.add("");
            }
            if ((tokenTag & tagsToRemove) != 0) {
                subsForToken.add("");
            }
            for (Integer mapTag : this.maps.keySet()) {
                Set<String> foundValues;
                boolean bFoundSignificantToken;
                if ((mapTag & tagsToUse) == 0 || (mapTag & tokenTag) == 0) continue;
                if (mapTag == 2 || mapTag == 4096) {
                    if (i == 0) continue;
                    bFoundSignificantToken = false;
                    for (int preceding = 0; preceding < i; ++preceding) {
                        if (taggedTokenList.getTag(preceding) == 32) continue;
                        bFoundSignificantToken = true;
                        break;
                    }
                    if (!bFoundSignificantToken) continue;
                    if (mapTag == 4096) {
                        subsForToken.add("");
                    }
                }
                if (mapTag == 1 || mapTag == 256) {
                    if (i == taggedTokenList.size() - 1) continue;
                    bFoundSignificantToken = false;
                    for (int remaining = i + 1; remaining < taggedTokenList.size(); ++remaining) {
                        if (taggedTokenList.getTag(remaining) == 32) continue;
                        bFoundSignificantToken = true;
                        break;
                    }
                    if (!bFoundSignificantToken) continue;
                    if (mapTag == 256) {
                        subsForToken.add("");
                    }
                }
                if ((foundValues = this.maps.get(mapTag).getValues(token.getValue())).isEmpty()) continue;
                subsForToken.addAll(foundValues);
            }
            substitutions.add(subsForToken);
        }
        Set<String> permutations = StringPermutation.getPermutations(substitutions);
        permutations.remove(input);
        return permutations;
    }

    public Set<String> getSubstitutionsForToken(String inputToken, int setsToUse) {
        if (StringUtilities.isEmpty((String)inputToken)) {
            return Collections.emptySet();
        }
        HashSet<String> substitutions = new HashSet<String>();
        substitutions.add(inputToken);
        for (Integer mapTag : this.maps.keySet()) {
            if ((mapTag & setsToUse) == 0) continue;
            Set<String> foundValues = this.maps.get(mapTag).getValues(inputToken, false);
            if (mapTag == 4) {
                foundValues = this.getAttachedTypeAlternates(inputToken);
            }
            if (foundValues.isEmpty()) continue;
            substitutions.addAll(foundValues);
        }
        return substitutions;
    }

    protected Set<String> getAttachedTypeAlternates(String inputToken) {
        HashSet<String> foundValues = new HashSet<String>();
        String base = null;
        for (String key : this.attachedTypeMap.keySet()) {
            Set<String> possibleEndings = this.attachedTypeMap.getValues(key, true);
            for (String possibleEnding : possibleEndings) {
                if (inputToken.length() <= possibleEnding.length() || !inputToken.endsWith(possibleEnding)) continue;
                base = inputToken.substring(0, inputToken.length() - possibleEnding.length());
                break;
            }
            if (base == null) continue;
            StringBuilder stringBuilder = new StringBuilder(base);
            for (String possibleEnding : possibleEndings) {
                stringBuilder.append(possibleEnding);
                foundValues.add(stringBuilder.toString());
                stringBuilder.setLength(base.length());
            }
            return foundValues;
        }
        return foundValues;
    }

    public String getShortestSubstitutionForToken(String inputToken, int setsToUse) {
        Set<String> subs = this.getSubstitutionsForToken(inputToken, setsToUse);
        if (subs == null || subs.isEmpty()) {
            return null;
        }
        if (subs.size() == 1) {
            return subs.iterator().next();
        }
        ArrayList<String> sorted = new ArrayList<String>(subs);
        Collections.sort(sorted, this.m_lengthSorter);
        return sorted.get(0);
    }

    public String substituteShortestForFinishedTokens(String input, int setsToUse) {
        if (StringUtilities.isEmpty((String)input)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(input.length());
        StringTokenizer st = new StringTokenizer(input);
        int subCount = st.countTokens() - 1;
        for (int i = 0; i < subCount; ++i) {
            sb.append(this.getShortestSubstitutionForToken(st.nextToken(), setsToUse));
            sb.append(' ');
        }
        sb.append(st.nextToken());
        return sb.toString();
    }

    public Set<String> removeSubstitutions(String input, int tagsToRemove) {
        if (StringUtilities.isEmpty((String)input)) {
            return Collections.emptySet();
        }
        HashTaggedTokenList taggedTokenList = this.tagString(input, tagsToRemove);
        ArrayList<Set<String>> substitutions = new ArrayList<Set<String>>(taggedTokenList.size());
        for (int i = 0; i < taggedTokenList.size(); ++i) {
            HashTaggedToken token = taggedTokenList.get(i);
            HashSet<String> subsForToken = new HashSet<String>();
            subsForToken.add(token.getValue());
            int tokenTag = token.getTag();
            if (tokenTag == 0) {
                substitutions.add(subsForToken);
                continue;
            }
            subsForToken.add("");
            substitutions.add(subsForToken);
        }
        Set<String> permutations = StringPermutation.getPermutations(substitutions);
        permutations.remove(input);
        return permutations;
    }

    protected HashTaggedTokenList tagString(String input, int tagsToUse) {
        HashTaggedTokenList taggedTokens = new HashTaggedTokenList(new StringTokenizer(input));
        for (int i = 0; i < taggedTokens.size(); ++i) {
            this.tagToken(taggedTokens.get(i), tagsToUse);
        }
        return taggedTokens;
    }

    protected void tagToken(HashTaggedToken token, int tagsToUse) {
        String value = token.getValue();
        if (StringUtilities.isNumeric((String)value)) {
            if ((tagsToUse & 0x80) > 0) {
                token.setTag(128);
            }
            if ((tagsToUse & 0x10) > 0 && this.numberMap.contains(value)) {
                token.setTag(16);
            }
            return;
        }
        for (int tag : this.maps.keySet()) {
            if ((tag & tagsToUse) == 0 || !this.maps.get(tag).contains(value)) continue;
            token.setTag(tag);
        }
        if ((tagsToUse & 0x20) != 0 && this.commonWords.contains(value)) {
            token.setTag(32);
        }
        if ((tagsToUse & 0x200) != 0 && this.secondaryCommonWords.contains(value)) {
            token.setTag(512);
        }
    }

    public void write(DataOutput out) throws IOException {
        this.abbrevMap.write(out);
        this.attachedTypeMap.write(out);
        this.directionalMap.write(out);
        this.geoMap.write(out);
        this.numberMap.write(out);
        this.ordinalMap.write(out);
        this.postTypeMap.write(out);
        this.prefixMap.write(out);
        this.preTypeMap.write(out);
        this.suffixMap.write(out);
        this.commonWords.write(out);
        this.secondaryCommonWords.write(out);
    }

    public void read(DataInput in) throws IOException {
        this.abbrevMap.read(in);
        this.attachedTypeMap.read(in);
        this.directionalMap.read(in);
        this.geoMap.read(in);
        this.numberMap.read(in);
        this.ordinalMap.read(in);
        this.postTypeMap.read(in);
        this.prefixMap.read(in);
        this.preTypeMap.read(in);
        this.suffixMap.read(in);
        this.commonWords.read(in);
        this.secondaryCommonWords.read(in);
    }

    class LengthOnlySorter
    implements Comparator<String> {
        LengthOnlySorter() {
        }

        @Override
        public int compare(String s1, String s2) {
            int len2;
            int len1 = s1.length();
            if (len1 == (len2 = s2.length())) {
                return 0;
            }
            if (len1 > len2) {
                return 1;
            }
            return -1;
        }
    }

    class SubstitutionHashSet
    extends HashSet<String> {
        SubstitutionHashSet() {
        }

        @Override
        public boolean add(String newValue) {
            if (newValue == null) {
                return false;
            }
            String normalized = StringNormalizer.normalise(newValue);
            if (normalized == null) {
                normalized = "";
            }
            return super.add(normalized);
        }

        public void write(DataOutput dataStream) throws IOException {
            dataStream.writeInt(this.size());
            Iterator it = this.iterator();
            while (it.hasNext()) {
                dataStream.writeUTF((String)it.next());
            }
        }

        public void read(DataInput dataStream) throws IOException {
            this.clear();
            int size = dataStream.readInt();
            for (int i = 0; i < size; ++i) {
                String value = dataStream.readUTF();
                this.add(value);
            }
        }
    }
}

