/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.AddressSearchHandler;
import com.mapinfo.mapmarker.autosuggest.AddressSearchPreferences;
import com.mapinfo.mapmarker.autosuggest.AddressSearchResult;
import com.mapinfo.mapmarker.autosuggest.AutoSuggestHandler;
import com.mapinfo.mapmarker.autosuggest.IAddressSearchResult;
import com.mapinfo.mapmarker.autosuggest.InputAddress;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.api.BoundingBox;
import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.exception.SuggestFailureException;
import com.mapinfo.mapmarker.autosuggest.utils.LongLatBox;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.autosuggest.wrapper.AdditionalFieldInfo;
import com.mapinfo.mapmarker.autosuggest.wrapper.CurrentSearchInfo;
import com.mapinfo.mapmarker.autosuggest.wrapper.IWrappedSearchResult;
import com.mapinfo.mapmarker.autosuggest.wrapper.WrappedSearchResult;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressSearchWrapper {
    private static final Logger LOG = LoggerFactory.getLogger((String)AddressSearchWrapper.class.getName());
    private AddressSearchHandler handler;
    private AdditionalFieldInfo additionalFieldInfo = null;

    public AddressSearchWrapper(AutoSuggestHandler autosuggestHandler) {
        this.handler = new AddressSearchHandler(autosuggestHandler);
        this.additionalFieldInfo = new AdditionalFieldInfo(this.handler.getAddressMetaData());
    }

    AddressSearchWrapper(AddressSearchHandler handler) {
        this.handler = handler;
        this.additionalFieldInfo = new AdditionalFieldInfo(this.handler.getAddressMetaData());
    }

    protected IWrappedSearchResult searchAddress(Address address, IAutoSuggestConstraints constraints) throws SuggestFailureException {
        AddressSearchPreferences searchPrefs;
        IAddressSearchResult result;
        WrappedSearchResult wrappedResult;
        if (address == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("searchAddress('" + address.getMainAddress() + "')");
        }
        DirectPosition origin = constraints.getOriginPointWGS84();
        BoundingBox boundingBox = constraints.getBoundingBoxWGS84();
        if (origin != null && origin.getX() == 0.0 && origin.getY() == 0.0) {
            origin = null;
        }
        LongLatBox bounds = null;
        if (boundingBox != null && !boundingBox.isPoint()) {
            bounds = new Rectangle(boundingBox.getWesternLimit(), boundingBox.getSouthernLimit(), boundingBox.getEasternLimit(), boundingBox.getNorthernLimit());
        }
        double[] location = null;
        if (origin != null && (bounds == null || bounds.pointInRect(origin.getX(), origin.getY()))) {
            location = new double[]{origin.getX(), origin.getY()};
        }
        if ((wrappedResult = new WrappedSearchResult(result = this.search(address, (Rectangle)bounds, location, searchPrefs = this.constructSearchPrefs(constraints)), constraints)).getCandidateCount() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("searchAddress('" + address.getMainAddress() + "'): found matches with standard version of input");
            }
            return wrappedResult;
        }
        result = this.searchWithShorterString(address, (Rectangle)bounds, location, searchPrefs);
        wrappedResult = new WrappedSearchResult(result, constraints);
        if (wrappedResult.getCandidateCount() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("searchAddress('" + address.getMainAddress() + "'): found matches with shortened version of input");
            }
            return wrappedResult;
        }
        return wrappedResult;
    }

    private IAddressSearchResult search(Address address, Rectangle bounds, double[] location, AddressSearchPreferences addrSearchPrefs) throws SuggestFailureException {
        InputAddress inAddr = this.convertAddress(address);
        return this.handler.searchAddress(inAddr, bounds, location, addrSearchPrefs);
    }

    private IAddressSearchResult searchWithShorterString(Address address, Rectangle bounds, double[] location, AddressSearchPreferences addrSearchPrefs) throws SuggestFailureException {
        addrSearchPrefs.setUseShortenedSearchString(true);
        return this.search(address, bounds, location, addrSearchPrefs);
    }

    InputAddress convertAddress(Address address) {
        InputAddress inAddr = new InputAddress();
        inAddr.setMainSearchString(address.getMainAddress());
        inAddr.setCategory(address.getGenericField3());
        inAddr.setCity(address.getAreaName3());
        inAddr.setPostCode(address.getPostCode1());
        inAddr.setStateProvince(address.getAreaName1());
        inAddr.setCountry(address.getCountry());
        return inAddr;
    }

    protected int searchMoreAddresses(Address address, IAutoSuggestConstraints constraints, CurrentSearchInfo info) {
        WrappedSearchResult wrappedResult = (WrappedSearchResult)info.getResult();
        if (wrappedResult != null) {
            AddressSearchResult asr = (AddressSearchResult)wrappedResult.getAddressSearchResult();
            Iterator<SimpleAddress> it = null;
            if (asr != null) {
                it = asr.getStoredIterator();
                wrappedResult.extendCandidateList(it);
            }
            return wrappedResult.getCandidateCount();
        }
        return constraints.getMaxCandidates();
    }

    private AddressSearchPreferences constructSearchPrefs(IAutoSuggestConstraints constraints) {
        AddressSearchPreferences prefs = new AddressSearchPreferences();
        HashSet<Integer> fields = new HashSet<Integer>();
        int searchType = constraints.getSearchType();
        if ((searchType & 1) == 1) {
            fields.add(7);
            fields.add(this.additionalFieldInfo.getBrandNameID());
        }
        if ((searchType & 2) == 2) {
            fields.add(this.additionalFieldInfo.getCategoryID());
            fields.add(this.additionalFieldInfo.getSubCategoryID());
        }
        if ((searchType & 0x20) == 32) {
            fields.add(16);
            fields.add(17);
            fields.add(18);
            fields.add(19);
            fields.addAll(this.additionalFieldInfo.getAdditionalFieldsForLevel(FieldType.FieldLevel.LEVEL_POSTAL.getLevelAsInt()));
        }
        if ((searchType & 4) == 4) {
            fields.add(15);
        }
        if ((searchType & 8) == 8) {
            fields.add(18);
            fields.add(19);
        }
        if ((searchType & 0x40) == 64) {
            fields.add(16);
        }
        if ((searchType & 0x10) == 16) {
            fields.add(8);
            fields.addAll(this.additionalFieldInfo.getAdditionalFieldsForLevel(FieldType.FieldLevel.LEVEL_STREET.getLevelAsInt()));
        }
        if ((searchType & 0x7C) == 124) {
            Map<String, FieldType> additionalSeachfieldNameMap = this.handler.getAddressMetaData().getAdditionalFields();
            if (additionalSeachfieldNameMap != null) {
                for (Map.Entry<String, FieldType> en : additionalSeachfieldNameMap.entrySet()) {
                    fields.add(en.getValue().getKey());
                }
            }
            fields.add(7);
            fields.add(3);
        }
        prefs.setSearchableFields(new ArrayList<Integer>(fields));
        prefs.setFuzzyMatchMode(constraints.getFuzzyMatchMode());
        prefs.setMustMatchAddressNumber(constraints.isMustMatchAddressNumber());
        prefs.setCompressAreaNames(constraints.isCompressAreaResults());
        return prefs;
    }

    public AdditionalFieldInfo getAdditionalFieldInfo() {
        return this.additionalFieldInfo;
    }

    public List<SimpleAddress> doPointDistanceSearch(DirectPosition origin, double radius, int maxCandidates) throws SuggestFailureException {
        return this.handler.doPointDistanceSearch(origin, radius, maxCandidates);
    }
}

