/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidate;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CandidateCompare
implements Comparator<ISuggestedCandidate> {
    private static final Logger LOG = LoggerFactory.getLogger((String)CandidateCompare.class.getName());
    private String activeRule = "none";

    @Override
    public final int compare(ISuggestedCandidate c1, ISuggestedCandidate c2) {
        int result = this.compareThem((SuggestedCandidate)c1, (SuggestedCandidate)c2);
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Comparing:\n");
            sb.append(c1);
            sb.append("to:\n");
            sb.append(c2);
            sb.append("Operative sort rule: ").append(this.activeRule).append("\n");
            sb.append("*** Comparison result: ").append(result).append("\n");
            LOG.debug(sb.toString());
        }
        return result;
    }

    private int compareThem(SuggestedCandidate c1, SuggestedCandidate c2) {
        int c2DictPriority;
        int c2NumFieldsMatched;
        boolean c2Exact;
        boolean c2MatchesInput;
        boolean c2isCandPerfectMatchOnSingleField;
        int c2MatchScore;
        this.activeRule = "banded distance score";
        int result = CandidateCompare.preferGreater(c1.getDistanceScore(), c2.getDistanceScore());
        if (result != 0) {
            return result;
        }
        this.activeRule = "match score (fuzzy)";
        int c1MatchScore = c1.address.getMatchScore();
        if (c1MatchScore != (c2MatchScore = c2.address.getMatchScore())) {
            return c2MatchScore - c1MatchScore;
        }
        this.activeRule = "perfectRangeUnitMatch flag";
        boolean c1isCandPerfectMatchOnSingleField = c1.isCandPerfectMatchOnSingleField();
        if (c1isCandPerfectMatchOnSingleField != (c2isCandPerfectMatchOnSingleField = c2.isCandPerfectMatchOnSingleField())) {
            return c1isCandPerfectMatchOnSingleField ? -1 : 1;
        }
        this.activeRule = "matchesInput flag";
        boolean c1MatchesInput = c1.getMatchesInput();
        if (c1MatchesInput != (c2MatchesInput = c2.getMatchesInput())) {
            return c1MatchesInput ? -1 : 1;
        }
        this.activeRule = "exact match areaName3";
        boolean c1Exact = c1.isExactAreaName3Match();
        if (c1Exact != (c2Exact = c2.isExactAreaName3Match())) {
            return c1Exact ? -1 : 1;
        }
        if (c1.getRankValue() != 1 && c2.getRankValue() != 1) {
            boolean c2ExactNonNormalized;
            this.activeRule = "exact match areaName3 non-normalized";
            boolean c1ExactNonNormalized = c1.hasExactMatchAreaName3NonNormalized();
            if (c1ExactNonNormalized != (c2ExactNonNormalized = c2.hasExactMatchAreaName3NonNormalized())) {
                return c1ExactNonNormalized ? -1 : 1;
            }
        }
        this.activeRule = "num fields matched";
        int c1NumFieldsMatched = c1.address.getNumFieldsMatched();
        if (c1NumFieldsMatched != (c2NumFieldsMatched = c2.address.getNumFieldsMatched())) {
            return c2NumFieldsMatched - c1NumFieldsMatched;
        }
        this.activeRule = "dictionary priority";
        int c1DictPriority = c1.getDictionaryPriority();
        if (c1DictPriority != (c2DictPriority = c2.getDictionaryPriority())) {
            return c1DictPriority - c2DictPriority;
        }
        this.activeRule = "street/street over poi/street";
        int c1Type = c1.getType();
        int c2Type = c2.getType();
        boolean c1MatchedStreet = c1.address.matchedOnField(8);
        boolean c2MatchedStreet = c2.address.matchedOnField(8);
        if (c1MatchedStreet && c2MatchedStreet && c1Type != c2Type) {
            return c2Type - c1Type;
        }
        this.activeRule = "POI over street";
        if (c1Type != c2Type) {
            return c1Type - c2Type;
        }
        this.activeRule = "placeName + streetName score";
        if (c1.getStreetNameScore() > 0.0 && c2.getStreetNameScore() > 0.0 && (result = CandidateCompare.preferGreater(c1.getPlaceNameScore() + c1.getStreetNameScore(), c2.getPlaceNameScore() + c2.getStreetNameScore())) != 0) {
            return result;
        }
        this.activeRule = "null formatted street";
        String c1FmtStreet = c1.getFormattedStreetAddress();
        String c2FmtStreet = c2.getFormattedStreetAddress();
        if (c1FmtStreet != null && c2FmtStreet == null) {
            return -1;
        }
        if (c1FmtStreet == null && c2FmtStreet != null) {
            return 1;
        }
        if (c1FmtStreet != null && c2FmtStreet != null) {
            int c2NumMatched;
            this.activeRule = "num street chars matched";
            int c1NumMatched = c1.getNumStreetCharsMatched();
            if (c1NumMatched != (c2NumMatched = c2.getNumStreetCharsMatched())) {
                return c2NumMatched - c1NumMatched;
            }
        }
        this.activeRule = "poiLenCheck";
        int poiLenCheck = this.checkPOIField(c1, c2);
        if (poiLenCheck != 0) {
            return poiLenCheck;
        }
        this.activeRule = "post code score";
        result = CandidateCompare.preferGreater(c1.getPostCodeScore(), c2.getPostCodeScore());
        if (result != 0) {
            return result;
        }
        this.activeRule = "actual distance";
        result = Double.compare(c1.getDistance(), c2.getDistance());
        if (result != 0) {
            return result;
        }
        this.activeRule = "exact place name score";
        result = CandidateCompare.preferGreater(c1.getExactPlaceNameScore(), c2.getExactPlaceNameScore());
        if (result != 0) {
            return result;
        }
        this.activeRule = "exact area name 3 score";
        result = CandidateCompare.preferGreater(c1.getExactAreaName3Score(), c2.getExactAreaName3Score());
        if (result != 0) {
            return result;
        }
        this.activeRule = "street + place score";
        result = CandidateCompare.preferGreater(c1.getMatchesStreetScore() + c1.getMatchesPlaceScore(), c2.getMatchesStreetScore() + c2.getMatchesPlaceScore());
        if (result != 0) {
            return result;
        }
        this.activeRule = "composite area name score";
        result = CandidateCompare.preferGreater(c1.getAreaName1Score() + c1.getAreaName2Score() + c1.getAreaName3Score() + c1.getAreaName4Score(), c2.getAreaName1Score() + c2.getAreaName2Score() + c2.getAreaName3Score() + c2.getAreaName4Score());
        if (result != 0) {
            return result;
        }
        this.activeRule = "rank";
        result = this.compareRanking(c1, c2);
        if (result != 0) {
            return result;
        }
        this.activeRule = "range score";
        result = CandidateCompare.preferGreater(c1.getRangeScore(), c2.getRangeScore());
        if (result != 0) {
            return result;
        }
        this.activeRule = "ratio matched score";
        result = CandidateCompare.preferGreater(c1.getRatioMatchedScore(), c2.getRatioMatchedScore());
        if (result != 0) {
            return result;
        }
        this.activeRule = "end of rules";
        return 0;
    }

    private int compareRanking(SuggestedCandidate c1, SuggestedCandidate c2) {
        return Integer.compare(c1.getRankValue(), c2.getRankValue());
    }

    private static int preferGreater(double c1Score, double c2Score) {
        return Double.compare(c2Score, c1Score);
    }

    private int checkPOIField(SuggestedCandidate cand1, SuggestedCandidate cand2) {
        int c1Type = cand1.getType();
        int c2Type = cand2.getType();
        if ((c1Type & 3) != 0 && (c2Type & 3) != 0) {
            int c1matchLen = cand1.getNumCharsMatchedForField(7);
            int c2matchLen = cand2.getNumCharsMatchedForField(7);
            if (c1matchLen > 0 && c2matchLen > 0) {
                if (c1matchLen > c2matchLen) {
                    String matched2 = cand2.getName();
                    if (matched2.length() > c2matchLen) {
                        matched2 = matched2.substring(0, c2matchLen);
                    }
                    if (cand1.getName().startsWith(matched2)) {
                        return -1;
                    }
                }
                if (c2matchLen > c1matchLen) {
                    String matched1 = cand1.getName();
                    if (matched1.length() > c1matchLen) {
                        matched1 = matched1.substring(0, c1matchLen);
                    }
                    if (cand2.getName().startsWith(matched1)) {
                        return 1;
                    }
                }
            }
        }
        return 0;
    }
}

