/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.google.common.collect.Maps;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.TokenStandardiser;
import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidateRange;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedRangeUnit;
import com.mapinfo.mapmarker.autosuggest.wrapper.AdditionalFieldInfo;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidateRangeUnit;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class ExtendedSuggestedCandidate
extends SuggestedCandidate {
    public ExtendedSuggestedCandidate(Address input, SimpleAddress address, IAutoSuggestConstraints constraints, int type) {
        super(input, address, constraints, type);
    }

    public ExtendedSuggestedCandidate(Address input, SimpleAddress address, IAutoSuggestConstraints constraints, int type, String countryCode, AdditionalFieldInfo additionalFieldInfo, String dictName, int dictPriority, boolean isCustomData, TokenStandardiser standardiser) {
        super(input, address, constraints, type, countryCode, additionalFieldInfo, dictName, dictPriority, isCustomData, standardiser);
    }

    protected void rollupRangeUnitInfo() {
        int rangeCount = this.getRangeCount();
        if (rangeCount == 0) {
            return;
        }
        if (rangeCount == 1) {
            ISuggestedCandidateRange range = this.getSuggestedRange(0);
            int unitCount = range.getUnitCount();
            FieldType.FieldLevel fieldLevel = this.address.getLowestMatchedFieldInAddrHierarchy();
            HashMap emptyMap = Maps.newHashMap();
            if (unitCount < 2) {
                if (fieldLevel == FieldType.FieldLevel.LEVEL_UNIT || fieldLevel == FieldType.FieldLevel.LEVEL_RANGE) {
                    this.rollOverRangeAndUnits(range, emptyMap, fieldLevel);
                }
            } else if (unitCount > 1 && fieldLevel == FieldType.FieldLevel.LEVEL_RANGE) {
                this.rollOverSingleMatchingRangesOnly(range, emptyMap);
            }
        }
    }

    private void rollOverSingleMatchingRangesOnly(ISuggestedCandidateRange range, Map<String, String> emptyMap) {
        StringBuilder builder = new StringBuilder();
        emptyMap.clear();
        emptyMap.putAll(this.getRangeAdditionalFields(range));
        if (!StringUtilities.isEmpty((String)this.getRangeString(range))) {
            builder.append(this.getRangeString(range));
        }
        this.rollOverCandidateAdditionalFields(emptyMap, builder, ", ");
    }

    private void rollOverRangeAndUnits(ISuggestedCandidateRange range, Map<String, String> emptyMap, FieldType.FieldLevel fieldLevel) {
        StringBuilder builder = new StringBuilder();
        emptyMap.putAll(this.getRangeAdditionalFields(range));
        SuggestedCandidateRangeUnit unit = (SuggestedCandidateRangeUnit)range.getUnitAt(0);
        boolean isEmptyUnitString = StringUtilities.isEmpty((String)this.getUnitString(unit));
        boolean isEmptyRangeString = StringUtilities.isEmpty((String)this.getRangeString(range));
        if (fieldLevel == FieldType.FieldLevel.LEVEL_UNIT || isEmptyUnitString) {
            emptyMap.putAll(this.getUnitAdditionalFields(unit));
            if (!isEmptyUnitString) {
                builder.append(this.getUnitString(unit));
            }
        }
        if (!isEmptyRangeString) {
            if (!StringUtilities.isEmpty((String)builder.toString())) {
                builder.append(", ");
            }
            builder.append(this.getRangeString(range));
        }
        this.rollOverCandidateAdditionalFields(emptyMap, builder, ", ");
        if (fieldLevel == FieldType.FieldLevel.LEVEL_UNIT || fieldLevel == FieldType.FieldLevel.LEVEL_RANGE && isEmptyUnitString) {
            this.getSuggestedRangeList().clear();
        }
    }

    private void rollOverCandidateAdditionalFields(Map<String, String> emptyMap, StringBuilder builder, String seperator) {
        String appendedPlaceName;
        String placeName = this.getAdditionalFieldValue(FieldType.PLACE_NAME_FIELD_TYPE.toString());
        if (!StringUtilities.isEmpty((String)placeName)) {
            builder.append(seperator).append(placeName);
        }
        if (!StringUtilities.isEmpty((String)(appendedPlaceName = builder.toString().trim()))) {
            this.address.addField(7, appendedPlaceName);
        }
        if (emptyMap != null && emptyMap.containsKey("FORMATTED_STRING")) {
            emptyMap.remove("FORMATTED_STRING");
        }
        this.getAdditionalFields().putAll(emptyMap);
    }

    private String getRangeString(ISuggestedCandidateRange range) {
        String rangeString = range != null ? range.getAdditionalFields().get(FieldType.RANGE_PLACE_NAME_FIELD_TYPE.getName()) : "";
        return StringUtilities.isEmpty((String)rangeString) ? "" : rangeString;
    }

    private Map<String, String> getRangeAdditionalFields(ISuggestedCandidateRange range) {
        return range != null ? range.getAdditionalFields() : Maps.newHashMap();
    }

    private Map<String, String> getUnitAdditionalFields(SuggestedCandidateRangeUnit unit) {
        return unit != null ? unit.getAdditionalFields() : Maps.newHashMap();
    }

    private String getUnitString(SuggestedCandidateRangeUnit unit) {
        String unitString = unit != null ? unit.getUnitString() : "";
        return StringUtilities.isEmpty((String)unitString) ? "" : unitString;
    }

    protected void trimRangesUnits(IAutoSuggestConstraints constraints) {
        if (constraints.getMaxRanges() == -1 && constraints.getMaxRangeUnits() == -1) {
            return;
        }
        int rangeCount = this.getRangeCount();
        if (rangeCount == 0) {
            return;
        }
        List<ISuggestedCandidateRange> rangeList = this.getSuggestedRangeList();
        if (rangeCount > constraints.getMaxRanges() && constraints.getMaxRanges() >= 0) {
            this.getSuggestedRangeList().retainAll(rangeList.subList(0, constraints.getMaxRanges()));
        }
        if (rangeList != null && !rangeList.isEmpty()) {
            for (ISuggestedCandidateRange iSuggestedCandidateRange : rangeList) {
                int unitCount = iSuggestedCandidateRange.getUnitCount();
                if (unitCount == 0 || constraints.getMaxRangeUnits() < 0 || unitCount <= constraints.getMaxRangeUnits()) continue;
                iSuggestedCandidateRange.getRangeUnits().retainAll(iSuggestedCandidateRange.getRangeUnits().subList(0, constraints.getMaxRangeUnits()));
            }
        }
    }

    protected boolean isEmptyUnitsRemoved() {
        boolean isEmptyUnitRemoved = false;
        List<ISuggestedCandidateRange> rangeList = this.getSuggestedRangeList();
        if (rangeList != null && !rangeList.isEmpty()) {
            for (ISuggestedCandidateRange iSuggestedCandidateRange : rangeList) {
                List<ISuggestedRangeUnit> unitsList = iSuggestedCandidateRange.getRangeUnits();
                if (unitsList == null || unitsList.isEmpty()) continue;
                Iterator<ISuggestedRangeUnit> unitIterator = unitsList.iterator();
                while (unitIterator.hasNext()) {
                    SuggestedCandidateRangeUnit unit = (SuggestedCandidateRangeUnit)unitIterator.next();
                    if (!StringUtilities.isEmpty((String)unit.getUnitString())) continue;
                    iSuggestedCandidateRange.getAdditionalFields().putAll(this.getUnitAdditionalFields(unit));
                    unitIterator.remove();
                    isEmptyUnitRemoved = true;
                }
            }
        }
        return isEmptyUnitRemoved;
    }
}

