/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.FieldMatchInfo;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.utils.StringNormalizer;
import com.mapinfo.mapmarker.autosuggest.wrapper.ICandidateScoreRule;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidate;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ScoreRulePreferExactPlaceName
implements ICandidateScoreRule {
    @Override
    public void apply(ISuggestedCandidate candidate) {
        SimpleAddress address = ((SuggestedCandidate)candidate).address;
        List<String> placeNameList = address.getField(7);
        FieldMatchInfo info = address.getFieldMatchInfo(7);
        if (placeNameList == null || info == null || info.getMatchedValueNdx() < 0) {
            placeNameList = address.getField(24);
            info = address.getFieldMatchInfo(24);
            if (placeNameList == null || info == null || info.getMatchedValueNdx() < 0) {
                return;
            }
        }
        List<String> inputList = candidate.getInput();
        StringTokenizer placeNameTokens = null;
        double placeNameScore = 0.0;
        for (String place : placeNameList) {
            String inputToken;
            String placeToken;
            String normal;
            int i;
            placeNameTokens = new StringTokenizer(place);
            if (placeNameTokens.countTokens() != inputList.size()) continue;
            ArrayList<String> l = new ArrayList<String>(inputList.size());
            for (i = 0; i < inputList.size(); ++i) {
                normal = StringNormalizer.normalise(inputList.get(i));
                l.add(normal);
            }
            inputList = l;
            i = 0;
            while (placeNameTokens.hasMoreTokens()) {
                placeToken = StringNormalizer.normalise(placeNameTokens.nextToken());
                if (placeToken.equalsIgnoreCase(inputToken = inputList.get(i))) {
                    placeNameScore += 0.1;
                }
                ++i;
            }
            l = new ArrayList(inputList.size());
            for (i = 0; i < inputList.size(); ++i) {
                normal = StringNormalizer.normalise(inputList.get(i));
                l.add(normal);
            }
            inputList = l;
            i = 0;
            while (placeNameTokens.hasMoreTokens()) {
                placeToken = StringNormalizer.normalise(placeNameTokens.nextToken());
                if (placeToken.equalsIgnoreCase(inputToken = inputList.get(i))) {
                    placeNameScore += 0.1;
                }
                ++i;
            }
        }
        ((SuggestedCandidate)candidate).setExactPlaceNameScore(placeNameScore);
    }
}

