/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.TokenStandardiser;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidateRange;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedRangeUnit;
import com.mapinfo.mapmarker.autosuggest.utils.StringNormalizer;
import com.mapinfo.mapmarker.autosuggest.wrapper.ICandidateScoreRule;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidateRange;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidateRangeComparator;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidateRangeUnit;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidateRangeUnitComparator;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ScoreRuleRangeUnitFields
implements ICandidateScoreRule {
    private TokenStandardiser standardiser = null;

    @Override
    public void apply(ISuggestedCandidate candidate) {
        SuggestedCandidate c = (SuggestedCandidate)candidate;
        this.standardiser = c.getTokenStandardiser();
        List<ISuggestedCandidateRange> rangeList = candidate.getSuggestedRangeList();
        if (rangeList != null && !rangeList.isEmpty()) {
            for (ISuggestedCandidateRange simpleRange : rangeList) {
                this.scoreUnit(simpleRange);
                Collections.sort(simpleRange.getRangeUnits(), new SuggestedCandidateRangeUnitComparator());
                this.scoreRange(simpleRange);
            }
            Collections.sort(rangeList, new SuggestedCandidateRangeComparator());
            double rangeScore = rangeList != null ? ((SuggestedCandidateRange)rangeList.get(0)).getScore() : 0.0;
            ((SuggestedCandidate)candidate).setRangeScore(rangeScore);
            if (rangeScore == 0.0) {
                for (ISuggestedCandidateRange simpleRange : rangeList) {
                    if (((SuggestedCandidateRange)simpleRange).isMatchedCandiateRange()) continue;
                    int unitsCount = simpleRange.getUnitCount();
                    if (unitsCount > 0) {
                        boolean isUnitMatched = ((SuggestedCandidateRangeUnit)simpleRange.getUnitAt(0)).isMatchedRangeUnit();
                        if (!isUnitMatched) {
                            for (int i = 0; i < unitsCount; ++i) {
                                if (((SuggestedCandidateRangeUnit)simpleRange.getUnitAt(i)).getScore() != 0.0) continue;
                                ((SuggestedCandidateRangeUnit)simpleRange.getUnitAt(i)).setMatchedRangeUnit(true);
                            }
                        }
                        ((SuggestedCandidateRange)simpleRange).setMatchedCandiateRange(true);
                        continue;
                    }
                    ((SuggestedCandidateRange)simpleRange).setMatchedCandiateRange(true);
                }
            }
            this.standardiser = null;
        }
    }

    private void scoreRange(ISuggestedCandidateRange simpleRange) {
        Set<String> rangeKeySet = simpleRange.getAdditionalFields().keySet();
        double rangeScore = 0.0;
        for (String rangeSringKey : rangeKeySet) {
            String matchingRangeString = ((SuggestedCandidateRange)simpleRange).getMatchingString(rangeSringKey);
            String rangeString = simpleRange.getAdditionalFields().get(rangeSringKey);
            if (StringUtilities.isEmpty((String)matchingRangeString) || StringUtilities.isEmpty((String)rangeString)) continue;
            rangeString = rangeString.replaceAll("\\p{Punct}", " ");
            String rangefieldValue = StringNormalizer.normalise(this.standardiser.standardiseString(rangeString.toUpperCase()));
            String matchedValue = StringNormalizer.normalise(this.standardiser.standardiseString(matchingRangeString));
            rangeScore += this.calculateScore(matchedValue.toUpperCase(), rangefieldValue.toUpperCase());
            ((SuggestedCandidateRange)simpleRange).setMatchedCandiateRange(this.isMatchingString(matchedValue.toUpperCase(), rangefieldValue.toUpperCase()));
        }
        int unitsCount = simpleRange.getUnitCount();
        if (unitsCount > 0) {
            rangeScore += ((SuggestedCandidateRangeUnit)simpleRange.getUnitAt(0)).getScore();
            if (!((SuggestedCandidateRange)simpleRange).isMatchedCandiateRange()) {
                ((SuggestedCandidateRange)simpleRange).setMatchedCandiateRange(((SuggestedCandidateRangeUnit)simpleRange.getUnitAt(0)).isMatchedRangeUnit());
            }
        }
        ((SuggestedCandidateRange)simpleRange).setScore(rangeScore);
    }

    private void scoreUnit(ISuggestedCandidateRange simpleRange) {
        for (int i = 0; i < simpleRange.getUnitCount(); ++i) {
            ISuggestedRangeUnit simpleUnit = simpleRange.getUnitAt(i);
            double unitScore = 0.0;
            Set<String> unitKeySet = simpleUnit.getAdditionalFields().keySet();
            for (String unitStringKey : unitKeySet) {
                String unitfieldValue;
                String matchingUnitString = ((SuggestedCandidateRangeUnit)simpleUnit).getMatchingString(unitStringKey);
                if (StringUtilities.isEmpty((String)matchingUnitString) || StringUtilities.isEmpty((String)(unitfieldValue = ((SuggestedCandidateRangeUnit)simpleUnit).getAdditionalFields().get(unitStringKey)))) continue;
                unitfieldValue = this.standardiser.standardiseString(StringNormalizer.normalise(unitfieldValue));
                String matchedUnitValue = this.standardiser.standardiseString(StringNormalizer.normalise(matchingUnitString));
                unitScore += this.calculateScore(matchedUnitValue.toUpperCase(), unitfieldValue.toUpperCase());
                ((SuggestedCandidateRangeUnit)simpleUnit).setMatchedRangeUnit(this.isMatchingString(matchedUnitValue.toUpperCase(), unitfieldValue.toUpperCase()));
            }
            ((SuggestedCandidateRangeUnit)simpleUnit).setScore(unitScore);
        }
    }

    private double calculateScore(String string, String findString) {
        int totalCharsMatchhed = 0;
        int LDScore = ScoreRuleRangeUnitFields.LDScore(string.toCharArray(), findString.toCharArray());
        totalCharsMatchhed = findString.length() - LDScore;
        double score = (double)totalCharsMatchhed + (double)totalCharsMatchhed / (double)findString.length() * 3.0;
        score = score < 0.0 ? 0.0 : score;
        return score;
    }

    private boolean isMatchingString(String firstString, String secondString) {
        boolean matchFlag = false;
        if (secondString.contains(firstString)) {
            matchFlag = true;
        }
        if (!matchFlag && (matchFlag = this.matchString(firstString, secondString))) {
            matchFlag = this.matchString(secondString, firstString);
        }
        return matchFlag;
    }

    private boolean matchString(String firstString, String secondString) {
        boolean matchFlag = false;
        String[] inputStringArray = firstString.split(" ");
        int noOfWordsMatchedFromInput = 0;
        int matchedIndex = -1;
        for (String string : inputStringArray) {
            matchedIndex = secondString.indexOf(string);
            if (matchedIndex >= secondString.length() || matchedIndex == -1) continue;
            ++noOfWordsMatchedFromInput;
            if (matchedIndex + string.length() >= secondString.length()) continue;
            secondString = secondString.substring(matchedIndex + string.length());
        }
        if (noOfWordsMatchedFromInput == inputStringArray.length) {
            matchFlag = true;
        }
        return matchFlag;
    }

    private static final int LDScore(char[] chs1, char[] chs2) {
        int i;
        int n = chs1.length;
        int m = chs2.length;
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = chs2[j - 1];
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = chs1[i - 1] == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }
}

