/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.IDictionarySearchPriority;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.TokenStandardiser;
import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidateRange;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedRangeUnit;
import com.mapinfo.mapmarker.autosuggest.wrapper.CandidateCompare;
import com.mapinfo.mapmarker.autosuggest.wrapper.CurrentSearchInfo;
import com.mapinfo.mapmarker.autosuggest.wrapper.ExtendedSuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.wrapper.ICandidateScoreRule;
import com.mapinfo.mapmarker.autosuggest.wrapper.ScoreRuleDistance;
import com.mapinfo.mapmarker.autosuggest.wrapper.ScoreRuleFields;
import com.mapinfo.mapmarker.autosuggest.wrapper.ScoreRulePreferExactPlaceName;
import com.mapinfo.mapmarker.autosuggest.wrapper.ScoreRulePreferOriginal;
import com.mapinfo.mapmarker.autosuggest.wrapper.ScoreRuleRangeUnitFields;
import com.mapinfo.mapmarker.autosuggest.wrapper.ScoreRuleRatioMatched;
import com.mapinfo.mapmarker.autosuggest.wrapper.ScoreRuleRatioMatchedStreetName;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidateRange;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidateRangeUnit;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidates;
import com.mapinfo.mapmarker.autosuggest.wrapper.WrapperDataInfo;
import com.mapinfo.mapmarker.common.Address;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultCollator {
    private ArrayList<CurrentSearchInfo> results = new ArrayList();
    private List<ICandidateScoreRule> m_scoreRuleList = new ArrayList<ICandidateScoreRule>();
    private ICandidateScoreRule m_distanceScoreRule = new ScoreRuleDistance();
    private ICandidateScoreRule m_ratioMatchedScoreRule = new ScoreRuleRatioMatched();
    private ICandidateScoreRule m_ratioMatchedStreetnameScoreRule = new ScoreRuleRatioMatchedStreetName();
    private ICandidateScoreRule m_fieldsScoreRule = new ScoreRuleFields();
    private ICandidateScoreRule m_preferOriginalScoreRule = new ScoreRulePreferOriginal();
    private ICandidateScoreRule m_preferExactPlacename = new ScoreRulePreferExactPlaceName();
    private ICandidateScoreRule m_scoreRuleRangeUnitFields = new ScoreRuleRangeUnitFields();
    private IAutoSuggestConstraints m_constraints;
    static final Logger logger = LoggerFactory.getLogger(SearchResultCollator.class);

    public SearchResultCollator(IAutoSuggestConstraints constraints) {
        this.m_constraints = constraints;
    }

    public ArrayList<CurrentSearchInfo> getResults() {
        return this.results;
    }

    public void add(CurrentSearchInfo result) {
        if (result != null) {
            this.results.add(result);
        }
    }

    private void applyScoreRules(List<ISuggestedCandidate> candidateList, List<ICandidateScoreRule> scoreRuleList) {
        for (ISuggestedCandidate candidate : candidateList) {
            for (ICandidateScoreRule rule : scoreRuleList) {
                rule.apply(candidate);
            }
        }
    }

    private void applyFilterNonMatchingRangeUnits(List<ISuggestedCandidate> candidateList) {
        if (candidateList != null) {
            for (ISuggestedCandidate candidate : candidateList) {
                this.filterNonMatchingRanges(candidate);
            }
        }
    }

    private void filterNonMatchingRanges(ISuggestedCandidate candidate) {
        List<ISuggestedCandidateRange> rangeList = candidate.getSuggestedRangeList();
        if (rangeList != null && !rangeList.isEmpty()) {
            Iterator<ISuggestedCandidateRange> rangeIterator = rangeList.iterator();
            int rangecount = rangeList.size();
            boolean firstCand = true;
            while (rangeIterator.hasNext()) {
                ISuggestedCandidateRange candiateRange = rangeIterator.next();
                boolean isRangeMatched = ((SuggestedCandidateRange)candiateRange).isMatchedCandiateRange();
                if (rangecount > 1 && !isRangeMatched && !firstCand) {
                    rangeIterator.remove();
                    --rangecount;
                    continue;
                }
                this.filterNonMatchingUnits(candiateRange);
                if (!firstCand) continue;
                firstCand = false;
            }
        }
    }

    private void filterNonMatchingUnits(ISuggestedCandidateRange candiateRange) {
        List<ISuggestedRangeUnit> unitsList = candiateRange.getRangeUnits();
        if (unitsList != null && !unitsList.isEmpty()) {
            SuggestedCandidateRangeUnit firstUnit = (SuggestedCandidateRangeUnit)candiateRange.getUnitAt(0);
            boolean isFirstUnitMatched = firstUnit.isMatchedRangeUnit();
            Iterator<ISuggestedRangeUnit> unitIterator = unitsList.iterator();
            int unitCount = unitsList.size();
            if (isFirstUnitMatched) {
                while (unitIterator.hasNext()) {
                    ISuggestedRangeUnit unit = unitIterator.next();
                    boolean isUnitMatched = ((SuggestedCandidateRangeUnit)unit).isMatchedRangeUnit();
                    if (unitCount <= 1 || isUnitMatched) continue;
                    unitIterator.remove();
                    --unitCount;
                }
            }
        }
    }

    private void trim(List<ISuggestedCandidate> candidateList, int limit) {
        for (int i = candidateList.size() - 1; i >= limit; --i) {
            candidateList.remove(i);
        }
    }

    public SuggestedCandidates combine(Address address) {
        List<ISuggestedCandidate> candidateList = this.scoreCandidates(address);
        this.applyFilterNonMatchingRangeUnits(candidateList);
        if (candidateList != null && candidateList.size() > 0) {
            Collections.sort(candidateList, new CandidateCompare());
            this.trimCandidateList(candidateList);
        }
        return new SuggestedCandidates(candidateList);
    }

    public void reCalculateFormattedFields(List<ISuggestedCandidate> candidateList) {
        for (ExtendedSuggestedCandidate extendedSuggestedCandidate : candidateList) {
            extendedSuggestedCandidate.resetFormattedStreetAddress(false);
            extendedSuggestedCandidate.rollupRangeUnitInfo();
            extendedSuggestedCandidate.trimRangesUnits(this.m_constraints);
            if (!extendedSuggestedCandidate.isEmptyUnitsRemoved()) continue;
            extendedSuggestedCandidate.resetFormattedStreetAddress(true);
        }
    }

    public List<ISuggestedCandidate> scoreCandidates(Address address) {
        this.m_scoreRuleList.clear();
        if (this.m_constraints.getOrigin() != null) {
            this.m_scoreRuleList.add(this.m_distanceScoreRule);
        }
        this.m_scoreRuleList.add(this.m_ratioMatchedStreetnameScoreRule);
        this.m_scoreRuleList.add(this.m_ratioMatchedScoreRule);
        this.m_scoreRuleList.add(this.m_fieldsScoreRule);
        this.m_scoreRuleList.add(this.m_scoreRuleRangeUnitFields);
        this.m_scoreRuleList.add(this.m_preferOriginalScoreRule);
        this.m_scoreRuleList.add(this.m_preferExactPlacename);
        if (this.results.isEmpty()) {
            return null;
        }
        ArrayList<ISuggestedCandidate> candidateList = new ArrayList<ISuggestedCandidate>();
        int defaultPriority = 1;
        for (CurrentSearchInfo info : this.results) {
            WrapperDataInfo dataInfo = info.getDataInfo();
            TokenStandardiser standardiser = dataInfo.getHandler().getTokenStandardiser();
            int dictPriority = this.getDictionaryPriority(dataInfo, this.m_constraints);
            if (dictPriority < 0) {
                dictPriority = defaultPriority++;
            }
            String dictName = dataInfo.getDictionaryName();
            boolean isCustomData = dataInfo.isCustomData();
            Iterator<SimpleAddress> it = info.getResult().getResultIterator();
            while (it.hasNext()) {
                candidateList.add(new ExtendedSuggestedCandidate(address, it.next(), this.m_constraints, dataInfo.getType(), dataInfo.getCountry(), info.getWrapper().getAdditionalFieldInfo(), dictName, dictPriority, isCustomData, standardiser));
            }
        }
        this.applyScoreRules(candidateList, this.m_scoreRuleList);
        return candidateList;
    }

    private int getDictionaryPriority(WrapperDataInfo info, IAutoSuggestConstraints constraints) {
        String dictName = info.getDictionaryName();
        IDictionarySearchPriority searchPriority = constraints.getDictionarySearchPriority();
        return searchPriority == null ? -1 : searchPriority.getSearchPriorityForDictionary(dictName);
    }

    private void trimCandidateList(List<ISuggestedCandidate> candidateList) {
        if (candidateList != null) {
            this.removeDistantCandidates(candidateList);
            int limit = 5;
            int count = this.m_constraints.getMaxCandidates();
            if (count > 0) {
                limit = count;
            }
            this.removeDuplicates(candidateList, limit);
            this.trim(candidateList, limit);
        }
    }

    private void removeDistantCandidates(List<ISuggestedCandidate> candidateList) {
        if (this.m_constraints.getOrigin() != null) {
            int idx = candidateList.size() - 1;
            double searchDistance = this.m_constraints.getSearchDistance();
            if (searchDistance <= 0.0) {
                return;
            }
            for (int i = idx; i >= 0; --i) {
                ISuggestedCandidate candidate = candidateList.get(i);
                if (!(candidate.getDistance() > searchDistance)) continue;
                candidateList.remove(i);
            }
        }
    }

    protected void removeDuplicates(List<ISuggestedCandidate> candidateList, int limit) {
        int orginalSize = candidateList.size();
        limit = Math.min(orginalSize, limit);
        int accepted = 0;
        for (int i = 0; i < orginalSize && accepted < limit; ++i) {
            ISuggestedCandidate candidate1 = candidateList.get(i);
            boolean isDuplicate = false;
            for (int j = 0; j < accepted; ++j) {
                ISuggestedCandidate candidate2 = candidateList.get(j);
                if (!candidate1.equals(candidate2)) continue;
                isDuplicate = true;
                break;
            }
            if (isDuplicate) {
                candidateList.remove(i--);
                --orginalSize;
                continue;
            }
            ++accepted;
        }
    }
}

