/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.AddressStringFormatter;
import com.mapinfo.mapmarker.autosuggest.FieldMatchInfo;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.TokenStandardiser;
import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidateRange;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleUnit;
import com.mapinfo.mapmarker.autosuggest.utils.GeomUtil;
import com.mapinfo.mapmarker.autosuggest.utils.SuggestedCandidateRangeUnitUtils;
import com.mapinfo.mapmarker.autosuggest.wrapper.AdditionalFieldInfo;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidateRange;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.util.DoublePoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class SuggestedCandidate
implements ISuggestedCandidate {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private List<String> inputStrList = new ArrayList<String>();
    private Address m_inputAddress;
    SimpleAddress address;
    String country;
    IAutoSuggestConstraints.DistanceUnits unitPref = IAutoSuggestConstraints.DistanceUnits.KILOMETERS;
    private int type;
    private IAutoSuggestConstraints constraints;
    private double distanceScore;
    private double addressNumberScore;
    private double streetNameScore;
    private double placeNameScore;
    private double areaName1Score;
    private double areaName2Score;
    private double areaName3Score;
    private double areaName4Score;
    private double postCodeScore;
    private int numStreetCharsMatched;
    private double exactAreaName3Score;
    private double matchesStreetScore;
    private double matchesPlaceScore;
    private double ratioMatchedScore;
    private double exactPlaceNameScore;
    private double rangeScore;
    private boolean exactAreaName3Match;
    private boolean exactAreaName3MatchNonNormalized;
    private boolean matchesInput;
    private String dictName;
    private String formattedLocationAddress;
    private String formattedLocationAddressPreferred;
    private String formattedStreetAddress;
    private String standardisedStreetAddress;
    private String formattedString;
    private String formattedStringPreferred;
    private Map<String, String> additionalFields;
    AdditionalFieldInfo additionalFieldInfo;
    private int dictPriority;
    private boolean isCustomData;
    private TokenStandardiser TokenStandardiser;
    protected static Pattern[] duplicateAreaNamesPatterns;
    private boolean candPerfectMatchOnSingleField;
    private boolean m_bRankDecoded = false;
    private int m_rankValue = Integer.MAX_VALUE;
    private List<ISuggestedCandidateRange> suggestedRangeList = new ArrayList<ISuggestedCandidateRange>();
    protected static final String[] duplicateAreaNamesRegexes;
    protected static final String[] duplicateAreaNamesReplacements;

    public SuggestedCandidate(Address input, SimpleAddress address, IAutoSuggestConstraints constraints, int type) {
        this(input, address, constraints, type, null, null, null, 0, false, null);
    }

    public SuggestedCandidate(Address input, SimpleAddress address, IAutoSuggestConstraints constraints, int type, String countryCode, AdditionalFieldInfo additionalFieldInfo, String dictName, int dictPriority, boolean isCustomData, TokenStandardiser standardiser) {
        List<SimpleRange> rangelist;
        int keyID;
        this.m_inputAddress = input;
        StringTokenizer toks = new StringTokenizer(input.getMainAddress(), " ", false);
        while (toks.hasMoreTokens()) {
            this.inputStrList.add(toks.nextToken());
        }
        this.address = address;
        this.country = countryCode;
        if (additionalFieldInfo != null && (keyID = additionalFieldInfo.getIDForKey("country")) > 0) {
            this.country = this.getMatchedValue(address, keyID);
        }
        this.constraints = constraints;
        this.dictName = dictName;
        this.isCustomData = isCustomData;
        this.dictPriority = dictPriority;
        this.TokenStandardiser = standardiser;
        if (constraints != null) {
            this.unitPref = constraints.getUnits();
        }
        this.type = type;
        this.matchesInput = true;
        this.additionalFieldInfo = additionalFieldInfo;
        this.additionalFields = new HashMap<String, String>();
        if ("XWG".equals(countryCode)) {
            this.additionalFields.put("FROM_WORLD_FALLBACK", "true");
        }
        if (additionalFieldInfo != null) {
            for (String addKey : additionalFieldInfo.keySet()) {
                String value;
                int keyID2 = additionalFieldInfo.getIDForKey(addKey);
                FieldType fieldtype = FieldType.getPredefinedField((int)keyID2);
                boolean addValueToAdditionalField = false;
                if (fieldtype != null) {
                    if (fieldtype.getLevel() != FieldType.FieldLevel.LEVEL_RANGE && fieldtype.getLevel() != FieldType.FieldLevel.LEVEL_UNIT) {
                        addValueToAdditionalField = true;
                    }
                } else {
                    addValueToAdditionalField = true;
                }
                if (!addValueToAdditionalField || StringUtilities.isEmpty((String)(value = this.getMatchedValue(address, additionalFieldInfo.getIDForKey(addKey))))) continue;
                this.additionalFields.put(addKey, value);
            }
        }
        if ((rangelist = address.getRanges()) != null && !rangelist.isEmpty()) {
            boolean isFirstDummyRange = true;
            for (SimpleRange simpleRange : rangelist) {
                boolean isDummyRange = SuggestedCandidateRangeUnitUtils.isDummyRange(simpleRange, additionalFieldInfo);
                if (isFirstDummyRange && isDummyRange) {
                    this.populateFormattedAddressAtRangeAndUnit(simpleRange);
                    this.suggestedRangeList.add(new SuggestedCandidateRange(simpleRange, address.getFieldMatchInfos(), additionalFieldInfo, address.getStreetFormatFieldsPattern()));
                    isFirstDummyRange = false;
                    continue;
                }
                if (isDummyRange) continue;
                this.populateFormattedAddressAtRangeAndUnit(simpleRange);
                this.suggestedRangeList.add(new SuggestedCandidateRange(simpleRange, address.getFieldMatchInfos(), additionalFieldInfo, address.getStreetFormatFieldsPattern()));
            }
        }
    }

    private void populateRangeandUnitAsPerFormat(SimpleRange simpleRange) {
        String[] lastLineformatPattern = this.getLastlineFormatFieldsPattern();
        String[] streetformatPattern = this.getStreetFormatFieldsPattern();
        AddressStringFormatter formatter = null;
        if (simpleRange != null) {
            if (simpleRange.getUnitCount() > 0) {
                List<SimpleUnit> unitList = simpleRange.getUnits();
                for (SimpleUnit simpleUnit : unitList) {
                    formatter = new AddressStringFormatter(this.address.getFieldMatchInfos(), this.address, simpleRange, simpleUnit);
                    simpleUnit.addField(201, formatter.getFormattedAddressString(false, streetformatPattern).getAddressString() + ", " + SuggestedCandidate.replace(formatter.getFormattedAddressString(false, lastLineformatPattern).getAddressString(), duplicateAreaNamesPatterns, duplicateAreaNamesReplacements));
                }
            }
            formatter = new AddressStringFormatter(this.address.getFieldMatchInfos(), this.address, simpleRange, null);
            simpleRange.addField(201, formatter.getFormattedAddressString(false, streetformatPattern).getAddressString() + ", " + SuggestedCandidate.replace(formatter.getFormattedAddressString(false, lastLineformatPattern).getAddressString(), duplicateAreaNamesPatterns, duplicateAreaNamesReplacements));
        }
    }

    private void populateFormattedAddressAtRangeAndUnit(SimpleRange simpleRange) {
        this.populateRangeandUnitAsPerFormat(simpleRange);
    }

    private String[] getStreetFormatFieldsPattern() {
        return this.address.getStreetFormatFieldsPattern();
    }

    private String[] getLastlineFormatFieldsPattern() {
        return this.address.getLastlineFormatFieldsPattern();
    }

    public void setMatchesInput(boolean val) {
        this.matchesInput = val;
    }

    public boolean getMatchesInput() {
        return this.matchesInput;
    }

    protected String getMatchedValue(SimpleAddress address, int idx) {
        if (idx < 0) {
            return null;
        }
        List<String> fieldVals = address.getField(idx);
        if (!ListUtils.isEmpty(fieldVals)) {
            FieldMatchInfo info = address.getFieldMatchInfo(idx);
            if (info != null && info.getMatchedValueNdx() > -1) {
                return fieldVals.get(info.getMatchedValueNdx());
            }
            return fieldVals.get(0);
        }
        return null;
    }

    @Override
    public DoublePoint getLocation() {
        double[] geom = this.address.getCentroid();
        if (this.constraints != null && !CoordSysConstants.longLatWGS84.equals(this.constraints.getCoordSysObject())) {
            DirectPosition transformed = CoordConvertor.transformPointFromWGS84((CoordSys)this.constraints.getCoordSysObject(), (DirectPosition)new DirectPosition(geom[0], geom[1]));
            return new DoublePoint(transformed.getX(), transformed.getY());
        }
        return new DoublePoint(geom[0], geom[1]);
    }

    @Override
    public DirectPosition getLocationPoint() {
        double[] geom = this.address.getCentroid();
        if (this.constraints != null && !CoordSysConstants.longLatWGS84.equals(this.constraints.getCoordSysObject())) {
            return CoordConvertor.transformPointFromWGS84((CoordSys)this.constraints.getCoordSysObject(), (DirectPosition)new DirectPosition(geom[0], geom[1]));
        }
        return new DirectPosition(geom[0], geom[1]);
    }

    @Override
    public String getFormattedLocationAddress() {
        return this.getFormattedLocationAddress(false);
    }

    @Override
    public String getFormattedLocationAddress(boolean usePreferredNames) {
        String formattedLocationAddr;
        if (usePreferredNames) {
            if (this.formattedLocationAddressPreferred != null) {
                return this.formattedLocationAddressPreferred;
            }
        } else if (this.formattedLocationAddress != null) {
            return this.formattedLocationAddress;
        }
        if (!StringUtilities.isEmpty((String)(formattedLocationAddr = this.address.getFormattedAddressString(usePreferredNames, this.address.getLastlineFormatFieldsPattern()).getAddressString()))) {
            formattedLocationAddr = SuggestedCandidate.replace(formattedLocationAddr, duplicateAreaNamesPatterns, duplicateAreaNamesReplacements);
            if (usePreferredNames) {
                this.formattedLocationAddressPreferred = formattedLocationAddr.trim();
                return this.formattedLocationAddressPreferred;
            }
            this.formattedLocationAddress = formattedLocationAddr.trim();
            return this.formattedLocationAddress;
        }
        return formattedLocationAddr;
    }

    @Override
    public String getFormattedStreetAddress() {
        String fsa;
        if (this.formattedStreetAddress == null && (fsa = this.address.getFormattedAddressString(false, this.getStreetFormatFieldsPattern()).getAddressString()) != null) {
            this.formattedStreetAddress = fsa.trim();
            if (this.address.matchedOnField(8)) {
                this.standardisedStreetAddress = this.TokenStandardiser.standardiseString(this.formattedStreetAddress.toUpperCase());
            }
        }
        return this.formattedStreetAddress;
    }

    public void resetFormattedStreetAddress(boolean shouldReset) {
        if (this.isReformattingRequired() || shouldReset) {
            ISuggestedCandidateRange iSuggestedCandidateRange;
            Map<String, String> rangeFieldsMap;
            this.formattedStreetAddress = null;
            this.address.getFields().put(3, null);
            this.formattedString = null;
            this.formattedStringPreferred = null;
            List<ISuggestedCandidateRange> suggestedRangeList = this.getSuggestedRangeList();
            this.formattedStreetAddress = this.getFormattedStreetAddress();
            this.formattedString = this.getFormattedString();
            this.formattedStringPreferred = this.getFormattedString(true);
            if ((this.isMatchedOnAdditionalField() || shouldReset) && suggestedRangeList != null && suggestedRangeList.size() > 0 && (rangeFieldsMap = (iSuggestedCandidateRange = suggestedRangeList.get(0)).getAdditionalFields()) != null) {
                ArrayList<String> fieldList = new ArrayList<String>();
                fieldList.add(rangeFieldsMap.get(FieldType.RANGE_PLACE_NAME_FIELD_TYPE.getName()));
                this.address.getFields().put(3, fieldList);
                this.address.setHNR(iSuggestedCandidateRange.getFrom());
            }
        }
    }

    private boolean isReformattingRequired() {
        String[] streetFormatFields;
        boolean reformattingRequired = false;
        HashSet<Integer> fieldsSet = new HashSet<Integer>();
        for (String string : streetFormatFields = this.getStreetFormatFieldsPattern()) {
            if (!MMUtils.isNumber((String)string)) continue;
            fieldsSet.add(Integer.valueOf(string));
        }
        fieldsSet.addAll(this.address.getFieldMatchInfos().keySet());
        Iterator fmiIterator = fieldsSet.iterator();
        while (fmiIterator.hasNext()) {
            int key = (Integer)fmiIterator.next();
            if (key != 3 && (FieldType.isPredefinedType((int)key) || !this.address.getFieldMatchInfos().containsKey(key))) continue;
            reformattingRequired = true;
            break;
        }
        return reformattingRequired;
    }

    private boolean isMatchedOnAdditionalField() {
        boolean flag = false;
        Map<Integer, FieldMatchInfo> fieldMatchInfo = this.address.getFieldMatchInfos();
        for (int key : fieldMatchInfo.keySet()) {
            if (key != 3 && FieldType.isPredefinedType((int)key)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public String getFormattedString() {
        if (!MMUtils.isEmpty((String)this.formattedString)) {
            return this.formattedString;
        }
        StringBuilder builder = new StringBuilder();
        if (this.getLastlineFormatFieldsPattern() != null && this.getStreetFormatFieldsPattern() != null) {
            int rangecount = this.getRangeCount();
            int unitcount = -1;
            if (rangecount > 0) {
                ISuggestedCandidateRange range = this.getSuggestedRangeList().get(0);
                unitcount = range.getUnitCount();
                if (unitcount > 0) {
                    builder.append(range.getUnitAt(0).getAdditionalFields().get("FORMATTED_STRING"));
                } else {
                    String hnrAtCandidate = this.getAddressNumber();
                    String hnrAtRange = this.getAddressNumberAtRange(range);
                    if (!MMUtils.isEmpty((String)hnrAtCandidate) && MMUtils.isEmpty((String)hnrAtRange) && this.isCandidateHnrMatchesRange(hnrAtCandidate, range)) {
                        builder.append(range.getAdditionalFields().get("FORMATTED_STRING"));
                    } else if (this.isCandidateHnrInRange(hnrAtCandidate, range) && !MMUtils.isEmpty((String)hnrAtRange)) {
                        builder.append(range.getAdditionalFields().get("FORMATTED_STRING").replaceFirst(hnrAtRange, this.getAddressNumber()));
                    } else if (MMUtils.isEmpty((String)hnrAtCandidate)) {
                        StringBuilder sbregex = new StringBuilder("\\b");
                        sbregex.append(hnrAtRange);
                        sbregex.append("\\b");
                        String regex = sbregex.toString();
                        builder.append(range.getAdditionalFields().get("FORMATTED_STRING").replaceFirst(regex, "").replaceFirst(" ,", ","));
                    }
                }
            }
            if (MMUtils.isEmpty((String)builder.toString())) {
                AddressStringFormatter formatter = new AddressStringFormatter(this.address.getFieldMatchInfos(), this.address);
                String formattedStreet = formatter.getFormattedAddressString(false, this.getStreetFormatFieldsPattern()).getAddressString();
                builder.append(formattedStreet);
                if (formattedStreet != null && formattedStreet.length() > 0) {
                    builder.append(", ");
                }
                builder.append(SuggestedCandidate.replace(formatter.getFormattedAddressString(false, this.getLastlineFormatFieldsPattern()).getAddressString(), duplicateAreaNamesPatterns, duplicateAreaNamesReplacements)).toString();
            }
            if (this.type == 1) {
                String[] streetFormatPattern = this.getStreetFormatFieldsPattern();
                boolean isplaceNameinPattern = false;
                for (String string : streetFormatPattern) {
                    if (!string.equals(7)) continue;
                    isplaceNameinPattern = true;
                    break;
                }
                if (!MMUtils.isEmpty((String)this.getName()) && !isplaceNameinPattern) {
                    builder.insert(0, this.getName() + ", ");
                }
            }
            this.formattedString = builder.toString().trim();
        }
        return builder.toString();
    }

    private String getAddressNumberAtRange(ISuggestedCandidateRange range) {
        String from = range.getFrom();
        String to = range.getTo();
        StringBuilder builder = new StringBuilder();
        if (!StringUtilities.isEmpty((String)from) && !StringUtilities.isEmpty((String)to)) {
            builder.append(from);
            if (!to.equalsIgnoreCase(from)) {
                builder.append("-").append(to);
            }
        }
        return builder.toString();
    }

    private boolean isCandidateHnrInRange(String candidateHNR, ISuggestedCandidateRange range) {
        String tempCandHnr;
        int canhnrNumericPart;
        int from = -1;
        int to = -1;
        if (MMUtils.isNumber((String)range.getFrom())) {
            from = Integer.valueOf(range.getFrom());
        }
        if (MMUtils.isNumber((String)range.getTo())) {
            to = Integer.valueOf(range.getTo());
        }
        int n = canhnrNumericPart = MMUtils.isEmpty((String)(tempCandHnr = MMUtils.getStartingNumberPart((String)candidateHNR))) ? 0 : Integer.valueOf(tempCandHnr);
        return !MMUtils.isEmpty((String)tempCandHnr) && (canhnrNumericPart > from || canhnrNumericPart < to || canhnrNumericPart < from || canhnrNumericPart > to);
    }

    private boolean isCandidateHnrMatchesRange(String candidateHNR, ISuggestedCandidateRange range) {
        if (!MMUtils.isEmpty((String)candidateHNR) && (candidateHNR.equals(range.getFrom()) || candidateHNR.equals(range.getTo()))) {
            return true;
        }
        int from = -1;
        int to = -1;
        if (MMUtils.isNumber((String)range.getFrom())) {
            from = Integer.valueOf(range.getFrom());
        }
        if (MMUtils.isNumber((String)range.getTo())) {
            to = Integer.valueOf(range.getFrom());
        }
        if (from > 0 || to > 0) {
            int canhnrNumericPart;
            String tempCandHnr = MMUtils.getStartingNumberPart((String)candidateHNR);
            int n = canhnrNumericPart = MMUtils.isEmpty((String)tempCandHnr) ? 0 : Integer.valueOf(tempCandHnr);
            if (!(MMUtils.isEmpty((String)tempCandHnr) || canhnrNumericPart != from && canhnrNumericPart != to)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getFormattedString(boolean usePreferredNames) {
        if (usePreferredNames && this.formattedStringPreferred != null) {
            return this.formattedStringPreferred;
        }
        if (!usePreferredNames && this.formattedString != null) {
            return this.formattedString;
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (this.getLastlineFormatFieldsPattern() != null && this.getStreetFormatFieldsPattern() != null) {
            int rangecount = this.getRangeCount();
            int unitcount = -1;
            if (usePreferredNames) {
                FieldType.FieldLevel fieldLevel = this.address.getLowestMatchedFieldInAddrHierarchy();
                if (rangecount > 0) {
                    ISuggestedCandidateRange range = this.getSuggestedRangeList().get(0);
                    unitcount = range.getUnitCount();
                    if (unitcount > 0 && fieldLevel == FieldType.FieldLevel.LEVEL_UNIT) {
                        stringBuilder.append(range.getUnitAt(0).getAdditionalFields().get("FORMATTED_STRING"));
                    } else if (fieldLevel == FieldType.FieldLevel.LEVEL_RANGE) {
                        String hnrAtCandidate = this.getAddressNumber();
                        String hnrAtRange = this.getAddressNumberAtRange(range);
                        if (!MMUtils.isEmpty((String)hnrAtCandidate) && MMUtils.isEmpty((String)hnrAtRange) && this.isCandidateHnrMatchesRange(hnrAtCandidate, range)) {
                            stringBuilder.append(range.getAdditionalFields().get("FORMATTED_STRING"));
                        } else if (this.isCandidateHnrInRange(hnrAtCandidate, range)) {
                            stringBuilder.append(range.getAdditionalFields().get("FORMATTED_STRING").replaceFirst(hnrAtRange, this.getAddressNumber()));
                        } else if (MMUtils.isEmpty((String)hnrAtCandidate)) {
                            stringBuilder.append(range.getAdditionalFields().get("FORMATTED_STRING").replaceFirst(hnrAtRange, "").replaceFirst(" ,", ","));
                        }
                    }
                }
            } else {
                rangecount = this.getRangeCount();
                unitcount = -1;
                if (rangecount > 0) {
                    ISuggestedCandidateRange range = this.getSuggestedRangeList().get(0);
                    unitcount = range.getUnitCount();
                    if (unitcount > 0) {
                        stringBuilder.append(range.getUnitAt(0).getAdditionalFields().get("FORMATTED_STRING"));
                    } else {
                        stringBuilder.append(range.getAdditionalFields().get("FORMATTED_STRING"));
                    }
                }
            }
        }
        if (MMUtils.isEmpty((String)stringBuilder.toString())) {
            AddressStringFormatter formatter = new AddressStringFormatter(this.address.getFieldMatchInfos(), this.address);
            stringBuilder.append(formatter.getFormattedAddressString(usePreferredNames, this.getStreetFormatFieldsPattern()).getAddressString() + ", " + SuggestedCandidate.replace(formatter.getFormattedAddressString(usePreferredNames, this.getLastlineFormatFieldsPattern()).getAddressString(), duplicateAreaNamesPatterns, duplicateAreaNamesReplacements));
        }
        if (usePreferredNames) {
            this.formattedStringPreferred = stringBuilder.toString().trim();
            return this.formattedStringPreferred;
        }
        this.formattedString = stringBuilder.toString().trim();
        return this.formattedString;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public String getAreaName1() {
        return this.getAreaName1(false);
    }

    @Override
    public String getAreaName1(boolean usePreferredNames) {
        int index = this.getMatchedIndex(usePreferredNames, 16);
        return this.getString(16, index);
    }

    @Override
    public String getAreaName2() {
        return this.getAreaName2(false);
    }

    @Override
    public String getAreaName2(boolean usePreferredNames) {
        int index = this.getMatchedIndex(usePreferredNames, 17);
        return this.getString(17, index);
    }

    @Override
    public String getAreaName3() {
        return this.getAreaName3(false);
    }

    @Override
    public String getAreaName3(boolean usePreferredNames) {
        int index = this.getMatchedIndex(usePreferredNames, 18);
        return this.getString(18, index);
    }

    @Override
    public String getAreaName4() {
        return this.getAreaName4(false);
    }

    @Override
    public String getAreaName4(boolean usePreferredNames) {
        int index = this.getMatchedIndex(usePreferredNames, 19);
        return this.getString(19, index);
    }

    @Override
    public String getPostCode() {
        return this.getString(15, 0);
    }

    @Override
    public String getName() {
        return this.getString(7, 0);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getCategory() {
        return this.getFieldValue(26);
    }

    @Override
    public String getSubCategory() {
        return this.getFieldValue(27);
    }

    @Override
    public String getBrandName() {
        return this.additionalFields.get("brand_name");
    }

    @Override
    public List<String> getInput() {
        return this.inputStrList;
    }

    public Address getInputAddress() {
        return this.m_inputAddress;
    }

    @Override
    public int getNumCharsMatched() {
        return this.address.getNumCharsMatched();
    }

    public int getNumCharsMatchedForField(int field) {
        return this.address.getNumCharsMatched(field);
    }

    @Override
    public Set<String> getAdditionalFieldKeys() {
        return this.additionalFields.keySet();
    }

    @Override
    public String getAdditionalFieldValue(String key) {
        return this.additionalFields.get(key);
    }

    @Override
    public Map<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    @Override
    public String getFieldValue(int key) {
        if (key == 4) {
            return this.address.getHNR();
        }
        List<String> aList = this.address.getField(key);
        FieldMatchInfo fieldmatchInfo = this.address.getFieldMatchInfo(key);
        if (aList != null && aList.size() > 0) {
            if (fieldmatchInfo != null && fieldmatchInfo.getMatchedValueNdx() > -1 && fieldmatchInfo.getMatchedValueNdx() < aList.size()) {
                return aList.get(fieldmatchInfo.getMatchedValueNdx());
            }
            return aList.get(0);
        }
        return null;
    }

    private String getString(int key, int idx) {
        List<String> fieldValues = this.address.getField(key);
        if (fieldValues != null && fieldValues.size() > idx) {
            return fieldValues.get(idx);
        }
        return null;
    }

    @Override
    public double getDistance() {
        double dist = this.address.getDistance();
        return GeomUtil.convertFromMeters(dist, this.unitPref);
    }

    @Override
    public IAutoSuggestConstraints.DistanceUnits getDistanceUnits() {
        return this.unitPref;
    }

    @Override
    public String getDictionaryName() {
        return this.dictName;
    }

    @Override
    public int getDictionaryPriority() {
        return this.dictPriority;
    }

    @Override
    public boolean isFromUserDictionary() {
        return this.isCustomData;
    }

    public boolean equals(Object other) {
        String streetAddress2;
        String streetAddress1;
        String post2;
        String post1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof SuggestedCandidate)) {
            return false;
        }
        SuggestedCandidate candidate2 = (SuggestedCandidate)other;
        double distDiff = this.address.getDistance() - candidate2.address.getDistance();
        if (Math.abs(distDiff) > 10000.0) {
            return false;
        }
        if (StringUtilities.equalStrings((String)this.getFieldValue(8), (String)candidate2.getFieldValue(8)) && StringUtilities.equalStrings((String)(post1 = this.getFieldValue(15)), (String)(post2 = candidate2.getFieldValue(15)))) {
            String house1 = this.getFieldValue(4);
            String house2 = candidate2.getFieldValue(4);
            if (house1 != null && house2 != null) {
                int len1 = house1.length();
                int len2 = house2.length();
                if (post1 != null && len1 == len2 + post1.length() + 1 && house1.startsWith(house2)) {
                    return true;
                }
                if (post1 != null && len2 == len1 + post1.length() + 1 && house2.startsWith(house1)) {
                    return true;
                }
            }
        }
        if (!StringUtilities.equalStrings((String)(streetAddress1 = this.getFormattedStreetAddress()), (String)(streetAddress2 = candidate2.getFormattedStreetAddress()))) {
            if (this.address.matchedOnField(8) && candidate2.address.matchedOnField(8)) {
                if (!StringUtilities.equalStrings((String)this.standardisedStreetAddress, (String)candidate2.standardisedStreetAddress)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (!StringUtilities.equalStrings((String)this.getFormattedLocationAddress(true), (String)candidate2.getFormattedLocationAddress(true))) {
            return false;
        }
        if (!StringUtilities.equalStringsIgnoreCase((String)this.getName(), (String)candidate2.getName())) {
            return false;
        }
        if (this.getType() == 1 && candidate2.getType() == 1) {
            if (!StringUtilities.equalStringsIgnoreCase((String)this.getAdditionalFieldValue("micode"), (String)candidate2.getAdditionalFieldValue("micode"))) {
                return false;
            }
            if (!StringUtilities.equalStringsIgnoreCase((String)this.getBrandName(), (String)candidate2.getBrandName())) {
                return false;
            }
            if (!StringUtilities.equalStringsIgnoreCase((String)this.getAdditionalFieldValue("featureID"), (String)candidate2.getAdditionalFieldValue("featureID"))) {
                return false;
            }
        }
        return StringUtilities.equalStringsIgnoreCase((String)this.getFieldValue(24), (String)candidate2.getFieldValue(24));
    }

    public int hashCode() {
        int value = 17;
        long l = Double.doubleToLongBits(this.getDistance());
        value = 31 * value + (int)(l ^ l >>> 32);
        String s = this.getFieldValue(8);
        value = 31 * value + (s == null ? 0 : s.hashCode());
        s = this.getFieldValue(15);
        value = 31 * value + (s == null ? 0 : s.hashCode());
        s = this.getFieldValue(4);
        value = 31 * value + (s == null ? 0 : s.hashCode());
        s = this.getName();
        value = 31 * value + (s == null ? 0 : s.hashCode());
        return value;
    }

    private static Pattern[] preCompile(String[] regexes) {
        Pattern[] patterns = new Pattern[regexes.length];
        for (int i = 0; i < regexes.length; ++i) {
            patterns[i] = Pattern.compile(regexes[i]);
        }
        return patterns;
    }

    protected static String replace(String input, Pattern[] patterns, String[] replacements) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        for (int i = 0; i < patterns.length; ++i) {
            input = patterns[i].matcher(input).replaceAll(replacements[i]);
        }
        return input;
    }

    protected int getMatchedIndex(boolean usePreferredNames, int key) {
        if (usePreferredNames) {
            return 0;
        }
        int index = this.address.getMatchedIndex(key);
        if (index < 0) {
            return 0;
        }
        return index;
    }

    private String concatInputLine() {
        StringBuilder returnString = new StringBuilder();
        List<String> inputList = this.getInput();
        for (String s : inputList) {
            returnString.append(s);
            returnString.append(" ");
        }
        return returnString.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SuggestedCandidate:").append(NEW_LINE);
        sb.append("formattedString: ").append(this.getFormattedString()).append(NEW_LINE);
        sb.append("formattedStreetAddress: ").append(this.getFormattedStreetAddress()).append(NEW_LINE);
        sb.append("formattedLocationAddress: ").append(this.getFormattedLocationAddress()).append(NEW_LINE);
        sb.append("Address Fields:").append(NEW_LINE);
        sb.append("\tAddress Number: ").append(this.address.getHNR()).append(NEW_LINE);
        Map<Integer, List<String>> fields = this.address.getFields();
        Object[] sortedKeys = fields.keySet().toArray(new Integer[0]);
        Arrays.sort(sortedKeys);
        Object[] objectArray = sortedKeys;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int fieldId = (Integer)objectArray[i];
            String fieldName = this.additionalFieldInfo.getKey(fieldId);
            if (StringUtilities.isEmpty((String)fieldName)) {
                fieldName = FieldType.getPredefinedField((int)fieldId).getExternalName();
            }
            sb.append("\t").append(fieldName).append("(").append(fieldId).append("): ");
            sb.append(fields.get(fieldId)).append(NEW_LINE);
        }
        Map<String, String> map = this.getAdditionalFields();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append("\tAdditionalFields--> ").append(entry.getKey() + ": " + entry.getValue()).append(NEW_LINE);
        }
        if ((this.type & 3) != 0) {
            sb.append("POI fields:").append(NEW_LINE);
            sb.append("\tName: ").append(this.getName()).append(NEW_LINE);
            sb.append("\tBrand Name: ").append(this.getBrandName()).append(NEW_LINE);
            sb.append("\tCategory Name: ").append(this.getCategory()).append(NEW_LINE);
            sb.append("\tSubcategory Name: ").append(this.getSubCategory()).append(NEW_LINE);
        }
        sb.append("Input tokens: ").append(this.concatInputLine()).append(NEW_LINE);
        sb.append("Number of chars matched: ").append(this.getNumCharsMatched()).append(NEW_LINE);
        sb.append("Type: ").append(this.getType()).append(NEW_LINE);
        sb.append("Country: ").append(this.getCountry()).append(NEW_LINE);
        sb.append("Distance: ").append(this.getDistance()).append(NEW_LINE);
        sb.append("DictionaryName: ").append(this.getDictionaryName()).append(NEW_LINE);
        sb.append("DictionaryPriority: ").append(this.getDictionaryPriority()).append(NEW_LINE);
        sb.append("Location: ").append(this.getLocation().toString()).append(NEW_LINE);
        sb.append("Match scores:").append(NEW_LINE);
        sb.append("\tMatches Input: ").append(this.matchesInput).append(NEW_LINE);
        sb.append("\tdistanceScore ").append(this.distanceScore).append(NEW_LINE);
        sb.append("\taddressNumberScore: ").append(this.addressNumberScore).append(NEW_LINE);
        sb.append("\tstreetNameScore: ").append(this.streetNameScore).append(NEW_LINE);
        sb.append("\tplaceNameScore: ").append(this.placeNameScore).append(NEW_LINE);
        sb.append("\tareaName1Score: ").append(this.areaName1Score).append(NEW_LINE);
        sb.append("\tareaName2Score: ").append(this.areaName2Score).append(NEW_LINE);
        sb.append("\tareaName3Score: ").append(this.areaName3Score).append(NEW_LINE);
        sb.append("\tareaName4Score: ").append(this.areaName4Score).append(NEW_LINE);
        sb.append("\trangeScore: ").append(this.getRangeScore()).append(NEW_LINE);
        sb.append("\tpostCodeScore: ").append(this.postCodeScore).append(NEW_LINE);
        sb.append("\texactAreaName3Score: ").append(this.exactAreaName3Score).append(NEW_LINE);
        sb.append("\tmatchesStreetScore: ").append(this.matchesStreetScore).append(NEW_LINE);
        sb.append("\tmatchesPlaceScore: ").append(this.matchesPlaceScore).append(NEW_LINE);
        sb.append("\tratioMatchedScore: ").append(this.ratioMatchedScore).append(NEW_LINE);
        sb.append("\texactPlaceNameScore: ").append(this.exactPlaceNameScore).append(NEW_LINE);
        sb.append("\tnumStreetCharsMatched: ").append(this.numStreetCharsMatched).append(NEW_LINE);
        sb.append("\tFuzzyMatchScore: ").append(this.getFuzzyMatchScore()).append(NEW_LINE);
        sb.append("Field matches:");
        sb.append(NEW_LINE);
        Map<String, String> matches = this.getMatchedFieldCharacters();
        for (Map.Entry<String, String> fieldEntry : matches.entrySet()) {
            sb.append("\t").append(fieldEntry.getKey()).append(": ").append(fieldEntry.getValue()).append(NEW_LINE);
        }
        return sb.toString();
    }

    public double getDistanceScore() {
        return this.distanceScore;
    }

    public void setDistanceScore(double score) {
        this.distanceScore = score;
    }

    public void setAddressNumberScore(double score) {
        this.addressNumberScore = score;
    }

    public double getAddressNumberScore() {
        return this.addressNumberScore;
    }

    public void setStreetNameScore(double score) {
        this.streetNameScore = score;
    }

    public double getStreetNameScore() {
        return this.streetNameScore;
    }

    public void setPlaceNameScore(double score) {
        this.placeNameScore = score;
    }

    public double getPlaceNameScore() {
        return this.placeNameScore;
    }

    public void setAreaName1Score(double score) {
        this.areaName1Score = score;
    }

    public double getAreaName1Score() {
        return this.areaName1Score;
    }

    public void setAreaName2Score(double score) {
        this.areaName2Score = score;
    }

    public double getAreaName2Score() {
        return this.areaName2Score;
    }

    public void setAreaName3Score(double score) {
        this.areaName3Score = score;
    }

    public double getAreaName3Score() {
        return this.areaName3Score;
    }

    public void setAreaName4Score(double score) {
        this.areaName4Score = score;
    }

    public double getAreaName4Score() {
        return this.areaName4Score;
    }

    public void setPostCodeScore(double score) {
        this.postCodeScore = score;
    }

    public double getPostCodeScore() {
        return this.postCodeScore;
    }

    public void setNumStreetCharsMatched(int numMatched) {
        this.numStreetCharsMatched = numMatched;
    }

    public int getNumStreetCharsMatched() {
        return this.numStreetCharsMatched;
    }

    public void setExactAreaName3Score(double score) {
        this.exactAreaName3Score = score;
    }

    public double getExactAreaName3Score() {
        return this.exactAreaName3Score;
    }

    public void setMatchesStreetScore(double score) {
        this.matchesStreetScore = score;
    }

    public double getMatchesStreetScore() {
        return this.matchesStreetScore;
    }

    public void setMatchesPlaceScore(double score) {
        this.matchesPlaceScore = score;
    }

    public double getMatchesPlaceScore() {
        return this.matchesPlaceScore;
    }

    public void setRatioMatchedScore(double score) {
        this.ratioMatchedScore = score;
    }

    public double getRatioMatchedScore() {
        return this.ratioMatchedScore;
    }

    public void setExactPlaceNameScore(double score) {
        this.exactPlaceNameScore = score;
    }

    public double getExactPlaceNameScore() {
        return this.exactPlaceNameScore;
    }

    public int getFuzzyMatchScore() {
        return this.address.getMatchScore();
    }

    public void setExactMatchAreaName3(boolean flag) {
        this.exactAreaName3Match = flag;
    }

    public boolean isExactAreaName3Match() {
        return this.exactAreaName3Match;
    }

    public void setExactAreaName3MatchNonNormalized(boolean flag) {
        this.exactAreaName3MatchNonNormalized = flag;
    }

    public boolean hasExactMatchAreaName3NonNormalized() {
        return this.exactAreaName3MatchNonNormalized;
    }

    @Override
    public Map<String, String> getMatchedFieldCharacters() {
        TreeMap<String, String> theMap = new TreeMap<String, String>();
        Map<Integer, FieldMatchInfo> fieldMatchInfos = this.address.getFieldMatchInfos();
        for (int typeIndex : fieldMatchInfos.keySet()) {
            String name = this.getMatchFieldName(typeIndex);
            theMap.put(name, fieldMatchInfos.get(typeIndex).getMatchedString());
        }
        return theMap;
    }

    private String getMatchFieldName(int typeIndex) {
        String name = this.additionalFieldInfo.getKey(typeIndex);
        if (name == null || name.length() == 0) {
            name = FieldType.getPredefinedName((int)typeIndex);
        }
        name = AdditionalFieldInfo.getExternalNameForKey(name);
        return name;
    }

    @Override
    public Map<String, Integer> getMatchedFields() {
        HashMap<String, Integer> matchFields = new HashMap<String, Integer>();
        Map<Integer, FieldMatchInfo> fieldMatchInfos = this.address.getFieldMatchInfos();
        for (int typeIndex : fieldMatchInfos.keySet()) {
            String name = this.getMatchFieldName(typeIndex);
            matchFields.put(name, typeIndex);
        }
        return matchFields;
    }

    @Override
    public int getRangeCount() {
        return this.suggestedRangeList != null ? this.suggestedRangeList.size() : 0;
    }

    @Override
    public String getAddressNumber() {
        return this.address.getHNR();
    }

    @Override
    public ISuggestedCandidateRange getSuggestedRange(int rangeNdx) {
        return this.suggestedRangeList.get(rangeNdx);
    }

    @Override
    public boolean isAreaGroup() {
        return this.address.isAreaAddressGroup();
    }

    @Override
    public List<ISuggestedCandidateRange> getSuggestedRangeList() {
        return this.suggestedRangeList;
    }

    public double getRangeScore() {
        return this.rangeScore;
    }

    public void setRangeScore(double rangeScore) {
        this.rangeScore = rangeScore;
    }

    public TokenStandardiser getTokenStandardiser() {
        return this.TokenStandardiser;
    }

    public boolean isCandPerfectMatchOnSingleField() {
        return this.candPerfectMatchOnSingleField;
    }

    public void setPerfectRangeUnitMatched(boolean perfectRangeUnitMatched) {
        this.candPerfectMatchOnSingleField = perfectRangeUnitMatched;
    }

    public int getRankValue() {
        if (!this.m_bRankDecoded) {
            this.m_bRankDecoded = true;
            String rank = this.getFieldValue(FieldType.RANK_FIELD_TYPE.getKey());
            if (rank != null) {
                try {
                    this.m_rankValue = Integer.parseInt(rank);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this.m_rankValue;
    }

    static {
        duplicateAreaNamesRegexes = new String[]{"^(.*), \\1$", "^(.*), \\1,", "^(.*), \\1( [0-9])", "(.*[0-9] )(.*), \\2\\b", "(.*, )(.*), \\2\\b"};
        duplicateAreaNamesReplacements = new String[]{"$1", "$1,", "$1$2", "$1$2", "$1$2"};
        duplicateAreaNamesPatterns = SuggestedCandidate.preCompile(duplicateAreaNamesRegexes);
    }
}

