/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.AddressStringFormatter;
import com.mapinfo.mapmarker.autosuggest.FieldMatchInfo;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidateRange;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedRangeUnit;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleUnit;
import com.mapinfo.mapmarker.autosuggest.utils.SuggestedCandidateRangeUnitUtils;
import com.mapinfo.mapmarker.autosuggest.wrapper.AdditionalFieldInfo;
import com.mapinfo.mapmarker.autosuggest.wrapper.SuggestedCandidateRangeUnit;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SuggestedCandidateRange
implements ISuggestedCandidateRange {
    private List<ISuggestedRangeUnit> suggestedUnitList = new ArrayList<ISuggestedRangeUnit>();
    private SimpleRange range;
    private double score;
    private Map<Integer, FieldMatchInfo> fieldMatchInfos;
    private boolean isMatchedCandiateRange;
    private Map<String, String> additionalFields;
    AdditionalFieldInfo additionalFieldInfo;
    private String[] streetFormatPattern;

    public SuggestedCandidateRange(SimpleRange range, Map<Integer, FieldMatchInfo> fieldMatchInfos, AdditionalFieldInfo additionalFieldInfo, String[] streetFormatFieldsPatterns) {
        this.range = range;
        this.fieldMatchInfos = fieldMatchInfos;
        this.additionalFieldInfo = additionalFieldInfo;
        this.streetFormatPattern = streetFormatFieldsPatterns;
        String rangeFormattedFeildValue = range.getFieldValue(201);
        range.getFields().remove(201);
        this.additionalFields = SuggestedCandidateRangeUnitUtils.populateAdditionalFields(range.getFields(), additionalFieldInfo);
        this.additionalFields.put("FORMATTED_STRING", rangeFormattedFeildValue);
        this.configureSuggestedUnits(range, fieldMatchInfos, additionalFieldInfo);
    }

    @Override
    public String getRangeString() {
        StringBuilder builder = new StringBuilder();
        AddressStringFormatter formatter = new AddressStringFormatter(this.fieldMatchInfos, this.range);
        builder.append(this.getFormattedRangeString(true));
        if (MMUtils.isEmpty((String)builder.toString().trim())) {
            ArrayList<Integer> fields = new ArrayList<Integer>();
            fields.add(5);
            fields.add(6);
            builder.append(formatter.getFormattedAddressString(false, fields).getAddressString());
            String fmtStr = this.getFormattedRangeString(false);
            if (!StringUtilities.isEmpty((String)fmtStr)) {
                if (!StringUtilities.isEmpty((String)builder.toString().trim())) {
                    builder.append(" , ");
                }
                builder.append(fmtStr);
            }
        }
        return builder.toString();
    }

    protected String getFormattedRangeString(boolean includeMatchedHNR) {
        StringBuilder builder = new StringBuilder();
        if (this.range != null) {
            String[] newFormatPattern = new String[this.streetFormatPattern.length];
            if (!includeMatchedHNR) {
                for (int i = 0; i < newFormatPattern.length; ++i) {
                    if (String.valueOf(4).equals(newFormatPattern[i])) {
                        newFormatPattern[i] = "{}";
                        if (i + 1 >= newFormatPattern.length) continue;
                        newFormatPattern[i + 1] = "{}";
                        continue;
                    }
                    newFormatPattern[i] = this.streetFormatPattern[i];
                }
            }
            AddressStringFormatter formatter = new AddressStringFormatter(this.fieldMatchInfos, this.range);
            builder.append(formatter.getFormattedAddressString(false, newFormatPattern).getAddressString());
        }
        return builder.toString().trim();
    }

    @Override
    public int getUnitCount() {
        return this.suggestedUnitList == null ? 0 : this.suggestedUnitList.size();
    }

    @Override
    public ISuggestedRangeUnit getUnitAt(int unitNdx) {
        if (unitNdx > -1 && unitNdx < this.suggestedUnitList.size()) {
            return this.suggestedUnitList.get(unitNdx);
        }
        return null;
    }

    @Override
    public String getFrom() {
        return this.range.getFrom();
    }

    @Override
    public String getTo() {
        return this.range.getTo();
    }

    @Override
    public int getOddEvenType() {
        return this.range.getOddEvenType();
    }

    @Override
    public boolean isMatchedOnRangeField() {
        return this.range.isMatchedOnRangeField();
    }

    @Override
    public boolean isInputNumberMatched() {
        return this.range.isInputNumberMatched();
    }

    @Override
    public List<ISuggestedRangeUnit> getRangeUnits() {
        return this.suggestedUnitList;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public boolean isMatchedCandiateRange() {
        return this.isMatchedCandiateRange;
    }

    public void setMatchedCandiateRange(boolean isMatchedCandiateRange) {
        this.isMatchedCandiateRange = isMatchedCandiateRange;
    }

    @Override
    public Map<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    private void configureSuggestedUnits(SimpleRange range, Map<Integer, FieldMatchInfo> fieldMatchInfos, AdditionalFieldInfo additionalFieldInfo) {
        List<SimpleUnit> unitList;
        if (range != null && (unitList = range.getUnits()) != null && !unitList.isEmpty()) {
            for (SimpleUnit simpleUnit : unitList) {
                this.suggestedUnitList.add(new SuggestedCandidateRangeUnit(simpleUnit, fieldMatchInfos, additionalFieldInfo, this.streetFormatPattern));
            }
        }
    }

    protected String getMatchingString(String additionalFieldKey) {
        FieldMatchInfo fieldMatchInfo;
        String matchedString = null;
        if (!StringUtilities.isEmpty((String)additionalFieldKey) && (fieldMatchInfo = this.fieldMatchInfos.get(this.additionalFieldInfo.getIDForKey(additionalFieldKey))) != null && fieldMatchInfo.getMatchedLength() > 0) {
            matchedString = fieldMatchInfo.getMatchedString();
        }
        return matchedString;
    }
}

