/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.AddressSearchResult;
import com.mapinfo.mapmarker.autosuggest.FieldMatchInfo;
import com.mapinfo.mapmarker.autosuggest.IAddressSearchResult;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.dp.AddressUtil;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.utils.StringNormalizer;
import com.mapinfo.mapmarker.autosuggest.wrapper.IWrappedSearchResult;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.math.NumberUtils;

public class WrappedSearchResult
implements IWrappedSearchResult {
    static final int MAX_DISTANCE_HINT_FROM_CLOSEST = 50000;
    private IAddressSearchResult m_result;
    ArrayList<SimpleAddress> m_candidates;
    IAutoSuggestConstraints m_constraints;
    private FETCH_ACCURACY m_fetchAccuracy = FETCH_ACCURACY.FULL_ACCURACY;

    public WrappedSearchResult(IAddressSearchResult result, IAutoSuggestConstraints constraints) {
        this(result, constraints, null);
    }

    public WrappedSearchResult(IAddressSearchResult result, IAutoSuggestConstraints constraints, List<SimpleAddress> existingCandidates) {
        this.m_result = result;
        this.m_constraints = constraints;
        this.m_candidates = new ArrayList();
        if (existingCandidates != null && !existingCandidates.isEmpty()) {
            this.m_candidates.addAll(existingCandidates);
        }
        this.m_fetchAccuracy = this.getFetchAccauracy(constraints);
        this.buildCandidateList();
    }

    private FETCH_ACCURACY getFetchAccauracy(IAutoSuggestConstraints constraints) {
        if (constraints.getOriginPoint() != null && this.m_result != null && this.m_result.resultsHasDistance()) {
            FETCH_ACCURACY fetchAccuracy = FETCH_ACCURACY.FULL_ACCURACY;
            if (constraints.getBoundingBox() == null && constraints.getSearchDistance() == 0.0) {
                fetchAccuracy = FETCH_ACCURACY.GAURANTEED_CLOSEST_ACCURACY;
            }
            return fetchAccuracy;
        }
        return FETCH_ACCURACY.NO_ACCURACY;
    }

    public IAddressSearchResult getAddressSearchResult() {
        return this.m_result;
    }

    @Override
    public Iterator<SimpleAddress> getResultIterator() {
        return this.m_candidates.iterator();
    }

    @Override
    public int getCandidateCount() {
        return this.m_candidates.size();
    }

    @Override
    public SimpleAddress candidateAt(int idx) {
        return this.m_candidates.get(idx);
    }

    protected void buildCandidateList() {
        if (this.m_result != null) {
            boolean compress;
            int max = this.calcNumCandidatesToGet(this.m_constraints, this.m_fetchAccuracy);
            if (max != -1) {
                if (this.m_candidates.size() >= max) {
                    return;
                }
                max -= this.m_candidates.size();
            }
            String filterCountry = null;
            if (this.m_result.getInputCountry() != null && this.dataContainsCountryField()) {
                filterCountry = this.m_result.getInputCountry();
            }
            boolean bl = compress = this.m_result.isAddressDictionary() && this.m_constraints.isCompressAreaResults();
            if (this.m_fetchAccuracy.ordinal() > 1) {
                Iterator<SimpleAddress> it = this.m_result.getResultIterator(compress, true);
                this.fetchAndBuildCandidates(max, this.m_fetchAccuracy, it, filterCountry);
            } else {
                Iterator<SimpleAddress> it = this.m_result.getResultIterator(-1, compress);
                this.fetchAndBuildCandidates(max, it, filterCountry);
            }
        }
    }

    protected void extendCandidateList(Iterator<SimpleAddress> it) {
        int max;
        if (this.m_result != null && (max = this.calcNumCandidatesToGet(this.m_constraints, this.m_fetchAccuracy)) > 0) {
            String filterCountry = null;
            if (this.m_result.getInputCountry() != null && this.dataContainsCountryField()) {
                filterCountry = this.m_result.getInputCountry();
            }
            if (this.m_result.resultsHasDistance() && this.m_fetchAccuracy.ordinal() > 1) {
                this.fetchAndBuildCandidates(max, this.m_fetchAccuracy, it, filterCountry);
            } else {
                this.fetchAndBuildCandidates(max, it, filterCountry);
            }
        }
    }

    private boolean dataContainsRank() {
        return ((AddressSearchResult)this.getAddressSearchResult()).getAutoSuggestHandler().getAddressMetaData().getFieldMap().containsKey(FieldType.RANK_FIELD_TYPE.getKey());
    }

    private boolean dataContainsCountryField() {
        return ((AddressSearchResult)this.getAddressSearchResult()).getAutoSuggestHandler().getAddressMetaData().getFieldMap().containsKey(FieldType.COUNTRY_FIELD_TYPE.getKey());
    }

    private void fetchAndBuildCandidates(int max, Iterator<SimpleAddress> it, String filterCountry) {
        if (this.dataContainsRank()) {
            this.fetchAndBuildRankedCandidates(max, it, filterCountry);
            return;
        }
        if (it != null) {
            int count = 0;
            while (it.hasNext() && count < max && max != -1) {
                boolean bAdd = false;
                SimpleAddress simpleAddress = it.next();
                if (simpleAddress != null && simpleAddress.hnrMatched()) {
                    if (!this.m_constraints.isMustMatchAddressNumber() || this.isExactHNRMatch(simpleAddress)) {
                        bAdd = true;
                    }
                } else {
                    bAdd = true;
                }
                if (filterCountry != null && !filterCountry.equals(simpleAddress.getFieldValue(FieldType.COUNTRY_FIELD_TYPE.getKey()))) {
                    bAdd = false;
                }
                if (!bAdd) continue;
                this.m_candidates.add(simpleAddress);
                ++count;
            }
        }
    }

    private void fetchAndBuildRankedCandidates(int max, Iterator<SimpleAddress> it, String filterCountry) {
        ArrayList<RankSortingEntry> candidates = new ArrayList<RankSortingEntry>(max + 1);
        ArrayList<SimpleAddress> airportCandidates = null;
        ArrayList<SimpleAddress> otherCandidates = null;
        if (max < 10) {
            max = 10;
        }
        airportCandidates = new ArrayList<SimpleAddress>(max + 1);
        otherCandidates = new ArrayList<SimpleAddress>(max + 1);
        if (it != null) {
            while (it.hasNext()) {
                FieldMatchInfo info;
                SimpleAddress address = it.next();
                boolean bAdd = true;
                if (this.m_constraints.isMustMatchAddressNumber() && !this.isExactHNRMatch(address)) {
                    bAdd = false;
                }
                if (address.getFieldMatchInfos().size() == 1 && address.getFieldMatchInfos().containsKey(16)) {
                    bAdd = false;
                }
                if (bAdd && (info = address.getFieldMatchInfo(16)) != null) {
                    String matchedString = info.getMatchedString();
                    int matchStringLen = matchedString.length();
                    int index = info.getMatchedValueNdx();
                    String originalMatch = StringNormalizer.normalise(address.getField(16).get(index));
                    if (matchStringLen != originalMatch.length()) {
                        bAdd = false;
                        List<String> values = address.getField(16);
                        for (int i = 0; i < values.size(); ++i) {
                            String currentValue;
                            if (index == i || matchStringLen != (currentValue = StringNormalizer.normalise(values.get(i))).length() || !matchedString.equals(currentValue)) continue;
                            FieldMatchInfo updated = new FieldMatchInfo(info.getFieldID(), info.getMatchedString(), info.getMatchStartCharNdx(), i, info.getMatchedOrig());
                            Map<Integer, FieldMatchInfo> infos = address.getFieldMatchInfos();
                            infos.remove(16);
                            address.addFieldMatchInfo(updated);
                            bAdd = true;
                            break;
                        }
                    }
                }
                if (filterCountry != null && !filterCountry.equals(address.getFieldValue(FieldType.COUNTRY_FIELD_TYPE.getKey()))) {
                    bAdd = false;
                }
                if (!bAdd) continue;
                if (this.isAirport(address)) {
                    if (address.getFieldMatchInfo(24) == null || airportCandidates.size() >= max) continue;
                    airportCandidates.add(address);
                    continue;
                }
                if (this.isOther(address)) {
                    if (address.getFieldMatchInfo(24) == null || otherCandidates.size() >= max) continue;
                    otherCandidates.add(address);
                    continue;
                }
                RankSortingEntry entry = new RankSortingEntry(address);
                int loc = Collections.binarySearch(candidates, entry);
                if (loc < 0) {
                    candidates.add(-1 * loc - 1, entry);
                } else {
                    candidates.add(loc, entry);
                }
                if (candidates.size() <= max) continue;
                candidates.remove(max);
            }
            for (RankSortingEntry entry : candidates) {
                this.m_candidates.add(entry.getAddress());
            }
            for (SimpleAddress address : airportCandidates) {
                this.m_candidates.add(address);
            }
            for (SimpleAddress address : otherCandidates) {
                this.m_candidates.add(address);
            }
        }
    }

    private boolean isAirport(SimpleAddress address) {
        return address.getField(24) != null && address.getField(202) != null;
    }

    private boolean isOther(SimpleAddress address) {
        return address.getField(24) != null && address.getField(202) == null;
    }

    protected boolean isExactHNRMatch(SimpleAddress simpleAddress) {
        int matchedIndex = -1;
        ArrayList<SimpleRange> rangeListReturned = null;
        List<SimpleRange> rangeList = simpleAddress.getRanges();
        String hnrStr = simpleAddress.getHNR();
        boolean exactMatchFound = false;
        if (ListUtils.isEmpty(rangeList) || hnrStr == null) {
            return true;
        }
        Iterator<SimpleRange> rangeIter = rangeList.iterator();
        while (rangeIter.hasNext()) {
            boolean exactHNRMatch = false;
            SimpleRange range = rangeIter.next();
            if (NumberUtils.isDigits((String)hnrStr)) {
                int hnr = Integer.parseInt(hnrStr);
                boolean bl = exactHNRMatch = AddressUtil.getHNROffset(range, hnr) == 0;
                if (exactHNRMatch) {
                    if (range.getFrom() == null) {
                        exactHNRMatch = hnrStr.equalsIgnoreCase(range.getTo());
                    }
                    if (range.getTo() == null) {
                        exactHNRMatch = hnrStr.equalsIgnoreCase(range.getFrom());
                    }
                }
            } else if (AddressUtil.isExtendedHnr(hnrStr)) {
                exactHNRMatch = StringUtilities.isEmpty((String)range.getTo()) ? hnrStr.equalsIgnoreCase(range.getFrom()) : AddressUtil.possibleExtendedHNRExactMatch(range, hnrStr);
            } else {
                int addressNumber = AddressUtil.getNumericAddressNumber(hnrStr);
                if (addressNumber != -1) {
                    String alphaPart = hnrStr.replaceFirst(Integer.toString(addressNumber), "");
                    if (range.getFrom() != null && range.getFrom().toLowerCase().contains(alphaPart.toLowerCase()) || range.getTo() != null && range.getTo().toLowerCase().contains(alphaPart.toLowerCase())) {
                        boolean bl = exactHNRMatch = AddressUtil.getHNROffset(range, addressNumber) == 0;
                    }
                }
            }
            if (!exactHNRMatch || exactMatchFound) continue;
            exactMatchFound = exactHNRMatch;
            rangeListReturned = new ArrayList<SimpleRange>();
            rangeListReturned.add(range);
            simpleAddress.setRanges(rangeListReturned);
            break;
        }
        return exactMatchFound;
    }

    private void fetchAndBuildCandidates(int max, FETCH_ACCURACY fetchAccuracy, Iterator<SimpleAddress> it, String filterCountry) {
        TreeSet<Integer> candDistances = new TreeSet<Integer>();
        int fetched = 0;
        if (it != null) {
            while (it.hasNext()) {
                boolean bAdd = false;
                SimpleAddress cand = it.next();
                if (cand != null && cand.hnrMatched()) {
                    if (!this.m_constraints.isMustMatchAddressNumber() || this.isExactHNRMatch(cand)) {
                        bAdd = true;
                    }
                } else {
                    bAdd = true;
                }
                if (filterCountry != null && !filterCountry.equals(cand.getFieldValue(FieldType.COUNTRY_FIELD_TYPE.getKey()))) {
                    bAdd = false;
                }
                if (!bAdd) continue;
                this.m_candidates.add(cand);
                int candidateDistance = (int)cand.getDistance();
                if (!this.checkAndSetMaxRequiredDistance(fetchAccuracy, this.m_result, candidateDistance, this.m_candidates.size())) break;
                if (++fetched >= max) {
                    this.adjustDistanceSet(candDistances, candidateDistance);
                    if (!this.fetchMoreFromMax(candDistances, this.m_result)) break;
                    this.m_result.setOptimalMaxDistance(candDistances.last());
                    continue;
                }
                candDistances.add(candidateDistance);
            }
        }
        int size = this.m_candidates.size();
        if (!this.m_constraints.isCompressAreaResults() && size > max + 1) {
            HashMap<String, SimpleAddress> map = new HashMap<String, SimpleAddress>();
            for (SimpleAddress addr : this.m_candidates) {
                StringBuilder addresKeyBuilder = new StringBuilder();
                addresKeyBuilder.append(addr.getDistance()).append(addr.toString());
                map.put(addresKeyBuilder.toString(), addr);
            }
            this.m_candidates.clear();
            this.m_candidates.addAll(map.values());
            size = this.m_candidates.size();
            if (size > max + 1) {
                Collections.sort(this.m_candidates, new SimpleAddressComparator());
                this.m_candidates = new ArrayList<SimpleAddress>(this.m_candidates.subList(0, max + 1));
            }
        }
    }

    boolean checkAndSetMaxRequiredDistance(FETCH_ACCURACY fetchAccuracy, IAddressSearchResult result, int candDist, int candCount) {
        if (fetchAccuracy == FETCH_ACCURACY.GAURANTEED_CLOSEST_ACCURACY) {
            int optimalMaxDistance;
            int minFutherCandDist = result.getMinimumDistanceForFurtherResults();
            if (candCount == 1) {
                int minDist = Math.min(minFutherCandDist, candDist);
                int optimalMaxDistance2 = minDist < 50000 ? 50000 : minDist + 50000;
                result.setOptimalMaxDistance(optimalMaxDistance2);
            }
            if (minFutherCandDist > (optimalMaxDistance = result.getOptimalMaxDistance())) {
                return false;
            }
        }
        return true;
    }

    boolean fetchMoreFromMax(SortedSet<Integer> currentCandDistances, IAddressSearchResult searchResult) {
        int furthestCandidateDistance = currentCandDistances.last();
        return searchResult.getMinimumDistanceForFurtherResults() <= furthestCandidateDistance;
    }

    void adjustDistanceSet(TreeSet<Integer> currentCandDistances, int newCandDist) {
        if (currentCandDistances.isEmpty()) {
            currentCandDistances.add(newCandDist);
        } else {
            int currentFurthestDist = currentCandDistances.last();
            if (newCandDist < currentFurthestDist && currentCandDistances.add(newCandDist)) {
                currentCandDistances.pollLast();
            }
        }
    }

    private int calcNumCandidatesToGet(IAutoSuggestConstraints constraints, FETCH_ACCURACY fetchAccuracy) {
        int max = 100;
        if (constraints != null) {
            max = fetchAccuracy == FETCH_ACCURACY.PARTIAL_ACCURACY ? Math.min(200, Math.max(100, 2 * constraints.getMaxCandidates())) : (fetchAccuracy == FETCH_ACCURACY.GAURANTEED_CLOSEST_ACCURACY && this.m_candidates.size() > 0 ? 0 : constraints.getMaxCandidates());
        }
        return max;
    }

    private static class RankSortingEntry
    implements Comparable<RankSortingEntry> {
        private Integer m_rank;
        private SimpleAddress m_address;

        public RankSortingEntry(SimpleAddress address) {
            this.m_address = address;
            String s = address.getFieldValue(FieldType.RANK_FIELD_TYPE.getKey());
            if (s != null) {
                try {
                    this.m_rank = Integer.parseInt(address.getFieldValue(FieldType.RANK_FIELD_TYPE.getKey()));
                }
                catch (NumberFormatException NFEx) {
                    this.m_rank = Integer.MAX_VALUE;
                }
            } else {
                this.m_rank = Integer.MAX_VALUE;
            }
        }

        @Override
        public int compareTo(RankSortingEntry entry) {
            return Integer.compare(this.m_rank, entry.getRank());
        }

        public SimpleAddress getAddress() {
            return this.m_address;
        }

        public int getRank() {
            return this.m_rank;
        }
    }

    private class SimpleAddressComparator
    implements Comparator<SimpleAddress> {
        private SimpleAddressComparator() {
        }

        @Override
        public int compare(SimpleAddress o1, SimpleAddress o2) {
            return (int)(o1.getDistance() - o2.getDistance());
        }
    }

    static enum FETCH_ACCURACY {
        NO_ACCURACY,
        PARTIAL_ACCURACY,
        GAURANTEED_CLOSEST_ACCURACY,
        FULL_ACCURACY;

    }
}

