/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.wrapper;

import com.mapinfo.mapmarker.autosuggest.AutoSuggestHandler;
import com.mapinfo.mapmarker.autosuggest.utils.AutoSuggestLog;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class WrapperDataInfo {
    private AutoSuggestHandler handler;
    private String country;
    private int type;

    public WrapperDataInfo(AutoSuggestHandler handler, String country) {
        this.handler = handler;
        this.country = country;
        this.type = this.convertDataType(handler.getDataSetType());
    }

    public AutoSuggestHandler getHandler() {
        return this.handler;
    }

    public String getCountry() {
        return this.country;
    }

    public String getDictionaryName() {
        return this.handler.getAddressMetaData().getDataName();
    }

    public boolean isCustomData() {
        return this.handler.isCustomData();
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        int result = 31 * this.type;
        if (this.country != null) {
            result = 31 * result + this.country.hashCode();
        }
        if (this.handler != null) {
            result = 31 * result + this.handler.hashCode();
        }
        return result;
    }

    public boolean canUseDataForSearchType(int searchType) {
        return this.type == 2 && (searchType & 0x7C) > 0 || this.type == 1 && (searchType & 3) > 0;
    }

    public boolean canUseDataForCountry(String country) {
        return StringUtilities.isEmpty((String)country) || country.equalsIgnoreCase(this.getCountry());
    }

    protected int convertDataType(int handlerDataType) {
        if (handlerDataType == 1) {
            return 1;
        }
        if (handlerDataType == 0) {
            return 2;
        }
        AutoSuggestLog.getLog().error((Object)("unrecognized handler data type: " + handlerDataType));
        throw new RuntimeException("unrecognized handler data type: " + handlerDataType);
    }
}

