/*
 * Decompiled with CFR 0.152.
 */
package com.pb.spectrum.gav.data;

import com.pb.spectrum.gav.data.DictionaryPath;
import com.pb.spectrum.gav.data.TypeAheadException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Map;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="DictionaryInfo")
public class DictionaryInfo
extends DictionaryPath {
    private int index;
    private String type;
    private String defaultCountryCode;
    private Map<String, HashSet<String>> supportedCountries;

    public String getDefaultCountryCode() {
        return this.defaultCountryCode;
    }

    public void setDefaultCountryCode(String defaultCountryCode) {
        this.defaultCountryCode = defaultCountryCode;
    }

    public DictionaryInfo() {
    }

    public DictionaryInfo(int index, String name, String type, String path) throws TypeAheadException {
        super(name, path);
        this.index = index;
        this.type = type;
    }

    public DictionaryInfo(int index, String name, String type, String path, String countryCode) throws TypeAheadException {
        this(index, name, type, path);
        this.defaultCountryCode = countryCode;
    }

    public void configureSupportedCountries(Map<String, HashSet<String>> supportedCountry) throws TypeAheadException {
        this.supportedCountries = supportedCountry;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DictionaryInfo)) {
            return false;
        }
        DictionaryInfo that = (DictionaryInfo)o;
        if (this.index != that.index) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.index;
        result = 31 * result + this.type.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "DictionaryInfo [" + this.index + " " + this.getName() + " " + this.type + " " + this.getPath() + "]";
    }

    public Map<String, HashSet<String>> getSupportedCountries() {
        return this.supportedCountries;
    }

    class CountryIdentifierFilter
    implements FilenameFilter {
        private static final String FILENAMEFILTER = ".rdx";

        CountryIdentifierFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().contains(FILENAMEFILTER);
        }
    }
}

