/*
 * Decompiled with CFR 0.152.
 */
package com.pb.spectrum.gav.data;

import com.pb.spectrum.gav.data.DictionaryDataSet;
import com.pb.spectrum.gav.data.DictionaryManagerException;
import com.pb.spectrum.gav.data.SpdInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="DictionaryResource")
public class DictionaryResource {
    private static final int GTA_SPD_COUNT = 1;
    private String resourceName;
    private String dictioanryDataSetSearchOrder;
    private DictionaryDataSet[] dictionaryDataSetArray;
    private String countryCode;
    private int dictionaryCount;
    List<SpdInfo> info;
    ArrayList<SpdInfo> gtaSpdProperty;
    private int[] numberOfItemsPerDataSet;
    private int[] startingIndexPerDataSet;

    public void setNumberOfItemsPerDataSet(int[] entriesArray) {
        this.numberOfItemsPerDataSet = entriesArray;
    }

    public int[] getNumberOfItemsPerDataSet() {
        return this.numberOfItemsPerDataSet;
    }

    public void setStartingIndexPerDataSet(int[] entriesArray) {
        this.startingIndexPerDataSet = entriesArray;
    }

    public int[] getStartingIndexPerDataSet() {
        return this.startingIndexPerDataSet;
    }

    public DictionaryResource(Properties properties, ArrayList<SpdInfo> arrayList) throws DictionaryManagerException {
        this.initialize(properties, arrayList);
    }

    public int getDictionaryCount() {
        return this.dictionaryCount;
    }

    private String readPropertyAsString(String name, Properties properties) throws DictionaryManagerException {
        return properties.getProperty(name);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private void initialize(Properties properties, ArrayList<SpdInfo> gtaSpdProperty) throws DictionaryManagerException {
        this.info = new ArrayList<SpdInfo>();
        this.resourceName = this.readPropertyAsString("resource.name", properties);
        if (DictionaryResource.isEmpty(this.resourceName)) {
            throw new DictionaryManagerException("Data Resource Name not Defined");
        }
        String dictionaryCount = null;
        dictionaryCount = this.readPropertyAsString("DICTIONARY_COUNT", properties);
        this.countryCode = this.readPropertyAsString("DICTIONARY_COUNTRY_CODE", properties);
        this.dictioanryDataSetSearchOrder = this.readPropertyAsString("DICTIONARY_SEARCH_ORDER", properties);
        if (Integer.parseInt(dictionaryCount) > 0) {
            this.dictionaryDataSetArray = new DictionaryDataSet[1];
        }
        int configuredIndex = 1;
        for (SpdInfo spdInfo : gtaSpdProperty) {
            this.dictionaryDataSetArray[0] = new DictionaryDataSet(this.resourceName, spdInfo.getSpdPath(), configuredIndex);
            ++configuredIndex;
        }
        this.setSelectGTACountryList(gtaSpdProperty);
    }

    public synchronized DictionaryDataSet[] getDictionaryDataSetArray() {
        return this.dictionaryDataSetArray;
    }

    public String getDefaultCountry() {
        return this.countryCode;
    }

    public void SetDefaultCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getDefaultSearchOrder() {
        return this.dictioanryDataSetSearchOrder;
    }

    public List<String> getSelectGTACountryList() {
        ArrayList<String> selectGTACountryList = new ArrayList<String>();
        for (SpdInfo spdInfo : this.gtaSpdProperty) {
            selectGTACountryList.add(spdInfo.getCountryCode());
        }
        return selectGTACountryList;
    }

    public void setSelectGTACountryList(ArrayList<SpdInfo> gtaSpdProperty) {
        this.gtaSpdProperty = gtaSpdProperty;
    }

    class CountryIdentifierFilter
    implements FilenameFilter {
        private static final String FILENAMEFILTER = ".rdx";

        CountryIdentifierFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().contains(FILENAMEFILTER);
        }
    }
}

