/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import java.io.UnsupportedEncodingException;

class BaseByteArrayReader {
    private byte[] byteArray;
    private String encoding;
    private int next = 0;
    private static final int INT_LENGTH = 4;
    private static final short SHORT_LENGTH = 2;
    private static final String ENCODING = System.getProperty("file.encoding");

    public BaseByteArrayReader(byte[] byteArray, String encoding) {
        this.byteArray = byteArray;
        this.encoding = encoding;
    }

    public static BaseByteArrayReader newBaseByteArrayReader(byte[] byteArray) {
        return new BaseByteArrayReader(byteArray, ENCODING);
    }

    public void skip(int n) {
        this.next += n;
    }

    public char readChar() throws UnsupportedEncodingException {
        String result = new String(this.byteArray, this.next++, 1, this.encoding);
        return result.charAt(0);
    }

    public String readString(int length) throws UnsupportedEncodingException {
        return this.readString(length, true);
    }

    public String readString(int length, boolean trim) {
        int ptr;
        String result = null;
        for (ptr = 0; ptr < length && this.byteArray[this.next + ptr] != 0; ++ptr) {
        }
        try {
            result = new String(this.byteArray, this.next, ptr, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.next += length;
        if (trim && result != null) {
            result = result.trim();
        }
        return result;
    }

    public short readShort(int length) throws UnsupportedEncodingException {
        return Short.parseShort(this.readString(length));
    }

    public short readShort(int length, boolean useDefaultIfBlank, int defaultValueIfBlank) throws UnsupportedEncodingException {
        short s;
        try {
            s = Short.parseShort(this.readString(length));
        }
        catch (NumberFormatException n) {
            if (useDefaultIfBlank) {
                s = (short)defaultValueIfBlank;
            }
            throw n;
        }
        return s;
    }

    public int readInt(int length) throws UnsupportedEncodingException {
        return Integer.parseInt(this.readString(length));
    }

    public int readInt(int length, boolean useDefaultIfBlank, int defaultValueIfBlank) throws UnsupportedEncodingException {
        int s;
        try {
            s = Integer.parseInt(this.readString(length));
        }
        catch (NumberFormatException n) {
            if (useDefaultIfBlank) {
                s = defaultValueIfBlank;
            }
            throw n;
        }
        return s;
    }

    public short readShort() throws UnsupportedEncodingException {
        throw new UnsupportedOperationException("Method is deprecated. Use readShort(int) instead.");
    }

    public short readBinaryShort() {
        short result = 0;
        for (int i = 0; i < 2; ++i) {
            result = (short)(result << 8);
            result = (short)(result + ((short)this.byteArray[this.next++] & 0xFF));
        }
        return result;
    }

    public int readBinaryInt() {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result <<= 8;
            result += this.byteArray[this.next++] & 0xFF;
        }
        return result;
    }
}

