/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

public class Coordinate {
    private double longitude = 0.0;
    private double latitude = 0.0;

    public Coordinate() {
    }

    public Coordinate(double lon, double lat) {
        this.longitude = this.adjustPrecision(lon);
        this.latitude = this.adjustPrecision(lat);
    }

    public boolean isValid() {
        return Math.abs(this.longitude) > Double.MIN_VALUE && Math.abs(this.latitude) > Double.MIN_VALUE;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = this.adjustPrecision(longitude);
    }

    public void setLatitude(double latitude) {
        this.latitude = this.adjustPrecision(latitude);
    }

    private double adjustPrecision(double num) {
        return (double)((long)(num * 1000000.0)) / 1000000.0;
    }
}

