/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import com.centrus.geostan.GeoStanException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class GeoProps {
    static final int MAX_PROPERTIES = 100;
    protected boolean m_bDirty = false;
    protected HashMap m_Props = null;
    protected int m_listType = 0;
    private int m_initialCapacity = 50;
    private float m_loadFactor = 0.75f;
    private static HashMap m_propMetaData = null;
    private static Object m_synchObject = new Object();

    public GeoProps() {
        this.m_Props = new HashMap(this.m_initialCapacity, this.m_loadFactor);
        this.buildPropMetadata();
    }

    public GeoProps(GeoProps other) {
        this.m_Props = (HashMap)other.m_Props.clone();
        this.buildPropMetadata();
    }

    public void clear() {
        this.m_Props.clear();
        this.m_bDirty = true;
    }

    public void set(int key, String value) {
        this.checkValidKeyValueList(key, 1);
        this.m_Props.put(new Integer(key), value);
        this.m_bDirty = true;
    }

    public void set(int key, boolean value) {
        this.checkValidKeyValueList(key, 4);
        this.m_Props.put(new Integer(key), new Boolean(value));
        this.m_bDirty = true;
    }

    public void set(int key, int value) {
        this.checkValidKeyValueList(key, 2);
        this.m_Props.put(new Integer(key), new Integer(value));
        this.m_bDirty = true;
    }

    public void set(int key, long value) {
        this.checkValidKeyValueList(key, 5);
        this.m_Props.put(new Integer(key), new Long(value));
        this.m_bDirty = true;
    }

    public Object getAsObj(int key) throws GeoStanException {
        this.checkValidKeyList(key);
        Object obj = this.m_Props.get(new Integer(key));
        if (obj == null) {
            throw new GeoStanException("Property list does not contain prop ID: " + key);
        }
        return obj;
    }

    public String getStr(int key) throws GeoStanException {
        this.checkValidKeyValueList(key, 1);
        Object obj = this.m_Props.get(new Integer(key));
        if (obj == null) {
            throw new GeoStanException("Property list does not contain prop ID: " + key);
        }
        return (String)obj;
    }

    public boolean getBool(int key) throws GeoStanException {
        this.checkValidKeyValueList(key, 4);
        Object obj = this.m_Props.get(new Integer(key));
        if (obj == null) {
            throw new GeoStanException("Property list does not contain prop ID: " + key);
        }
        return (Boolean)obj;
    }

    public int getInt(int key) throws GeoStanException {
        this.checkValidKeyValueList(key, 2);
        Object obj = this.m_Props.get(new Integer(key));
        if (obj == null) {
            throw new GeoStanException("Property list does not contain prop ID: " + key);
        }
        return (Integer)obj;
    }

    public long getLong(int key) throws GeoStanException {
        this.checkValidKeyValueList(key, 5);
        Object obj = this.m_Props.get(new Integer(key));
        if (obj == null) {
            throw new GeoStanException("Property list does not contain prop ID: " + key);
        }
        return (Long)obj;
    }

    public String getAsStr(int key) throws GeoStanException {
        this.checkValidKeyList(key);
        Object obj = this.m_Props.get(new Integer(key));
        if (obj == null) {
            throw new GeoStanException("Property list does not contain prop ID: " + key);
        }
        return obj.toString();
    }

    public int size() {
        return this.m_Props.size();
    }

    public Set entrySet() {
        return this.m_Props.entrySet();
    }

    public void remove(int key) {
        this.checkValidKeyList(key);
        this.m_Props.remove(new Integer(key));
        this.m_bDirty = true;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        GeoProps other = (GeoProps)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (Map.Entry thisEntry : this.entrySet()) {
            String otherValue;
            Integer thisPropID = (Integer)thisEntry.getKey();
            Object value = thisEntry.getValue();
            String thisValue = value.toString();
            try {
                otherValue = other.getAsStr(thisPropID);
            }
            catch (GeoStanException ex) {
                return false;
            }
            if (thisValue.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int key) {
        this.checkValidKeyList(key);
        return this.m_Props.containsKey(new Integer(key));
    }

    public OnePropInfo getPropInfo(int propID) {
        return GeoProps.getOnePropInfo(propID);
    }

    public static OnePropInfo getOnePropInfo(int propID) {
        return (OnePropInfo)m_propMetaData.get(new Integer(propID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildPropMetadata() {
        Object object = m_synchObject;
        synchronized (object) {
            if (m_propMetaData == null) {
                int i;
                int computedLength;
                int length = this.getPropMetadataCount();
                if (length != (computedLength = 108)) {
                    String errmsg = "GeoStan Property Count Mismatch in Java Layer, Actual Property Count was: " + length + " Computed Count was:" + computedLength;
                    throw new IllegalStateException(errmsg);
                }
                int[] IDs = new int[length];
                int[] containingLists = new int[length];
                int[] valueTypes = new int[length];
                this.getPropMetadata(length, IDs, containingLists, valueTypes, false);
                m_propMetaData = new HashMap(length, this.m_loadFactor);
                for (i = 0; i < length && IDs[i] > 0; ++i) {
                    OnePropInfo element = new OnePropInfo(IDs[i], containingLists[i], valueTypes[i]);
                    m_propMetaData.put(new Integer(IDs[i]), element);
                }
                if (i != length) {
                    String errmsg = "GeoStan Property load count mismatch, expected:" + length + " loaded:" + i;
                    throw new IllegalStateException(errmsg);
                }
            }
        }
    }

    protected void checkValidKeyList(int propID) {
        OnePropInfo info = GeoProps.getOnePropInfo(propID);
        if (info == null) {
            throw new IllegalArgumentException("Non-existant property key: " + propID);
        }
        if (info.m_containingList != this.m_listType) {
            throw new IllegalArgumentException("This property key is not valid for this containing property list: " + propID);
        }
    }

    protected void checkValidKeyValueList(int propID, int propType) {
        OnePropInfo info = GeoProps.getOnePropInfo(propID);
        if (info == null) {
            throw new IllegalArgumentException("Non-existant property key: " + propID);
        }
        if (info.m_type != propType) {
            throw new IllegalArgumentException("This property key does not support the value passed in: " + propID);
        }
        if (info.m_containingList != this.m_listType) {
            throw new IllegalArgumentException("This property key is not valid for this containing property list: " + propID);
        }
    }

    synchronized native int getPropMetadataCount();

    public boolean write(String outFileName, StringBuffer outString) {
        int numElements = this.size();
        int[] propIDs = new int[numElements];
        Object[] propValues = new String[numElements];
        this.flattenProperties(propIDs, (String[])propValues);
        if (outFileName == null) {
            String temp = this.writeProps(outFileName, propIDs, propValues);
            outString.append(temp);
        } else {
            this.writeProps(outFileName, propIDs, propValues);
        }
        return true;
    }

    public boolean read(String inFileName, String inString) {
        int[] propIDs = new int[100];
        Object[] propValues = new String[100];
        if (!this.readProps(inFileName, inString, this.m_listType, propIDs, propValues)) {
            return false;
        }
        this.clear();
        this.reconstituteProperties(propIDs, (String[])propValues);
        return true;
    }

    native String writeProps(String var1, int[] var2, Object[] var3);

    native boolean readProps(String var1, String var2, int var3, int[] var4, Object[] var5);

    public void flattenProperties(int[] propIDs, String[] propValues) {
        Iterator propIterator = this.entrySet().iterator();
        int i = 0;
        while (propIterator.hasNext()) {
            Map.Entry anEntry = (Map.Entry)propIterator.next();
            Integer propID = (Integer)anEntry.getKey();
            Object value = anEntry.getValue();
            String tempValue = value.toString();
            propIDs[i] = propID;
            propValues[i++] = tempValue;
        }
    }

    public void reconstituteProperties(int[] propIDs, String[] propValues) {
        block6: for (int j = 0; j < propIDs.length && propIDs[j] != -1; ++j) {
            int nextPropID = propIDs[j];
            String nextPropValue = propValues[j];
            OnePropInfo info = GeoProps.getOnePropInfo(nextPropID);
            switch (info.m_type) {
                case 4: {
                    Boolean booleanVal = Boolean.valueOf(nextPropValue);
                    boolean bVal = booleanVal;
                    this.set(nextPropID, bVal);
                    continue block6;
                }
                case 2: {
                    this.set(nextPropID, Integer.parseInt(nextPropValue));
                    continue block6;
                }
                case 5: {
                    this.set(nextPropID, Long.parseLong(nextPropValue));
                    continue block6;
                }
                case 1: {
                    this.set(nextPropID, nextPropValue);
                    continue block6;
                }
            }
        }
    }

    synchronized native boolean getPropMetadata(int var1, int[] var2, int[] var3, int[] var4, boolean var5);

    public class OnePropInfo {
        int m_ID;
        int m_containingList;
        int m_type;
        String m_name;
        String m_desc;

        public OnePropInfo(int propID, int containingList, int propType) {
            this.m_ID = propID;
            this.m_containingList = containingList;
            this.m_type = propType;
        }
    }

    public abstract class PropListType {
        public static final int UNDEF_TYPE = 0;
        public static final int INIT_TYPE = 1;
        public static final int FIND_TYPE = 2;
        public static final int STATUS_TYPE = 3;
    }

    public class PropType {
        public static final int UNDEF_PROP_TYPE = 0;
        public static final int STRING_PROP_TYPE = 1;
        public static final int LONG_PROP_TYPE = 2;
        public static final int DOUBLE_PROP_TYPE = 3;
        public static final int BOOL_PROP_TYPE = 4;
        public static final int POINTER_TYPE = 5;
        public static final int RESERVED2_PROP_TYPE = 6;
        public static final int RESERVED3_PROP_TYPE = 7;
        public static final int RESERVED4_PROP_TYPE = 8;
        public static final int RESERVED5_PROP_TYPE = 9;
        public static final int RESERVED6_PROP_TYPE = 10;
    }
}

