/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import com.centrus.geostan.CASS.CASSData;
import com.centrus.geostan.CASS.DPVCompleteStats;
import com.centrus.geostan.CASS.DPVInit;
import com.centrus.geostan.CASS.FalsePositiveDetail;
import com.centrus.geostan.CASS.FalsePositiveHeader;
import com.centrus.geostan.CASS.LACSCompleteStats;
import com.centrus.geostan.CASS.LACSLinkInit;
import com.centrus.geostan.City;
import com.centrus.geostan.CityIterator;
import com.centrus.geostan.ConfidenceInfo;
import com.centrus.geostan.Coordinate;
import com.centrus.geostan.FindProps;
import com.centrus.geostan.GeoStanBase;
import com.centrus.geostan.GeoStanException;
import com.centrus.geostan.GeoStanLoader;
import com.centrus.geostan.GeographicIterator;
import com.centrus.geostan.GeographicIteratorEx;
import com.centrus.geostan.GeographicQuery;
import com.centrus.geostan.GeographicQueryEx;
import com.centrus.geostan.InitProps;
import com.centrus.geostan.MinBoundingRect;
import com.centrus.geostan.NativeInput;
import com.centrus.geostan.NativeOutput;
import com.centrus.geostan.Range;
import com.centrus.geostan.Segment;
import com.centrus.geostan.SegmentIterator;
import com.centrus.geostan.StatusProps;
import com.centrus.geostan.Street;
import com.centrus.geostan.StreetIterator;
import java.io.File;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.collections.map.LRUMap;

public class GeoStan
extends GeoStanBase {
    private static GeoStanLoader m_gsLoader = new GeoStanLoader();
    private boolean bDpvInitialized = false;
    private boolean bLacsInitialized = false;
    private short findOptions = (short)1083;
    private short matchMode = (short)2;
    private short mixedCase = 0;
    private boolean streetCentroid = false;
    private short datum = 1;
    private long gsId = 0L;
    private short dataDate = 0;
    private short lastFindResult = (short)5;
    private String dataPaths;
    private String dpvLicenseKey;
    private String lacsLicenseKey;
    private int pw;
    private String pwFile;
    private boolean segmentByMbr = false;
    private long cityRecordNumber = 0L;
    private static final int maxPropsCacheSize = Integer.getInteger("geostan.findprops.cache.size", 1000);
    private static final String prefetchFieldsProperty = System.getProperty("geostan.prefetch.fields", "");
    private static final int[] prefetchFields = GeoStan.parsePrefetchFieldsProperty(prefetchFieldsProperty);
    private Map propsCache = new LRUMap(maxPropsCacheSize);
    private NativeInput nativeInput = new NativeInput();
    private NativeOutput nativeOutput = new NativeOutput();

    public GeoStan() {
    }

    public GeoStan(Properties props) throws GeoStanException {
        this.init(props);
    }

    public void init(Properties props) throws GeoStanException {
        if (!m_gsLoader.isLoaded()) {
            String libPath = props.getProperty("PATH");
            libPath = GeoStan.setupJavaLibPath(libPath);
            GeoStan.loadGeoStanLibs(libPath);
        }
        this.initClassicStyle(props);
    }

    public void init(InitProps initProps, StatusProps statusProps) throws GeoStanException {
        this.initPropertyStyle(initProps, statusProps);
    }

    public native boolean init(String var1, int var2, String var3) throws GeoStanException;

    public native boolean initProp(int[] var1, Object[] var2, int[] var3, Object[] var4) throws GeoStanException;

    public long getGsId() {
        return this.gsId;
    }

    public void term() {
        this.term(this.gsId);
        for (Map.Entry entry : this.propsCache.entrySet()) {
            try {
                GeoStan.closeFindProp((Long)entry.getValue());
            }
            catch (GeoStanException e) {
                throw new RuntimeException(e);
            }
        }
        this.propsCache.clear();
        this.bDpvInitialized = false;
        this.bLacsInitialized = false;
    }

    native void term(long var1);

    public void clear() {
        this.nativeInput.clear();
        this.nativeOutput.clear();
        this.clear(this.gsId);
    }

    native void clear(long var1);

    public short find() throws GeoStanException {
        this.nativeInput.makeSetDataCalls(this, this.gsId);
        this.lastFindResult = this.find(this.gsId, this.findOptions);
        return this.lastFindResult;
    }

    native short find(long var1, short var3) throws GeoStanException;

    public short find(FindProps findProps) throws GeoStanException {
        long fpHandle = this.lookupFindPropHandle(findProps);
        if (fpHandle == 0L) {
            return 1;
        }
        ByteBuffer inputBuf = this.nativeInput.getInputBuf();
        this.lastFindResult = this.findProp(this.gsId, fpHandle, inputBuf);
        if (prefetchFields != null) {
            this.prefetchData(prefetchFields);
        }
        return this.lastFindResult;
    }

    private long lookupFindPropHandle(FindProps findProps) throws GeoStanException {
        long fpHandle;
        Long tmpHandle = (Long)this.propsCache.get(findProps);
        if (tmpHandle == null) {
            int numFindElements = findProps.size();
            int[] findPropKeys = new int[numFindElements];
            Object[] findPropValues = new String[numFindElements];
            findProps.flattenProperties(findPropKeys, (String[])findPropValues);
            fpHandle = GeoStan.newFindProp(findPropKeys, findPropValues);
            if (fpHandle == 0L) {
                return fpHandle;
            }
            findProps.setHandle(fpHandle);
            findProps.m_bDirty = false;
            this.propsCache.put(new FindProps(findProps), new Long(fpHandle));
        } else {
            fpHandle = tmpHandle;
            findProps.setHandle(fpHandle);
        }
        return fpHandle;
    }

    native short findProp(long var1, long var3, ByteBuffer var5) throws GeoStanException;

    static native long newFindProp(int[] var0, Object[] var1) throws GeoStanException;

    static native void closeFindProp(long var0) throws GeoStanException;

    public void clearFindOptions() {
        this.findOptions = 0;
    }

    public void resetFindOptions() {
        this.findOptions = (short)1083;
    }

    public void setFindOption(short option, boolean on) throws GeoStanException {
        if (!GeoStanBase.Find.isValid(option)) {
            throw new GeoStanException("Invalid find option: " + option);
        }
        this.findOptions = GeoStanBase.Find.setOption(this.findOptions, option, on);
    }

    public boolean hasFindOption(short option) throws GeoStanException {
        if (!GeoStanBase.Find.isValid(option)) {
            throw new GeoStanException("Invalid find option: " + option);
        }
        return GeoStanBase.Find.hasOption(this.findOptions, option);
    }

    public short getFindOptions() {
        return this.findOptions;
    }

    short findFirstGeographic(GeographicQuery aGeoQuery) {
        this.lastFindResult = aGeoQuery instanceof GeographicQueryEx ? this.findGeographicFirstEx(this.gsId, aGeoQuery) : this.findGeographicFirst(this.gsId, aGeoQuery);
        return this.lastFindResult;
    }

    native short findGeographicFirst(long var1, GeographicQuery var3);

    native short findGeographicFirstEx(long var1, GeographicQuery var3);

    short findNextGeographic(GeographicQuery aGeoQuery) throws GeoStanException {
        this.lastFindResult = aGeoQuery instanceof GeographicQueryEx ? this.findGeographicNextEx(this.gsId, aGeoQuery) : this.findGeographicNext(this.gsId, aGeoQuery);
        return this.lastFindResult;
    }

    native short findGeographicNext(long var1, GeographicQuery var3);

    native short findGeographicNextEx(long var1, GeographicQuery var3);

    public void setData(String value, int element) throws GeoStanException {
        this.nativeInput.setData(value, (short)element);
    }

    native void setData(long var1, String var3, int var4) throws GeoStanException;

    public String getInputData(int element) throws GeoStanException {
        short id = (short)element;
        return this.nativeOutput.containsInputDataField(id) ? this.nativeOutput.getInputData(id) : this.getInputData(this.gsId, id);
    }

    native String getInputData(long var1, int var3) throws GeoStanException;

    public void prefetchData(int[] dataElements) throws GeoStanException {
        ByteBuffer dataBuf = this.nativeOutput.getDataBuf(dataElements);
        this.prefetchData(this.gsId, dataBuf);
        this.nativeOutput.setDataBuf(dataBuf);
    }

    public void prefetchInputData(int[] inputDataElements) throws GeoStanException {
        ByteBuffer inputDataBuf = this.nativeOutput.getInputDataBuf(inputDataElements);
        this.prefetchInputData(this.gsId, inputDataBuf);
        this.nativeOutput.setInputDataBuf(inputDataBuf);
    }

    public void prefetchCenterlineData(int[] centerlineDataElements) throws GeoStanException {
        ByteBuffer centerlineDataBuf = this.nativeOutput.getCenterlineDataBuf(centerlineDataElements);
        this.prefetchCenterlineData(this.gsId, centerlineDataBuf);
        this.nativeOutput.setCenterlineDataBuf(centerlineDataBuf);
    }

    public void prefetchMultipleData(int[] multipleDataElements, short index) throws GeoStanException {
        ByteBuffer multipleDataBuf = this.nativeOutput.getMultipleDataBuf(multipleDataElements, index);
        this.prefetchMultipleData(this.gsId, index, multipleDataBuf);
        this.nativeOutput.setMultipleDataBuf(multipleDataBuf, index);
    }

    private native void prefetchData(long var1, ByteBuffer var3) throws GeoStanException;

    private native void prefetchInputData(long var1, ByteBuffer var3) throws GeoStanException;

    private native void prefetchCenterlineData(long var1, ByteBuffer var3) throws GeoStanException;

    private native void prefetchMultipleData(long var1, short var3, ByteBuffer var4) throws GeoStanException;

    public String getCenterlineData(int element) throws GeoStanException {
        short id = (short)element;
        return this.nativeOutput.containsCenterlineDataField(id) ? this.nativeOutput.getCenterlineData(id) : this.getCenterlineData(this.gsId, id);
    }

    native String getCenterlineData(long var1, int var3) throws GeoStanException;

    public String getMultipleData(int element, short index) throws GeoStanException, IllegalArgumentException {
        short id = (short)element;
        return this.nativeOutput.containsMultipleDataField(id, index) ? this.nativeOutput.getMultipleData(id, index) : this.getMultipleData(this.gsId, element, index);
    }

    native String getMultipleData(long var1, int var3, short var4) throws GeoStanException, IllegalArgumentException;

    public String getData(int element) throws GeoStanException {
        short id = (short)element;
        return this.nativeOutput.containsDataField(id) ? this.nativeOutput.getData(id) : this.getData(this.gsId, id);
    }

    native String getData(long var1, int var3) throws GeoStanException;

    public short getNumMatches() {
        return this.getNumMatches(this.gsId, this.lastFindResult);
    }

    native short getNumMatches(long var1, short var3);

    public Range getRange(short index) throws GeoStanException, IllegalArgumentException {
        this.getRangeHandle(this.gsId, index);
        return new Range(this, 0);
    }

    native byte[] getRangeHandle(long var1, short var3) throws GeoStanException, IllegalArgumentException;

    public void select(short index) throws GeoStanException, IllegalArgumentException {
        if (prefetchFields != null) {
            throw new GeoStanException("select() method not compatible with geostan.prefetch.fields property.");
        }
        this.select(this.gsId, index);
    }

    native void select(long var1, short var3) throws GeoStanException, IllegalArgumentException;

    public void setMixedCase(boolean mixed) {
        this.mixedCase = mixed ? (short)1 : 0;
        this.setMixedCase(this.gsId, this.mixedCase);
    }

    native void setMixedCase(long var1, short var3);

    public boolean getMixedCase() {
        return this.mixedCase == 1;
    }

    public void setStreetCentroid(boolean setting) {
        this.streetCentroid = setting;
        this.setStreetCentroid(this.gsId, setting);
    }

    native void setStreetCentroid(long var1, boolean var3);

    public boolean getStreetCentroid() {
        return this.streetCentroid;
    }

    public void setMatchMode(short mode) throws GeoStanException {
        if (!GeoStanBase.MatchMode.isValid(mode) || !this.setMatchMode(this.gsId, mode)) {
            throw new GeoStanException("Invalid match mode: " + mode);
        }
        this.matchMode = mode;
    }

    native boolean setMatchMode(long var1, short var3) throws GeoStanException;

    public short getMatchMode() {
        return this.matchMode;
    }

    public void setDatum(short datum) throws GeoStanException {
        if (!GeoStanBase.Datum.isValid(datum)) {
            throw new GeoStanException("Invalid datum: " + datum);
        }
        this.setDatum(this.gsId, datum);
        this.datum = datum;
    }

    native void setDatum(long var1, short var3) throws GeoStanException;

    public short getDatum() {
        return this.datum;
    }

    public short getNumDB() {
        return this.getNumDB(this.gsId);
    }

    native short getNumDB(long var1);

    public String getDBMetadata(int mode, int db) throws GeoStanException {
        return this.getDBMetadata(this.gsId, mode, db);
    }

    native String getDBMetadata(long var1, int var3, int var4) throws GeoStanException;

    public long getDataSetStatus(short mode) throws GeoStanException {
        return this.getDataSetStatus(this.gsId, mode);
    }

    native long getDataSetStatus(long var1, short var3) throws GeoStanException;

    public static String getDataSetName(short dataTypeCode) throws IllegalArgumentException {
        return GeoStanBase.DataSetStatus.getDataTypeName(dataTypeCode);
    }

    public static String getDataSetDatum(short datumCode) throws IllegalArgumentException {
        return GeoStanBase.DataSetStatus.getDatumName(datumCode);
    }

    public static boolean hasDataSetStatus(long statusReturned, short flag) {
        return GeoStanBase.DataSetStatus.hasStatusFlag(statusReturned, flag);
    }

    public boolean isGSDDataPresent(String[] states) throws GeoStanException, IllegalArgumentException {
        return this.isGSDDataPresent(this.gsId, states);
    }

    native boolean isGSDDataPresent(long var1, String[] var3) throws GeoStanException, IllegalArgumentException;

    public native double getLibraryVersion() throws GeoStanException;

    public static long getSoundex(String name) {
        return new GeoStan().getSoundexKey(name);
    }

    public boolean isZ4Changed(String ZIP, String ZIP4, Date date) throws GeoStanException {
        SimpleDateFormat formatter = new SimpleDateFormat("MMyyyy");
        String dateString = formatter.format(date);
        return this.isZ4Changed(this.gsId, ZIP, ZIP4, dateString);
    }

    native boolean isZ4Changed(long var1, String var3, String var4, String var5) throws GeoStanException;

    public Coordinate[] getCoords() {
        long[] longCoords;
        try {
            longCoords = this.getLongCoords(this.gsId);
        }
        catch (GeoStanException ex) {
            return new Coordinate[0];
        }
        return this.getTrueCoords(longCoords);
    }

    native long[] getLongCoords(long var1) throws GeoStanException;

    public StreetIterator createStreetIterator(short option, String locale, String name, String number) {
        return new StreetIterator(this, option, locale, name, number);
    }

    public StreetIterator createStreetIterator(short option, String locale, long soundexKey, String number) {
        return new StreetIterator(this, option, locale, String.valueOf(soundexKey), number);
    }

    public CityIterator createCityIterator(String state, String cityPattern) {
        return new CityIterator(this, state, cityPattern);
    }

    public boolean prepareIndex(MinBoundingRect mbr, String indexDirectory) throws GeoStanException {
        return this.prepareIndexMbr(this.gsId, mbr.getMinCoord().getLongitude(), mbr.getMinCoord().getLatitude(), mbr.getMaxCoord().getLongitude(), mbr.getMaxCoord().getLatitude(), indexDirectory);
    }

    native boolean prepareIndexMbr(long var1, double var3, double var5, double var7, double var9, String var11) throws GeoStanException;

    public boolean prepareIndex(String qcity, String indexDirectory) throws GeoStanException {
        if (qcity == null || qcity.length() < 6) {
            throw new GeoStanException("Invalid QCity = " + qcity);
        }
        int finance = 0;
        try {
            finance = Integer.parseInt(qcity.substring(0, 6));
        }
        catch (NumberFormatException ex) {
            throw new GeoStanException("Invalid QCity = " + qcity);
        }
        if (!this.prepareIndexFinance(this.gsId, finance, indexDirectory)) {
            return false;
        }
        if (this.dataPaths.toLowerCase().indexOf(indexDirectory.toLowerCase()) == -1) {
            String msg = new String("Index Preparation succeeded.  However, index directory: '" + indexDirectory + "' is not in the data search path: '" + this.dataPaths + "' " + "(so no MBRs for cities are possible).");
            throw new GeoStanException(msg.toString());
        }
        return true;
    }

    native boolean prepareIndexFinance(long var1, int var3, String var4) throws GeoStanException;

    public SegmentIterator createSegmentIterator(MinBoundingRect mbr) {
        return new SegmentIterator(this, mbr);
    }

    public boolean hasMessage() {
        return this.hasMessage(this.gsId);
    }

    native boolean hasMessage(long var1);

    public StringBuffer readMessages() throws GeoStanException {
        StringBuffer sb = new StringBuffer();
        while (this.hasMessage(this.gsId)) {
            String[] msg = this.getMessage();
            sb.append(msg[0] + ": " + msg[1] + "\n");
        }
        return sb;
    }

    public String[] getMessage() throws GeoStanException {
        return this.getMessage(this.gsId);
    }

    native String[] getMessage(long var1) throws GeoStanException;

    public String findFirstState(String statePattern) throws GeoStanException {
        return this.findFirstState(this.gsId, statePattern);
    }

    native String findFirstState(long var1, String var3) throws GeoStanException;

    public MinBoundingRect getMinBoundingRect(String qcity) throws GeoStanException {
        long[] coords = this.getLongMbrFromCity(this.gsId, qcity);
        return this.coordsToMbr(coords);
    }

    native long[] getLongMbrFromCity(long var1, String var3) throws GeoStanException;

    public boolean initDpv() throws GeoStanException {
        return this.initDpv(this.firstPath(), this.dpvLicenseKey);
    }

    public boolean initDpv(String dataDirectory, String securityKey) throws GeoStanException {
        if (!this.bDpvInitialized) {
            DPVInit dpvInit = new DPVInit();
            dpvInit.structVersion = (int)this.getLibraryVersion();
            dpvInit.pDirectory = dataDirectory;
            dpvInit.securityKey = securityKey;
            dpvInit.structVersion = 20;
            dpvInit.memoryBufferSize = 50;
            dpvInit.Status = -999;
            this.bDpvInitialized = this.initDpv(dpvInit);
        }
        return this.bDpvInitialized;
    }

    public boolean initDpv(DPVInit dpvInit) throws GeoStanException {
        return this.initDpv(this.gsId, dpvInit);
    }

    native boolean initDpv(long var1, DPVInit var3) throws GeoStanException;

    public void getDpvFalsePosHeaderStats(FalsePositiveHeader falsePositive) throws GeoStanException {
        this.getDpvFalsePosHeaderStats(this.gsId, falsePositive);
    }

    native void getDpvFalsePosHeaderStats(long var1, FalsePositiveHeader var3) throws GeoStanException;

    public FalsePositiveHeader getDpvFalsePosHeaderStats() throws GeoStanException {
        FalsePositiveHeader header = new FalsePositiveHeader();
        this.getDpvFalsePosHeaderStats(header);
        return header;
    }

    public String formatDpvFalsePosHeader(FalsePositiveHeader falsePositive) throws GeoStanException {
        return this.formatDpvFalsePosHeader(this.gsId, falsePositive);
    }

    native String formatDpvFalsePosHeader(long var1, FalsePositiveHeader var3) throws GeoStanException;

    public void getDpvFalsePosDetail(FalsePositiveDetail falsePositive) throws GeoStanException {
        this.getDpvFalsePosDetail(this.gsId, falsePositive);
    }

    native void getDpvFalsePosDetail(long var1, FalsePositiveDetail var3) throws GeoStanException;

    public FalsePositiveDetail getDpvFalsePosDetail() throws GeoStanException {
        FalsePositiveDetail detail = new FalsePositiveDetail();
        this.getDpvFalsePosDetail(detail);
        return detail;
    }

    public String formatDpvFalsePosDetail(FalsePositiveDetail falsePositive) throws GeoStanException {
        return this.formatDpvFalsePosDetail(this.gsId, falsePositive);
    }

    native String formatDpvFalsePosDetail(long var1, FalsePositiveDetail var3) throws GeoStanException;

    public void getDpvCompleteStats(DPVCompleteStats statsDPV) throws GeoStanException {
        this.getDpvCompleteStats(this.gsId, statsDPV);
    }

    native void getDpvCompleteStats(long var1, DPVCompleteStats var3) throws GeoStanException;

    public boolean initLACSLink() throws GeoStanException {
        return this.initLACSLink(this.firstPath(), this.lacsLicenseKey);
    }

    public boolean initLACSLink(String dataDirectory, String securityKey) throws GeoStanException {
        if (!this.bLacsInitialized) {
            LACSLinkInit lacsInit = new LACSLinkInit();
            lacsInit.structVersion = (int)this.getLibraryVersion();
            lacsInit.pDirectory = dataDirectory;
            lacsInit.securityKey = securityKey;
            this.bLacsInitialized = this.initLACSLink(lacsInit);
        }
        return this.bLacsInitialized;
    }

    public boolean initLACSLink(LACSLinkInit lacsLinkInit) throws GeoStanException {
        return this.initLACSLink(this.gsId, lacsLinkInit);
    }

    native boolean initLACSLink(long var1, LACSLinkInit var3) throws GeoStanException;

    public void getLACSFalsePosHeaderStats(FalsePositiveHeader falsePositive) throws GeoStanException {
        this.getLACSFalsePosHeaderStats(this.gsId, falsePositive);
    }

    native void getLACSFalsePosHeaderStats(long var1, FalsePositiveHeader var3) throws GeoStanException;

    public FalsePositiveHeader getLACSFalsePosHeaderStats() throws GeoStanException {
        FalsePositiveHeader header = new FalsePositiveHeader();
        this.getLACSFalsePosHeaderStats(header);
        return header;
    }

    public String formatLACSFalsePosHeader(FalsePositiveHeader falsePositive) throws GeoStanException {
        return this.formatLACSFalsePosHeader(this.gsId, falsePositive);
    }

    native String formatLACSFalsePosHeader(long var1, FalsePositiveHeader var3) throws GeoStanException;

    public void getLACSFalsePosDetail(FalsePositiveDetail falsePositive) throws GeoStanException {
        this.getLACSFalsePosDetail(this.gsId, falsePositive);
    }

    native void getLACSFalsePosDetail(long var1, FalsePositiveDetail var3) throws GeoStanException;

    public FalsePositiveDetail getLACSFalsePosDetail() throws GeoStanException {
        FalsePositiveDetail detail = new FalsePositiveDetail();
        this.getLACSFalsePosDetail(detail);
        return detail;
    }

    public String formatLACSFalsePosDetail(FalsePositiveDetail falsePositive) throws GeoStanException {
        return this.formatLACSFalsePosDetail(this.gsId, falsePositive);
    }

    native String formatLACSFalsePosDetail(long var1, FalsePositiveDetail var3) throws GeoStanException;

    public void getLACSCompleteStats(LACSCompleteStats statsLACS) throws GeoStanException {
        this.getLACSCompleteStats(this.gsId, statsLACS);
    }

    native void getLACSCompleteStats(long var1, LACSCompleteStats var3) throws GeoStanException;

    public void writeCASSReport(CASSData data, String outputName) throws GeoStanException {
        this.writeCASSReport(this.gsId, data, outputName);
    }

    native void writeCASSReport(long var1, CASSData var3, String var4) throws GeoStanException;

    public String formatCASSHeader(CASSData data) throws GeoStanException {
        return this.formatCASSHeader(this.gsId, data);
    }

    native String formatCASSHeader(long var1, CASSData var3) throws GeoStanException;

    String getDpvSecurityKey() {
        return this.dpvLicenseKey;
    }

    String getLACSSecurityKey() {
        return this.lacsLicenseKey;
    }

    public String getDataPaths() {
        return this.dataPaths;
    }

    public boolean isDpvInitialized() {
        return this.bDpvInitialized;
    }

    public boolean isLACSLinkInitialized() {
        return this.bLacsInitialized;
    }

    public boolean reInit() throws GeoStanException {
        this.term();
        return this.init(this.pwFile, this.pw, this.dataPaths);
    }

    public boolean reInit(InitProps initProps, StatusProps statusProps) throws GeoStanException {
        this.term();
        initProps.set(22, 0);
        return this.initPropertyStyle(initProps, statusProps);
    }

    public boolean verifyAuxiliaryRecord(String record) throws GeoStanException {
        return this.verifyAuxiliaryRecord(this.gsId, record);
    }

    native boolean verifyAuxiliaryRecord(long var1, String var3) throws GeoStanException;

    public boolean getConfidenceInfo(ConfidenceInfo confInfo) throws GeoStanException {
        return this.getConfidenceInfo(this.gsId, confInfo);
    }

    native boolean getConfidenceInfo(long var1, ConfidenceInfo var3) throws GeoStanException;

    public Coordinate[] getCoordsFromLastFind() throws GeoStanException {
        return this.getFindCoords();
    }

    Coordinate[] getFindCoords() throws GeoStanException {
        long[] longCoords;
        try {
            longCoords = this.getLongCoordsFromFind(this.gsId);
        }
        catch (GeoStanException ex) {
            return new Coordinate[0];
        }
        return this.getTrueCoords(longCoords);
    }

    native long[] getLongCoordsFromFind(long var1) throws GeoStanException;

    Coordinate[] getTrueCoords(long[] longCoords) {
        if (longCoords.length < 2) {
            return new Coordinate[0];
        }
        Coordinate[] coords = new Coordinate[longCoords.length / 2];
        double denominator = Math.abs(longCoords[0]) > 20000000L ? 1000000.0 : (Math.abs(longCoords[0]) > 2000000L ? 100000.0 : 10000.0);
        for (int i = 0; i < longCoords.length; i += 2) {
            coords[i / 2] = new Coordinate((double)longCoords[i] / denominator, (double)longCoords[i + 1] / denominator);
        }
        return coords;
    }

    protected void finalize() {
        this.term();
    }

    synchronized Street findFirstStreet(short option, String locale, String name, String number) throws GeoStanException {
        return this.firstStreet(option, locale, name, number) ? new Street(this, 0, null) : new Street(this);
    }

    boolean firstStreet(short option, String locale, String name, String number) throws GeoStanException {
        return this.firstStreetHandle(this.gsId, option, locale, name, number);
    }

    boolean firstStreet(short option, String locale, long soundexKey, String number) throws GeoStanException {
        return this.firstStreet(option, locale, String.valueOf(soundexKey), number);
    }

    native boolean firstStreetHandle(long var1, short var3, String var4, String var5, String var6) throws GeoStanException;

    Street findNextStreet(Street prevStreet) throws GeoStanException {
        return this.nextStreet() ? new Street(this, 0, null) : new Street(this);
    }

    boolean nextStreet() throws GeoStanException {
        return this.nextStreetHandle(this.gsId);
    }

    native boolean nextStreetHandle(long var1) throws GeoStanException;

    String getStreetData(Street street, int element) throws GeoStanException {
        return this.getStreetData(element);
    }

    String getStreetData(int element) throws GeoStanException {
        return this.getStreetHandleData(this.gsId, element);
    }

    native String getStreetHandleData(long var1, int var3) throws GeoStanException;

    MinBoundingRect getMinBoundingRectFromStreet(Street street) throws GeoStanException {
        return this.getStreetMinBoundingRect();
    }

    MinBoundingRect getStreetMinBoundingRect() throws GeoStanException {
        long[] coords = this.getLongMbrFromStreetHandle(this.gsId);
        return this.coordsToMbr(coords);
    }

    native long[] getLongMbrFromStreetHandle(long var1) throws GeoStanException;

    Segment findFirstSegment(Street street) throws GeoStanException {
        return this.firstSegment() ? new Segment(this, 0) : new Segment(this);
    }

    boolean firstSegment() throws GeoStanException {
        this.segmentByMbr = false;
        return this.firstSegmentHandle(this.gsId);
    }

    native boolean firstSegmentHandle(long var1) throws GeoStanException;

    Segment findNextSegment(Segment prevSegment) throws GeoStanException {
        return this.nextSegment() ? new Segment(this, 0) : new Segment(this);
    }

    boolean nextSegment() throws GeoStanException {
        if (this.segmentByMbr) {
            return this.nextSegmentHandleByMbr(this.gsId);
        }
        return this.nextSegmentHandle(this.gsId);
    }

    native boolean nextSegmentHandle(long var1) throws GeoStanException;

    Segment findFirstSegmentByMbr(MinBoundingRect mbr) throws GeoStanException {
        return this.firstSegment(mbr) ? new Segment(this, 0) : new Segment(this);
    }

    boolean firstSegment(MinBoundingRect mbr) throws GeoStanException {
        this.segmentByMbr = true;
        return this.firstSegmentHandlebyMbr(this.gsId, mbr.getMinCoord().getLongitude(), mbr.getMinCoord().getLatitude(), mbr.getMaxCoord().getLongitude(), mbr.getMaxCoord().getLatitude());
    }

    native boolean firstSegmentHandlebyMbr(long var1, double var3, double var5, double var7, double var9) throws GeoStanException;

    Segment findNextSegmentByMbr(Segment prevSegment) throws GeoStanException {
        return this.nextSegment() ? new Segment(this, 0) : new Segment(this);
    }

    native boolean nextSegmentHandleByMbr(long var1) throws GeoStanException;

    String getSegmentData(Segment segment, int element) throws GeoStanException {
        return this.getSegmentData(element);
    }

    String getSegmentData(int element) throws GeoStanException {
        return this.getSegmentHandleData(this.gsId, element);
    }

    native String getSegmentHandleData(long var1, int var3) throws GeoStanException;

    MinBoundingRect getMinBoundingRectFromSegment(Segment segment) throws GeoStanException {
        return this.getSegmentMinBoundingRect();
    }

    MinBoundingRect getSegmentMinBoundingRect() throws GeoStanException {
        long[] coords = this.getLongMbrFromSegmentHandle(this.gsId);
        return this.coordsToMbr(coords);
    }

    native long[] getLongMbrFromSegmentHandle(long var1) throws GeoStanException;

    Coordinate[] getCoordsFromSegment(Segment segment) throws GeoStanException {
        return this.getSegmentCoords();
    }

    Coordinate[] getSegmentCoords() throws GeoStanException {
        long[] longCoords;
        try {
            longCoords = this.getLongCoordsFromSegmentHandle(this.gsId);
        }
        catch (GeoStanException ex) {
            return new Coordinate[0];
        }
        return this.getTrueCoords(longCoords);
    }

    native long[] getLongCoordsFromSegmentHandle(long var1) throws GeoStanException;

    Range findFirstRange(Segment segment) throws GeoStanException {
        return this.firstRange() ? new Range(this, 0) : new Range(this);
    }

    boolean firstRange() throws GeoStanException {
        return this.firstRangeHandle(this.gsId);
    }

    native boolean firstRangeHandle(long var1) throws GeoStanException;

    Range findNextRange(Range prevRange) throws GeoStanException {
        return this.nextRange() ? new Range(this, 0) : new Range(this);
    }

    boolean nextRange() throws GeoStanException {
        return this.nextRangeHandle(this.gsId);
    }

    native boolean nextRangeHandle(long var1) throws GeoStanException;

    String getRangeData(Range range, int element) throws GeoStanException {
        return this.getRangeData(element);
    }

    String getRangeData(int element) throws GeoStanException {
        return this.getRangeHandleData(this.gsId, element);
    }

    native String getRangeHandleData(long var1, int var3) throws GeoStanException;

    boolean testRange(String number, String low, String high) throws GeoStanException {
        return this.testRange(this.gsId, number, low, high);
    }

    native boolean testRange(long var1, String var3, String var4, String var5) throws GeoStanException;

    boolean isWithinRange(String number) throws GeoStanException {
        return this.testRange(number, this.getRangeData(16), this.getRangeData(8));
    }

    boolean selectRange(Range range, short findOptions) throws GeoStanException {
        return this.setSelectionRange(findOptions);
    }

    boolean setSelectionRange(short findOptions) throws GeoStanException {
        return this.selectRangeHandle(this.gsId, findOptions);
    }

    native boolean selectRangeHandle(long var1, short var3) throws GeoStanException;

    City findFirstCity(String state, String cityPattern) throws GeoStanException {
        return this.firstCity(state, cityPattern) ? new City(this, this.cityRecordNumber) : new City(this);
    }

    boolean firstCity(String state, String cityPattern) throws GeoStanException {
        this.cityRecordNumber = this.findFirstCityRecord(this.gsId, state, cityPattern);
        return this.cityRecordNumber != 0L;
    }

    native long findFirstCityRecord(long var1, String var3, String var4) throws GeoStanException;

    City findNextCity() throws GeoStanException {
        return this.nextCity() ? new City(this, this.cityRecordNumber) : new City(this);
    }

    boolean nextCity() throws GeoStanException {
        this.cityRecordNumber = this.findNextCityRecord(this.gsId);
        return this.cityRecordNumber != 0L;
    }

    native long findNextCityRecord(long var1) throws GeoStanException;

    String getCityData(City city, int element) throws GeoStanException {
        return this.getCityData(element);
    }

    String getCityData(int element) throws GeoStanException {
        return this.getCityRecordData(this.gsId, this.cityRecordNumber, element);
    }

    native String getCityRecordData(long var1, long var3, int var5) throws GeoStanException;

    long getCityRecordNumber() {
        return this.cityRecordNumber;
    }

    public GeographicIterator createGeographicIterator(String city, String county, String state) {
        return new GeographicIterator(this, city, county, state);
    }

    public GeographicIteratorEx createGeographicIteratorEx(String city, String county, String state, long geostanVer) {
        return new GeographicIteratorEx(this, city, county, state, geostanVer);
    }

    static native int getCASSDataSize();

    static native int getDPVCompleteStatsSize();

    static native int getDPVInitSize();

    static native int getFalsePositiveDetailSize();

    static native int getFalsePositiveHeaderSize();

    static native int getLACSCompleteStatsSize();

    static native int getLACSLinkInitSize();

    private void initClassicStyle(Properties props) throws GeoStanException {
        this.setupLicenseAndPassword(props);
        String dataPaths = props.getProperty("DataPath");
        String dataPathAlias = props.getProperty("DataSet");
        String geoDataPath = this.extractDataPath(dataPathAlias, dataPaths);
        if (geoDataPath.length() == 0) {
            throw new GeoStanException("Unable to find GeoStan data path for logical name: " + dataPathAlias);
        }
        if (this.pw == 0 || geoDataPath == null) {
            String msg = new String("Unable to Initialize Geostan from input Properties.\n");
            msg = msg + "\tLicense = " + this.pwFile + "\n";
            msg = msg + "\tPassword = " + this.pw + " (original string = " + this.pw + ")\n";
            msg = msg + "\tDataPath = " + geoDataPath;
            throw new GeoStanException(msg);
        }
        this.init(this.pwFile, this.pw, geoDataPath);
        this.dpvLicenseKey = props.getProperty("DpvLicenseKey");
        this.lacsLicenseKey = props.getProperty("LacsLicenseKey");
    }

    private boolean initPropertyStyle(InitProps initProps, StatusProps statusProps) throws GeoStanException {
        int numInitElements = initProps.size();
        int[] initPropIDs = new int[numInitElements];
        Object[] initPropValues = new String[numInitElements];
        initProps.flattenProperties(initPropIDs, (String[])initPropValues);
        int[] statusPropIDs = new int[33];
        Object[] statusPropValues = new String[33];
        boolean retVal = this.initProp(initPropIDs, initPropValues, statusPropIDs, statusPropValues);
        if (retVal && this.gsId > 0L) {
            initProps.set(25, this.gsId);
            if (System.getProperty("os.arch").indexOf("x86") >= 0) {
                initProps.set(22, (int)this.gsId);
            } else {
                initProps.set(22, 1);
            }
        }
        statusProps.reconstituteProperties(statusPropIDs, (String[])statusPropValues);
        return retVal;
    }

    static String setupJavaLibPath(String libPath) {
        if (libPath != null) {
            File libFile = new File(libPath);
            libPath = libFile.getAbsolutePath();
            String jlp = System.getProperty("java.library.path");
            if (jlp != null) {
                System.setProperty("java.library.path", libPath + File.pathSeparator + jlp);
            } else {
                System.setProperty("java.library.path", libPath);
            }
        }
        return libPath;
    }

    public static void loadGeoStanLibs(String libPath) throws GeoStanException {
        m_gsLoader.loadGeoStanLibrary(libPath);
    }

    private void setupLicenseAndPassword(Properties props) {
        String password = props.getProperty("Password");
        if (password != null) {
            try {
                NumberFormat nf = NumberFormat.getInstance();
                nf.setParseIntegerOnly(true);
                this.pw = nf.parse(password).intValue();
            }
            catch (ParseException pe) {
                this.pw = 0;
            }
        }
        this.pwFile = props.getProperty("License");
    }

    private String extractDataPath(String dataPathAlias, String rawDataPaths) {
        String dataPaths = new String("");
        for (int i = 0; i < rawDataPaths.length(); ++i) {
            char c = rawDataPaths.charAt(i);
            if (c == '\"' || c == '\'') continue;
            dataPaths = dataPaths + c;
        }
        if (dataPathAlias != null && dataPathAlias.length() > 2 && dataPathAlias.charAt(0) == '\"' && dataPathAlias.charAt(dataPathAlias.length() - 1) == '\"') {
            dataPathAlias = dataPathAlias.substring(1, dataPathAlias.length() - 1);
        }
        StringTokenizer strTok = new StringTokenizer(dataPaths, "|", false);
        while (strTok.hasMoreElements()) {
            String pathElement = (String)strTok.nextElement();
            try {
                String alias;
                int right;
                int left = (pathElement = pathElement.trim()).indexOf(91);
                if (left < 0 || (right = pathElement.indexOf(93, left)) <= left || !(alias = pathElement.substring(left + 1, right)).equals(dataPathAlias)) continue;
                return pathElement.substring(right + 1, pathElement.length());
            }
            catch (Exception ex) {
            }
        }
        return new String("");
    }

    private native long getSoundexKey(String var1);

    private String firstPath() {
        if (this.dataPaths == null || this.dataPaths.equals("")) {
            return "";
        }
        int semi = this.dataPaths.indexOf(59);
        return semi < 0 ? this.dataPaths : this.dataPaths.substring(0, semi);
    }

    private MinBoundingRect coordsToMbr(long[] coords) {
        Coordinate min = new Coordinate((double)coords[0] / 10000.0, (double)coords[1] / 10000.0);
        Coordinate max = new Coordinate((double)coords[2] / 10000.0, (double)coords[3] / 10000.0);
        return new MinBoundingRect(min, max);
    }

    private static int[] parsePrefetchFieldsProperty(String prefetchFieldsProperty) {
        if (prefetchFieldsProperty == null || prefetchFieldsProperty.length() == 0) {
            return null;
        }
        String[] fieldNames = prefetchFieldsProperty.split("\\s*,\\s*");
        int count = fieldNames.length;
        int[] retValue = new int[count];
        int badFieldCount = 0;
        for (int index = 0; index < count; ++index) {
            Short id = (Short)FIELD_IDS.get(fieldNames[index]);
            if (id != null) {
                retValue[index - badFieldCount] = id.intValue();
                continue;
            }
            ++badFieldCount;
        }
        if (badFieldCount > 0) {
            int[] tmpFields = retValue;
            int newCount = count - badFieldCount;
            retValue = new int[newCount];
            System.arraycopy(tmpFields, 0, retValue, 0, newCount);
        }
        return retValue;
    }
}

