/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class GeoStanBase {
    public static final String LICENSE = "License";
    public static final String PASSWORD = "Password";
    public static final String DATA_PATH = "DataPath";
    public static final String DATA_SET = "DataSet";
    public static final String DPV_LICENSE_KEY = "DpvLicenseKey";
    public static final String LACS_LICENSE_KEY = "LacsLicenseKey";
    public static final int ADDRLINE = 1;
    public static final int BLOCK = 2;
    public static final int CART = 3;
    public static final int CHECK_DIGIT = 4;
    public static final int CITY = 5;
    public static final int DIST = 6;
    public static final int DPBC = 7;
    public static final int HIRANGE = 8;
    public static final int HOUSE_NUMBER = 9;
    public static final int HOUSE_NUMBER2 = 566;
    public static final int LAST_LINE = 10;
    public static final int LAT = 11;
    public static final int LOC_CODE = 14;
    public static final int LON = 15;
    public static final int LORANGE = 16;
    public static final int MATCH_CODE = 17;
    public static final int MM_RESULT_CODE = 19;
    public static final int NAME = 20;
    public static final int NAME2 = 21;
    public static final int POSTDIR = 22;
    public static final int POSTDIR2 = 23;
    public static final int PREDIR = 24;
    public static final int PREDIR2 = 25;
    public static final int STATE = 26;
    public static final int TYPE = 27;
    public static final int TYPE2 = 28;
    public static final int UNIT_NUMBER = 29;
    public static final int UNIT_TYPE = 30;
    public static final int ZIP = 31;
    public static final int ZIP4 = 32;
    public static final int ZIP9 = 33;
    public static final int ZIP10 = 34;
    public static final int INTERSECTION = 35;
    public static final int HIUNIT = 36;
    public static final int LOUNIT = 37;
    public static final int SCORE = 38;
    public static final int STREET_SIDE = 39;
    public static final int SEGMENT_PARITY = 40;
    public static final int RANGE_PARITY = 41;
    public static final int BLOCK_LEFT = 42;
    public static final int BLOCK_RIGHT = 43;
    public static final int SEGMENT_DIRECTION = 44;
    public static final int LOZIP4 = 45;
    public static final int HIZIP4 = 46;
    public static final int MSA = 47;
    public static final int CMSA = 48;
    public static final int MSA_NUMBER = 52;
    public static final int CMSA_NUMBER = 53;
    public static final int REC_TYPE = 57;
    public static final int CTYST_KEY = 58;
    public static final int FIRM_NAME = 59;
    public static final int SEG_LORANGE = 60;
    public static final int SEG_HIRANGE = 61;
    public static final int URB_NAME = 62;
    public static final int QCITY = 63;
    public static final int COUNTY = 64;
    public static final int COUNTY_FIPS = 64;
    public static final int COUNTY_NAME = 65;
    public static final int ROAD_CLASS = 66;
    public static final int IS_ALIAS = 67;
    public static final int LINE1 = 68;
    public static final int LINE2 = 69;
    public static final int LINE3 = 70;
    public static final int LINE4 = 71;
    public static final int LINE5 = 72;
    public static final int LINE6 = 73;
    public static final int LOT_CODE = 74;
    public static final int LOT_NUM = 75;
    public static final int LACS_FLAG = 76;
    public static final int GOVT_FLAG = 77;
    public static final int ALT_FLAG = 78;
    public static final int ZIP_CLASS = 79;
    public static final int ZIP_FACILITY = 80;
    public static final int ZIP_CITY_DELV = 81;
    public static final int ZIP_CARRT_SORT = 82;
    public static final int ZIP_UNIQUE = 83;
    public static final int MAIL_STOP = 84;
    public static final int ADDR2 = 85;
    public static final int RESOLVED_LINE = 87;
    public static final int SEG_LENGTH = 86;
    public static final int PMB_DESIGNATOR = 88;
    public static final int PMB_NUMBER = 89;
    public static final int HI_RISE_DFLT = 98;
    public static final int R_RTE_DFLT = 99;
    public static final int DFLT = 100;
    public static final int USE_ALIAS = 256;
    public static final int UNIT_NUMBER2 = 512;
    public static final int UNIT_TYPE2 = 513;
    public static final int PREF_CITY = 514;
    public static final int NAME_CITY = 515;
    public static final int EWS_MATCH = 516;
    public static final int SEGMENT_ID = 517;
    public static final int BLOCK_SFX = 518;
    public static final int BLOCK_SFX_LEFT = 519;
    public static final int BLOCK_SFX_RIGHT = 520;
    public static final int CBSA_NUMBER = 521;
    public static final int CBSA_NAME = 522;
    public static final int CSA_NUMBER = 523;
    public static final int CSA_NAME = 524;
    public static final int CBSA_DIVISION_NUMBER = 525;
    public static final int CBSA_DIVISION_NAME = 526;
    public static final int METRO_FLAG = 527;
    public static final int DPV_CONFIRM = 528;
    public static final int DPV_CMRA = 529;
    public static final int DPV_FALSE_POS = 530;
    public static final int DPV_FOOTNOTE1 = 531;
    public static final int DPV_FOOTNOTE2 = 532;
    public static final int DPV_FOOTNOTE3 = 533;
    public static final int DPV_FOOTNOTE4 = 534;
    public static final int DPV_FOOTNOTE5 = 535;
    public static final int DPV_FOOTNOTE6 = 536;
    public static final int UNIT_RANGE_PARITY = 537;
    public static final int LACSLINK_IND = 538;
    public static final int LACSLINK_RETCODE = 539;
    public static final int DATATYPE = 540;
    public static final int POINT_ID = 541;
    public static final int SEARCH_DIST = 542;
    public static final int SQUEEZE_DIST = 543;
    public static final int NEAREST_DIST = 544;
    public static final int PERCENT_GEOCODE = 545;
    public static final int OFFSET_DIST = 546;
    public static final int AUX_USERDATA = 547;
    public static final int MCD_NAME = 548;
    public static final int MCD_NUMBER = 549;
    public static final int BEARING = 550;
    public static final int APN_ID = 551;
    public static final int PARCEN_ELEVATION = 552;
    public static final int STATE_FIPS = 553;
    public static final int CENTERLINE_OFFSET_DIST = 554;
    public static final int CITY_SHORT = 555;
    public static final int LASTLINE_SHORT = 556;
    public static final int ADDRLINE_SHORT = 557;
    public static final int NAME_SHORT = 558;
    public static final int PREDIR_SHORT = 559;
    public static final int POSTDIR_SHORT = 560;
    public static final int TYPE_SHORT = 561;
    public static final int NAME2_SHORT = 562;
    public static final int PREDIR2_SHORT = 563;
    public static final int POSTDIR2_SHORT = 564;
    public static final int TYPE2_SHORT = 565;
    public static final int CLOSE_MATCH = 567;
    public static final int SUITELINK_RET_CODE = 568;
    public static final int DPV_VACANT = 569;
    public static final int DPV_NO_STAT = 570;
    public static final int MATCHED_DB = 571;
    public static final int DPV_SHUTDOWN = 572;
    public static final int LACSLINK_SHUTDOWN = 573;
    public static final int SEGMENT_ID2 = 574;
    public static final int SEG_LORANGE2 = 575;
    public static final int SEG_HIRANGE2 = 576;
    public static final int SEGMENT_PARITY2 = 577;
    public static final int SEGMENT_DIRECTION2 = 578;
    public static final int BLOCK_LEFT2 = 579;
    public static final int BLOCK_RIGHT2 = 580;
    public static final int BLOCK_SFX_LEFT2 = 581;
    public static final int BLOCK_SFX_RIGHT2 = 582;
    public static final int ROAD_CLASS2 = 583;
    public static final int COUNTY2 = 584;
    public static final int COUNTY_NAME2 = 585;
    public static final int CBSA_NUMBER2 = 586;
    public static final int CBSA_NAME2 = 587;
    public static final int CSA_NUMBER2 = 588;
    public static final int CSA_NAME2 = 589;
    public static final int CBSA_DIVISION_NUMBER2 = 590;
    public static final int CBSA_DIVISION_NAME2 = 591;
    public static final int METRO_FLAG2 = 592;
    public static final int DATATYPE2 = 593;
    public static final int USPS_ID = 594;
    public static final int PB_KEY = 595;
    public static final short STATUS_SUCCESS = 0;
    public static final short STATUS_ERROR = 1;
    public static final short STATUS_ADDRESS_NOT_FOUND = 2;
    public static final short STATUS_ADDRESS_NOT_RESOLVED = 4;
    public static final short STATUS_LASTLINE_NOT_FOUND = 3;
    public static final short STATUS_NOT_FOUND = 5;
    public static final short STATUS_ERROR_SPECIAL = 6;
    public static final short STATUS_WARNING = 8;
    public static final short STATUS_GSD_DATA_MISSING = 9;
    public static final int LOC_POINT_PARCEL = 2;
    public static final int LOC_POINT_GPS = 4;
    public static final int LOC_POINT_STRUCTURE = 5;
    public static final int LOC_POINT_MANUAL = 7;
    public static final int LOC_POINT_FRONT_DOOR = 8;
    public static final int LOC_POINT_DRIVEWAY_OFFSET = 9;
    public static final int LOC_POINT_STREET_ACCESS = 10;
    public static final int LOC_POINT_BASE_PARCEL = 21;
    public static final int LOC_POINT_PARCEL_BACKFILL = 22;
    public static final int LOC_POINT_VIRTUAL = 23;
    public static final int LOC_POINT_INFERRED_BACKFILL = 24;
    private static final Map fieldLengths = new HashMap(200);
    private static final Map fieldIds = new HashMap(200);
    static final Map FIELD_LENGTHS;
    static final Map FIELD_IDS;

    static short getFieldLength(int element) {
        Short id = new Short((short)element);
        Short length = (Short)fieldLengths.get(id);
        if (length == null) {
            throw new IllegalArgumentException("Illegal field ID: " + element);
        }
        return length;
    }

    private static void putFieldLength(int element, int length) {
        fieldLengths.put(new Short((short)element), new Short((short)length));
    }

    private static void putFieldName(int element, String name) {
        Short id = new Short((short)element);
        fieldIds.put(name, id);
    }

    static {
        GeoStanBase.putFieldLength(1, 256);
        GeoStanBase.putFieldLength(2, 16);
        GeoStanBase.putFieldLength(3, 5);
        GeoStanBase.putFieldLength(4, 2);
        GeoStanBase.putFieldLength(5, 29);
        GeoStanBase.putFieldLength(6, 11);
        GeoStanBase.putFieldLength(7, 3);
        GeoStanBase.putFieldLength(8, 12);
        GeoStanBase.putFieldLength(9, 12);
        GeoStanBase.putFieldLength(566, 12);
        GeoStanBase.putFieldLength(10, 61);
        GeoStanBase.putFieldLength(11, 11);
        GeoStanBase.putFieldLength(14, 5);
        GeoStanBase.putFieldLength(15, 12);
        GeoStanBase.putFieldLength(16, 12);
        GeoStanBase.putFieldLength(17, 5);
        GeoStanBase.putFieldLength(19, 11);
        GeoStanBase.putFieldLength(20, 41);
        GeoStanBase.putFieldLength(21, 41);
        GeoStanBase.putFieldLength(22, 3);
        GeoStanBase.putFieldLength(23, 3);
        GeoStanBase.putFieldLength(24, 3);
        GeoStanBase.putFieldLength(25, 3);
        GeoStanBase.putFieldLength(26, 29);
        GeoStanBase.putFieldLength(27, 5);
        GeoStanBase.putFieldLength(28, 5);
        GeoStanBase.putFieldLength(29, 12);
        GeoStanBase.putFieldLength(30, 5);
        GeoStanBase.putFieldLength(31, 6);
        GeoStanBase.putFieldLength(32, 5);
        GeoStanBase.putFieldLength(33, 10);
        GeoStanBase.putFieldLength(34, 11);
        GeoStanBase.putFieldLength(35, 2);
        GeoStanBase.putFieldLength(36, 12);
        GeoStanBase.putFieldLength(37, 12);
        GeoStanBase.putFieldLength(38, 12);
        GeoStanBase.putFieldLength(39, 2);
        GeoStanBase.putFieldLength(40, 2);
        GeoStanBase.putFieldLength(41, 2);
        GeoStanBase.putFieldLength(42, 16);
        GeoStanBase.putFieldLength(43, 16);
        GeoStanBase.putFieldLength(44, 2);
        GeoStanBase.putFieldLength(45, 5);
        GeoStanBase.putFieldLength(46, 5);
        GeoStanBase.putFieldLength(47, 66);
        GeoStanBase.putFieldLength(48, 81);
        GeoStanBase.putFieldLength(52, 5);
        GeoStanBase.putFieldLength(53, 5);
        GeoStanBase.putFieldLength(57, 2);
        GeoStanBase.putFieldLength(58, 7);
        GeoStanBase.putFieldLength(59, 41);
        GeoStanBase.putFieldLength(60, 12);
        GeoStanBase.putFieldLength(61, 12);
        GeoStanBase.putFieldLength(62, 31);
        GeoStanBase.putFieldLength(63, 10);
        GeoStanBase.putFieldLength(64, 6);
        GeoStanBase.putFieldLength(64, 6);
        GeoStanBase.putFieldLength(65, 128);
        GeoStanBase.putFieldLength(66, 3);
        GeoStanBase.putFieldLength(67, 4);
        GeoStanBase.putFieldLength(68, 104);
        GeoStanBase.putFieldLength(69, 104);
        GeoStanBase.putFieldLength(70, 104);
        GeoStanBase.putFieldLength(71, 104);
        GeoStanBase.putFieldLength(72, 104);
        GeoStanBase.putFieldLength(73, 104);
        GeoStanBase.putFieldLength(74, 2);
        GeoStanBase.putFieldLength(75, 5);
        GeoStanBase.putFieldLength(76, 2);
        GeoStanBase.putFieldLength(77, 2);
        GeoStanBase.putFieldLength(78, 2);
        GeoStanBase.putFieldLength(79, 2);
        GeoStanBase.putFieldLength(80, 2);
        GeoStanBase.putFieldLength(81, 2);
        GeoStanBase.putFieldLength(82, 2);
        GeoStanBase.putFieldLength(83, 2);
        GeoStanBase.putFieldLength(84, 61);
        GeoStanBase.putFieldLength(85, 61);
        GeoStanBase.putFieldLength(87, 5);
        GeoStanBase.putFieldLength(86, 0);
        GeoStanBase.putFieldLength(88, 5);
        GeoStanBase.putFieldLength(89, 9);
        GeoStanBase.putFieldLength(98, 2);
        GeoStanBase.putFieldLength(99, 2);
        GeoStanBase.putFieldLength(100, 2);
        GeoStanBase.putFieldLength(512, 12);
        GeoStanBase.putFieldLength(513, 5);
        GeoStanBase.putFieldLength(514, 29);
        GeoStanBase.putFieldLength(515, 29);
        GeoStanBase.putFieldLength(516, 2);
        GeoStanBase.putFieldLength(517, 11);
        GeoStanBase.putFieldLength(518, 2);
        GeoStanBase.putFieldLength(519, 2);
        GeoStanBase.putFieldLength(520, 2);
        GeoStanBase.putFieldLength(521, 6);
        GeoStanBase.putFieldLength(522, 128);
        GeoStanBase.putFieldLength(523, 4);
        GeoStanBase.putFieldLength(524, 128);
        GeoStanBase.putFieldLength(525, 6);
        GeoStanBase.putFieldLength(526, 128);
        GeoStanBase.putFieldLength(527, 2);
        GeoStanBase.putFieldLength(528, 2);
        GeoStanBase.putFieldLength(529, 2);
        GeoStanBase.putFieldLength(530, 2);
        GeoStanBase.putFieldLength(531, 3);
        GeoStanBase.putFieldLength(532, 3);
        GeoStanBase.putFieldLength(533, 3);
        GeoStanBase.putFieldLength(534, 3);
        GeoStanBase.putFieldLength(535, 3);
        GeoStanBase.putFieldLength(536, 3);
        GeoStanBase.putFieldLength(537, 2);
        GeoStanBase.putFieldLength(538, 2);
        GeoStanBase.putFieldLength(539, 3);
        GeoStanBase.putFieldLength(540, 3);
        GeoStanBase.putFieldLength(541, 11);
        GeoStanBase.putFieldLength(542, 5);
        GeoStanBase.putFieldLength(543, 11);
        GeoStanBase.putFieldLength(544, 8);
        GeoStanBase.putFieldLength(545, 6);
        GeoStanBase.putFieldLength(546, 4);
        GeoStanBase.putFieldLength(547, 301);
        GeoStanBase.putFieldLength(548, 41);
        GeoStanBase.putFieldLength(549, 6);
        GeoStanBase.putFieldLength(550, 6);
        GeoStanBase.putFieldLength(551, 46);
        GeoStanBase.putFieldLength(552, 11);
        GeoStanBase.putFieldLength(553, 3);
        GeoStanBase.putFieldLength(554, 4);
        GeoStanBase.putFieldLength(555, 29);
        GeoStanBase.putFieldLength(556, 61);
        GeoStanBase.putFieldLength(557, 61);
        GeoStanBase.putFieldLength(558, 41);
        GeoStanBase.putFieldLength(559, 3);
        GeoStanBase.putFieldLength(560, 3);
        GeoStanBase.putFieldLength(561, 5);
        GeoStanBase.putFieldLength(562, 41);
        GeoStanBase.putFieldLength(563, 3);
        GeoStanBase.putFieldLength(564, 3);
        GeoStanBase.putFieldLength(565, 5);
        GeoStanBase.putFieldLength(567, 2);
        GeoStanBase.putFieldLength(568, 3);
        GeoStanBase.putFieldLength(569, 2);
        GeoStanBase.putFieldLength(570, 2);
        GeoStanBase.putFieldLength(571, 6);
        GeoStanBase.putFieldLength(572, 2);
        GeoStanBase.putFieldLength(573, 2);
        GeoStanBase.putFieldLength(574, 11);
        GeoStanBase.putFieldLength(575, 12);
        GeoStanBase.putFieldLength(576, 12);
        GeoStanBase.putFieldLength(577, 2);
        GeoStanBase.putFieldLength(578, 2);
        GeoStanBase.putFieldLength(579, 16);
        GeoStanBase.putFieldLength(580, 16);
        GeoStanBase.putFieldLength(581, 2);
        GeoStanBase.putFieldLength(582, 2);
        GeoStanBase.putFieldLength(583, 3);
        GeoStanBase.putFieldLength(584, 6);
        GeoStanBase.putFieldLength(585, 128);
        GeoStanBase.putFieldLength(586, 6);
        GeoStanBase.putFieldLength(587, 128);
        GeoStanBase.putFieldLength(588, 4);
        GeoStanBase.putFieldLength(589, 128);
        GeoStanBase.putFieldLength(590, 6);
        GeoStanBase.putFieldLength(591, 128);
        GeoStanBase.putFieldLength(592, 2);
        GeoStanBase.putFieldLength(593, 3);
        GeoStanBase.putFieldLength(595, 13);
        GeoStanBase.putFieldName(1, "ADDRLINE");
        GeoStanBase.putFieldName(2, "BLOCK");
        GeoStanBase.putFieldName(3, "CART");
        GeoStanBase.putFieldName(4, "CHECK_DIGIT");
        GeoStanBase.putFieldName(5, "CITY");
        GeoStanBase.putFieldName(6, "DIST");
        GeoStanBase.putFieldName(7, "DPBC");
        GeoStanBase.putFieldName(8, "HIRANGE");
        GeoStanBase.putFieldName(9, "HOUSE_NUMBER");
        GeoStanBase.putFieldName(566, "HOUSE_NUMBER2");
        GeoStanBase.putFieldName(10, "LAST_LINE");
        GeoStanBase.putFieldName(11, "LAT");
        GeoStanBase.putFieldName(14, "LOC_CODE");
        GeoStanBase.putFieldName(15, "LON");
        GeoStanBase.putFieldName(16, "LORANGE");
        GeoStanBase.putFieldName(17, "MATCH_CODE");
        GeoStanBase.putFieldName(19, "MM_RESULT_CODE");
        GeoStanBase.putFieldName(20, "NAME");
        GeoStanBase.putFieldName(21, "NAME2");
        GeoStanBase.putFieldName(22, "POSTDIR");
        GeoStanBase.putFieldName(23, "POSTDIR2");
        GeoStanBase.putFieldName(24, "PREDIR");
        GeoStanBase.putFieldName(25, "PREDIR2");
        GeoStanBase.putFieldName(26, "STATE");
        GeoStanBase.putFieldName(27, "TYPE");
        GeoStanBase.putFieldName(28, "TYPE2");
        GeoStanBase.putFieldName(29, "UNIT_NUMBER");
        GeoStanBase.putFieldName(30, "UNIT_TYPE");
        GeoStanBase.putFieldName(31, "ZIP");
        GeoStanBase.putFieldName(32, "ZIP4");
        GeoStanBase.putFieldName(33, "ZIP9");
        GeoStanBase.putFieldName(34, "ZIP10");
        GeoStanBase.putFieldName(35, "INTERSECTION");
        GeoStanBase.putFieldName(36, "HIUNIT");
        GeoStanBase.putFieldName(37, "LOUNIT");
        GeoStanBase.putFieldName(38, "SCORE");
        GeoStanBase.putFieldName(39, "STREET_SIDE");
        GeoStanBase.putFieldName(40, "SEGMENT_PARITY");
        GeoStanBase.putFieldName(41, "RANGE_PARITY");
        GeoStanBase.putFieldName(42, "BLOCK_LEFT");
        GeoStanBase.putFieldName(43, "BLOCK_RIGHT");
        GeoStanBase.putFieldName(44, "SEGMENT_DIRECTION");
        GeoStanBase.putFieldName(45, "LOZIP4");
        GeoStanBase.putFieldName(46, "HIZIP4");
        GeoStanBase.putFieldName(47, "MSA");
        GeoStanBase.putFieldName(48, "CMSA");
        GeoStanBase.putFieldName(52, "MSA_NUMBER");
        GeoStanBase.putFieldName(53, "CMSA_NUMBER");
        GeoStanBase.putFieldName(57, "REC_TYPE");
        GeoStanBase.putFieldName(58, "CTYST_KEY");
        GeoStanBase.putFieldName(59, "FIRM_NAME");
        GeoStanBase.putFieldName(60, "SEG_LORANGE");
        GeoStanBase.putFieldName(61, "SEG_HIRANGE");
        GeoStanBase.putFieldName(62, "URB_NAME");
        GeoStanBase.putFieldName(63, "QCITY");
        GeoStanBase.putFieldName(64, "COUNTY");
        GeoStanBase.putFieldName(64, "COUNTY_FIPS");
        GeoStanBase.putFieldName(65, "COUNTY_NAME");
        GeoStanBase.putFieldName(66, "ROAD_CLASS");
        GeoStanBase.putFieldName(67, "IS_ALIAS");
        GeoStanBase.putFieldName(68, "LINE1");
        GeoStanBase.putFieldName(69, "LINE2");
        GeoStanBase.putFieldName(70, "LINE3");
        GeoStanBase.putFieldName(71, "LINE4");
        GeoStanBase.putFieldName(72, "LINE5");
        GeoStanBase.putFieldName(73, "LINE6");
        GeoStanBase.putFieldName(74, "LOT_CODE");
        GeoStanBase.putFieldName(75, "LOT_NUM");
        GeoStanBase.putFieldName(76, "LACS_FLAG");
        GeoStanBase.putFieldName(77, "GOVT_FLAG");
        GeoStanBase.putFieldName(78, "ALT_FLAG");
        GeoStanBase.putFieldName(79, "ZIP_CLASS");
        GeoStanBase.putFieldName(80, "ZIP_FACILITY");
        GeoStanBase.putFieldName(81, "ZIP_CITY_DELV");
        GeoStanBase.putFieldName(82, "ZIP_CARRT_SORT");
        GeoStanBase.putFieldName(83, "ZIP_UNIQUE");
        GeoStanBase.putFieldName(84, "MAIL_STOP");
        GeoStanBase.putFieldName(85, "ADDR2");
        GeoStanBase.putFieldName(87, "RESOLVED_LINE");
        GeoStanBase.putFieldName(86, "SEG_LENGTH");
        GeoStanBase.putFieldName(88, "PMB_DESIGNATOR");
        GeoStanBase.putFieldName(89, "PMB_NUMBER");
        GeoStanBase.putFieldName(98, "HI_RISE_DFLT");
        GeoStanBase.putFieldName(99, "R_RTE_DFLT");
        GeoStanBase.putFieldName(100, "DFLT");
        GeoStanBase.putFieldName(512, "UNIT_NUMBER2");
        GeoStanBase.putFieldName(513, "UNIT_TYPE2");
        GeoStanBase.putFieldName(514, "PREF_CITY");
        GeoStanBase.putFieldName(515, "NAME_CITY");
        GeoStanBase.putFieldName(516, "EWS_MATCH");
        GeoStanBase.putFieldName(517, "SEGMENT_ID");
        GeoStanBase.putFieldName(518, "BLOCK_SFX");
        GeoStanBase.putFieldName(519, "BLOCK_SFX_LEFT");
        GeoStanBase.putFieldName(520, "BLOCK_SFX_RIGHT");
        GeoStanBase.putFieldName(521, "CBSA_NUMBER");
        GeoStanBase.putFieldName(522, "CBSA_NAME");
        GeoStanBase.putFieldName(523, "CSA_NUMBER");
        GeoStanBase.putFieldName(524, "CSA_NAME");
        GeoStanBase.putFieldName(525, "CBSA_DIVISION_NUMBER");
        GeoStanBase.putFieldName(526, "CBSA_DIVISION_NAME");
        GeoStanBase.putFieldName(527, "METRO_FLAG");
        GeoStanBase.putFieldName(528, "DPV_CONFIRM");
        GeoStanBase.putFieldName(529, "DPV_CMRA");
        GeoStanBase.putFieldName(530, "DPV_FALSE_POS");
        GeoStanBase.putFieldName(531, "DPV_FOOTNOTE1");
        GeoStanBase.putFieldName(532, "DPV_FOOTNOTE2");
        GeoStanBase.putFieldName(533, "DPV_FOOTNOTE3");
        GeoStanBase.putFieldName(534, "DPV_FOOTNOTE4");
        GeoStanBase.putFieldName(535, "DPV_FOOTNOTE5");
        GeoStanBase.putFieldName(536, "DPV_FOOTNOTE6");
        GeoStanBase.putFieldName(537, "UNIT_RANGE_PARITY");
        GeoStanBase.putFieldName(538, "LACSLINK_IND");
        GeoStanBase.putFieldName(539, "LACSLINK_RETCODE");
        GeoStanBase.putFieldName(540, "DATATYPE");
        GeoStanBase.putFieldName(541, "POINT_ID");
        GeoStanBase.putFieldName(542, "SEARCH_DIST");
        GeoStanBase.putFieldName(543, "SQUEEZE_DIST");
        GeoStanBase.putFieldName(544, "NEAREST_DIST");
        GeoStanBase.putFieldName(545, "PERCENT_GEOCODE");
        GeoStanBase.putFieldName(546, "OFFSET_DIST");
        GeoStanBase.putFieldName(547, "AUX_USERDATA");
        GeoStanBase.putFieldName(548, "MCD_NAME");
        GeoStanBase.putFieldName(549, "MCD_NUMBER");
        GeoStanBase.putFieldName(550, "BEARING");
        GeoStanBase.putFieldName(551, "APN_ID");
        GeoStanBase.putFieldName(552, "PARCEN_ELEVATION");
        GeoStanBase.putFieldName(553, "STATE_FIPS");
        GeoStanBase.putFieldName(554, "CENTERLINE_OFFSET_DIST");
        GeoStanBase.putFieldName(555, "CITY_SHORT");
        GeoStanBase.putFieldName(556, "LASTLINE_SHORT");
        GeoStanBase.putFieldName(557, "ADDRLINE_SHORT");
        GeoStanBase.putFieldName(558, "NAME_SHORT");
        GeoStanBase.putFieldName(559, "PREDIR_SHORT");
        GeoStanBase.putFieldName(560, "POSTDIR_SHORT");
        GeoStanBase.putFieldName(561, "TYPE_SHORT");
        GeoStanBase.putFieldName(562, "NAME2_SHORT");
        GeoStanBase.putFieldName(563, "PREDIR2_SHORT");
        GeoStanBase.putFieldName(564, "POSTDIR2_SHORT");
        GeoStanBase.putFieldName(565, "TYPE2_SHORT");
        GeoStanBase.putFieldName(567, "CLOSE_MATCH");
        GeoStanBase.putFieldName(568, "SUITELINK_RET_CODE");
        GeoStanBase.putFieldName(569, "DPV_VACANT");
        GeoStanBase.putFieldName(570, "DPV_NO_STAT");
        GeoStanBase.putFieldName(571, "MATCHED_DB");
        GeoStanBase.putFieldName(572, "DPV_SHUTDOWN");
        GeoStanBase.putFieldName(573, "LACSLINK_SHUTDOWN");
        GeoStanBase.putFieldName(86, "SEG_LENGTH");
        GeoStanBase.putFieldName(574, "SEGMENT_ID2");
        GeoStanBase.putFieldName(575, "SEG_LORANGE2");
        GeoStanBase.putFieldName(576, "SEG_HIRANGE2");
        GeoStanBase.putFieldName(577, "SEGMENT_PARITY2");
        GeoStanBase.putFieldName(578, "SEGMENT_DIRECTION2");
        GeoStanBase.putFieldName(579, "BLOCK_LEFT2");
        GeoStanBase.putFieldName(580, "BLOCK_RIGHT2");
        GeoStanBase.putFieldName(581, "BLOCK_SFX_LEFT2");
        GeoStanBase.putFieldName(582, "BLOCK_SFX_RIGHT2");
        GeoStanBase.putFieldName(583, "ROAD_CLASS2");
        GeoStanBase.putFieldName(584, "COUNTY2");
        GeoStanBase.putFieldName(585, "COUNTY_NAME2");
        GeoStanBase.putFieldName(586, "CBSA_NUMBER2");
        GeoStanBase.putFieldName(587, "CBSA_NAME2");
        GeoStanBase.putFieldName(588, "CSA_NUMBER2");
        GeoStanBase.putFieldName(589, "CSA_NAME2");
        GeoStanBase.putFieldName(590, "CBSA_DIVISION_NUMBER2");
        GeoStanBase.putFieldName(591, "CBSA_DIVISION_NAME2");
        GeoStanBase.putFieldName(592, "METRO_FLAG2");
        GeoStanBase.putFieldName(593, "DATATYPE2");
        GeoStanBase.putFieldName(595, "PB_KEY");
        FIELD_LENGTHS = Collections.unmodifiableMap(fieldLengths);
        FIELD_IDS = Collections.unmodifiableMap(fieldIds);
    }

    public static class CityField {
        public static final short CITY_NAME = 0;
        public static final short CITY_PREFNAME = 1;
        public static final short CITY_MAILIND = 2;
        public static final short CITY_FACILITY = 3;
        public static final short CITY_ZIP = 4;
        public static final short CITY_STATE = 5;
        public static final short CITY_QCITY = 6;
        public static final short CITY_COUNT = 7;
        public static final short CITY_CITYID = 8;
        public static final short CITY_CTYSTKEY = 9;
        public static final short CITY_CLASS = 10;
        public static final short CITY_CITYDELV = 11;
        public static final short CITY_CARRTSORT = 12;
        public static final short CITY_UNIQUE = 13;
        public static final short CITY_RESERVED1 = 14;
        public static final short CITY_RESERVED2 = 15;
        public static final short CITY_IS_ABBREV = 16;
    }

    public static class DataSetStatus {
        public static final short STATUS_DATATYPE_NUM = 0;
        public static final short STATUS_DATUM_NUM = 2;
        public static final short STATUS_FILE_CHKSUM_NUM = 4;
        public static final short STATUS_RECORDS_REMAINING = 5;
        public static final short STATUS_DAYS_REMAINING = 6;
        public static final short STATUS_GEO_RECORD_TOTAL = 7;
        public static final short STATUS_GEO_PRECISION = 8;
        public static final short STATUS_DB_COPYRIGHT = 9;
        public static final short STATUS_DB_COUNTRY = 10;
        public static final short STATUS_DB_VERSION = 11;
        public static final short STATUS_DB_FILE_PATH = 12;
        public static final short GET_FILE_STATUS_FLAGS = 10000;
        public static final short USPS_PUBLISH_DATE = 10001;
        public static final long RECORDS_UNLIMITED = Integer.MAX_VALUE;
        public static final long DAYS_UNLIMITED = Integer.MAX_VALUE;
        public static final short DATATYPE_ERROR = -1;
        public static final short DATATYPE_USPS = 0;
        public static final short DATATYPE_TIGER = 1;
        public static final short DATATYPE_GDT = 2;
        public static final short DATATYPE_TOMTOM = 2;
        public static final short DATATYPE_POINT_DATA = 3;
        public static final short DATATYPE_SANBORN_POINT = 3;
        public static final short DATATYPE_TELE_ATLAS = 4;
        public static final short DATATYPE_GEOSYS = 5;
        public static final short DATATYPE_NAVTEQ = 6;
        public static final short DATATYPE_TANA_POINT = 7;
        public static final short DATATYPE_TOMTOM_POINT = 7;
        public static final short DATATYPE_GDR_POINT = 8;
        public static final short DATATYPE_CENTRUS_POINT = 8;
        public static final short DATATYPE_AUXILIARY = 9;
        public static final short DATATYPE_USER_DICTIONARY = 10;
        public static final short DATATYPE_NAVTEQ_POINT = 11;
        public static final short DATATYPE_MASTER_LOCATION = 12;
        private static final short N_DATATYPES = 12;
        static final String[] DATATYPE_NAMES = new String[]{"USPS", "TIGER", "TOMTOM", "SANBORN POINT DATA", "TELE ATLAS", "GEOSYS", "NAVTEQ", "TOMTOM POINT DATA", "CENTRUS POINT DATA", "AUXILIARY", "USER DICTIONARY", "NAVTEQ POINT DATA", "MASTER LOCATION"};
        public static final short DATUM_ERROR = -1;
        public static final short DATUM_NAD27 = 0;
        public static final short DATUM_NAD83 = 1;
        static final String[] DATUM_NAMES = new String[]{"NAD27", "NAD83"};
        public static final short FILE_EXISTS = 1;
        public static final short SUPP_EXISTS = 2;
        public static final short STATEWIDE_EXISTS = 4;
        public static final short GSL_EXISTS = 8;
        public static final short AUXILIARY_EXISTS = 16;
        public static final short ZIPMOVE_EXISTS = 32;
        public static final short ZIP9_IDX_EXISTS = 64;
        public static final short EWS_MATCH_EXISTS = 128;
        public static final short APN_EXISTS = 256;
        public static final short ELV_EXISTS = 512;
        public static final short UD_EXISTS = 1024;
        public static final short REV_ALIAS_EXISTS = 2048;
        public static final short CENTRUS_ALIAS_EXISTS = 4096;

        public static final String getDataTypeName(short dataTypeCode) throws IllegalArgumentException {
            if (dataTypeCode < 0 || dataTypeCode > 12) {
                throw new IllegalArgumentException("Invalid data type code: " + dataTypeCode);
            }
            return DATATYPE_NAMES[dataTypeCode];
        }

        public static final String getDatumName(short datumCode) throws IllegalArgumentException {
            if (datumCode < 0 || datumCode > 1) {
                throw new IllegalArgumentException("Invalid datum code: " + datumCode);
            }
            return DATUM_NAMES[datumCode];
        }

        public static final boolean hasStatusFlag(long statusReturn, short flag) {
            return ((short)statusReturn & flag) > 0;
        }
    }

    public static class MatchCode {
        public static final short MATCH_OK = 0;
        public static final short MATCH_ERROR = 1;
        public static final short MATCH_NO_FILE = 2;
        public static final short MATCH_BAD_FILE = 3;
        public static final short MATCH_FILE_EXPIRED = 4;
        public static final short MATCH_NO_LOCALE = 10;
        public static final short MATCH_ZIP_NOT_FOUND = 11;
        public static final short MATCH_CITY_NOT_FOUND = 12;
        public static final short MATCH_CITY_NOT_RESOLVED = 13;
        public static final short MATCH_NO_LICENSE = 14;
        public static final short MATCH_RECORDS_DEPLETED = 15;
        public static final short MATCH_NO_STREET = 20;
        public static final short MATCH_NO_STREET2 = 21;
        public static final short MATCH_NO_RANGE = 22;
        public static final short MATCH_UNRESOLVED = 23;
        public static final short MATCH_NO_SEGMENT = 24;
        public static final short MATCH_TOO_MANY = 25;
        public static final short MATCH_NO_ADDR_FOUND = 26;
        public static final short MATCH_INVALID_DIRECTION = 27;
        public static final short MATCH_EWS_DENIED = 28;
        public static final short MATCH_STREET_CENTROID = 29;
        public static final short MATCH_MULTI_ST_CENTROID = 30;
    }

    public static class Datum {
        public static final short DATUM_NAD27 = 0;
        public static final short DATUM_NAD83 = 1;

        public static boolean isValid(short datum) {
            switch (datum) {
                case 0: 
                case 1: {
                    return true;
                }
            }
            return false;
        }

        public static boolean isValid(String datum) {
            return datum.equals(DataSetStatus.DATUM_NAMES[0]) || datum.equals(DataSetStatus.DATUM_NAMES[1]);
        }
    }

    public static class MatchMode {
        public static final short MODE_EXACT = 0;
        public static final short MODE_CLOSE = 1;
        public static final short MODE_RELAX = 2;
        public static final short MODE_CASS = 4;
        public static final short MODE_CASS_NODATE = 5;
        public static final short MODE_PARTIAL = 6;
        public static final short MODE_CUSTOM = 7;
        public static final short MODE_INTERACTIVE = 8;

        public static boolean isValid(short option) {
            switch (option) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Find {
        private static boolean debug = false;
        public static final short ADDR_CODE = 1;
        public static final short GEO_CODE = 1024;
        public static final short Z9_CODE = 2;
        public static final short Z7_CODE = 16;
        public static final short Z5_CODE = 32;
        public static final short Z_CODE = 50;
        public static final short ALWAYS_FIND_CANDIDATES = 64;
        public static final short WIDE_SEARCH = 4;
        public static final short FINANCE_SEARCH = 8;
        public static final short PREFER_POBOX = 256;
        public static final short PREFER_STREET = 512;
        public static final short BUILDING_SEARCH = 2048;
        public static final short NEAREST_ADDRESS = 4096;
        public static final short NEAREST_INTERSECTION = 8192;
        public static final short NEAREST_UNRANGED = 16384;
        public static final short APN_SEARCH = 128;
        public static final short STREET_ZIP_SEARCH = 16;
        public static final short STREET_CITY_SEARCH = 32;
        public static final short STREET_SDX_SEARCH = 64;
        public static final short STREET_STATE_SEARCH = 128;
        public static final short STREET_EXTRA_SEARCH = 256;
        public static final short STREET_FIRM_SEARCH = 512;

        public static boolean isValid(short option) {
            switch (option) {
                case 1: 
                case 2: 
                case 4: 
                case 8: 
                case 16: 
                case 32: 
                case 50: 
                case 64: 
                case 128: 
                case 256: 
                case 512: 
                case 1024: 
                case 2048: 
                case 4096: 
                case 8192: 
                case 16384: {
                    return true;
                }
            }
            return false;
        }

        public static boolean hasOption(short value, short option) {
            if (!Find.isValid(option)) {
                return false;
            }
            if (debug) {
                System.out.println("hasOption:  value = " + value + ", option = " + option + ", result = " + ((value & option) == 0 ? "N" : "Y"));
            }
            if (option == 50) {
                return (value & 0x20) != 0 && (value & 0x10) != 0 && (value & 2) != 0;
            }
            return (value & option) != 0;
        }

        public static short setOption(short value, short option, boolean add) {
            short newValue = value;
            if (add && !Find.hasOption(value, option)) {
                newValue = (short)(newValue + option);
                if (debug) {
                    System.out.println("added option: " + option);
                }
            } else if (!add && Find.hasOption(value, option)) {
                newValue = (short)(newValue - option);
                if (debug) {
                    System.out.println("removed option: " + option);
                }
            }
            return newValue;
        }

        public static String dump(short value) {
            String s = new String("Value = " + value + ": ");
            if (Find.hasOption(value, (short)1)) {
                s = s + "ADDR_CODE  ";
            }
            if (Find.hasOption(value, (short)1024)) {
                s = s + "GEO_CODE  ";
            }
            if (Find.hasOption(value, (short)50)) {
                s = s + "Z_CODE  ";
            } else {
                if (Find.hasOption(value, (short)2)) {
                    s = s + "Z9_CODE  ";
                }
                if (Find.hasOption(value, (short)16)) {
                    s = s + "Z7_CODE  ";
                }
                if (Find.hasOption(value, (short)32)) {
                    s = s + "Z5_CODE  ";
                }
            }
            if (Find.hasOption(value, (short)64)) {
                s = s + "ALWAYS_FIND_CANDIDATES  ";
            }
            if (Find.hasOption(value, (short)4)) {
                s = s + "WIDE_SEARCH  ";
            }
            if (Find.hasOption(value, (short)8)) {
                s = s + "FINANCE_SEARCH  ";
            }
            if (Find.hasOption(value, (short)256)) {
                s = s + "PREFER_POBOX  ";
            }
            if (Find.hasOption(value, (short)512)) {
                s = s + "PREFER_STREET  ";
            }
            if (Find.hasOption(value, (short)2048)) {
                s = s + "BUILDING_SEARCH  ";
            }
            if (Find.hasOption(value, (short)4096)) {
                s = s + "NEAREST_ADDRESS  ";
            }
            if (Find.hasOption(value, (short)16384)) {
                s = s + "NEAREST_UNRANGED  ";
            }
            if (Find.hasOption(value, (short)8192)) {
                s = s + "NEAREST_INTERSECTION  ";
            }
            if (Find.hasOption(value, (short)128)) {
                s = s + "APN_SEARCH  ";
            }
            return s;
        }
    }
}

