/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import com.centrus.geostan.GeoStan;
import com.centrus.geostan.GeoStanException;
import com.centrus.geostan.GeographicQuery;
import com.centrus.geostan.GeographicQueryEx;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GeographicIterator
implements Iterator {
    private GeoStan m_Geostan = null;
    private boolean m_bNeedNext = false;
    private GeographicQuery m_GeoQuery = null;
    private boolean m_bGotFirst = false;
    private short m_NextGeographicStatus = 0;

    GeographicIterator(GeoStan geostan, String city, String county, String state) {
        this.m_Geostan = geostan;
        this.m_GeoQuery = this.makeGeographicQuery(city, county, state);
        this.m_bNeedNext = true;
    }

    GeographicIterator(GeoStan geostan, String city, String county, String state, long geoVer) {
        this.m_Geostan = geostan;
        this.m_GeoQuery = this.makeGeographicQuery(city, county, state, geoVer);
        this.m_bNeedNext = true;
    }

    protected GeographicQuery makeGeographicQuery(String city, String county, String state) {
        return new GeographicQuery(city, county, state);
    }

    protected GeographicQuery makeGeographicQuery(String city, String county, String state, long geostanVer) {
        return new GeographicQueryEx(city, county, state, geostanVer);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Geographic elements cannot be removed.");
    }

    @Override
    public boolean hasNext() {
        if (this.m_bNeedNext) {
            this.getNext();
            this.m_bNeedNext = false;
        }
        return this.m_NextGeographicStatus == 0;
    }

    public Object next() {
        if (this.m_bNeedNext) {
            this.getNext();
        } else {
            this.m_bNeedNext = true;
        }
        if (this.m_NextGeographicStatus == 1) {
            throw new NoSuchElementException("Invalid geographic match");
        }
        return this.m_GeoQuery;
    }

    private void getNext() {
        if (this.m_Geostan == null) {
            throw new NoSuchElementException("Invalid GeoStan object");
        }
        try {
            if (!this.m_bGotFirst) {
                this.m_NextGeographicStatus = this.m_Geostan.findFirstGeographic(this.m_GeoQuery);
                this.m_bGotFirst = true;
            } else {
                this.m_NextGeographicStatus = this.m_Geostan.findNextGeographic(this.m_GeoQuery);
            }
        }
        catch (GeoStanException ex) {
            throw new NoSuchElementException(ex.getMessage());
        }
    }
}

